/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.postscript;

import org.freehep.postscript.ImageOperator;
import org.freehep.postscript.OperandStack;
import org.freehep.postscript.PSBoolean;
import org.freehep.postscript.PSInteger;
import org.freehep.postscript.PSObject;
import org.freehep.postscript.PSPackedArray;
import org.freehep.postscript.RangeCheck;
import org.freehep.postscript.TypeCheck;

class ColorImage
extends ImageOperator {
    ColorImage() {
    }

    @Override
    public boolean execute(OperandStack os) {
        PSObject[] ds;
        PSPackedArray d;
        if (!os.checkType(PSBoolean.class, PSInteger.class)) {
            ColorImage.error(os, new TypeCheck());
            return true;
        }
        int ncomp = os.popInteger().getValue();
        boolean multi = os.popBoolean().getValue();
        switch (ncomp) {
            case 1: {
                d = new PSPackedArray(new float[]{0.0f, 1.0f});
                break;
            }
            case 3: {
                d = new PSPackedArray(new float[]{0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f});
                break;
            }
            case 4: {
                d = new PSPackedArray(new float[]{0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f});
                break;
            }
            default: {
                ColorImage.error(os, new RangeCheck());
                return true;
            }
        }
        if (multi) {
            ds = new PSObject[ncomp];
            for (int i = ncomp - 1; i >= 0; --i) {
                ds[i] = os.popObject();
            }
        } else {
            ds = new PSObject[]{os.popObject()};
        }
        if (!os.checkType(PSInteger.class, PSInteger.class, PSInteger.class, PSPackedArray.class)) {
            ColorImage.error(os, new TypeCheck());
            return true;
        }
        PSPackedArray m = os.popPackedArray();
        int b = os.popInteger().getValue();
        int h = os.popInteger().getValue();
        int w = os.popInteger().getValue();
        try {
            ImageOperator ci = new ImageOperator(false, w, h, b, m, ds, d, false);
            os.execStack().pop();
            os.execStack().push(ci);
            return false;
        }
        catch (IllegalArgumentException e) {
            ColorImage.error(os, new TypeCheck());
            return true;
        }
        catch (ClassCastException e) {
            ColorImage.error(os, new TypeCheck());
            return true;
        }
    }
}

