/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.swf;

import java.awt.Color;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Properties;
import org.freehep.graphicsbase.util.images.ImageUtilities;
import org.freehep.graphicsio.ImageGraphics2D;
import org.freehep.graphicsio.swf.DefinitionTag;
import org.freehep.graphicsio.swf.SWFInputStream;
import org.freehep.graphicsio.swf.SWFOutputStream;
import org.freehep.graphicsio.swf.SWFTag;

public class DefineBitsJPEG2
extends DefinitionTag {
    protected int character;
    protected RenderedImage image;
    protected Properties options;
    private byte[] imageBytes;

    public DefineBitsJPEG2(int id, Image image, Properties options, Color bkg, ImageObserver observer) {
        this(id, ImageUtilities.createRenderedImage(image, observer, bkg), bkg, options);
    }

    public DefineBitsJPEG2(int id, RenderedImage image, Color bkg, Properties options) {
        this();
        this.character = id;
        this.image = image;
        this.options = options;
    }

    public DefineBitsJPEG2() {
        super(21, 2);
    }

    protected DefineBitsJPEG2(int tag, int level) {
        super(tag, level);
    }

    @Override
    public SWFTag read(int tagID, SWFInputStream swf, int len) throws IOException {
        DefineBitsJPEG2 tag = new DefineBitsJPEG2();
        tag.character = swf.readUnsignedShort();
        swf.getDictionary().put(tag.character, tag);
        byte[] data = swf.readByte(len - 2);
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        tag.image = ImageGraphics2D.readImage("JPG".toLowerCase(), bais);
        if (bais.available() > 0) {
            System.err.println("DefineBitsJPEG2: not all bytes read: " + bais.available());
        }
        return tag;
    }

    @Override
    public void write(int tagID, SWFOutputStream swf) throws IOException {
        swf.writeUnsignedShort(this.character);
        swf.write(this.getImageBytes());
    }

    public int getLength() throws IOException {
        return this.getImageBytes().length + 2;
    }

    private byte[] getImageBytes() throws IOException {
        if (this.imageBytes == null) {
            this.imageBytes = ImageGraphics2D.toByteArray(this.image, "JPG", null, this.options);
        }
        return this.imageBytes;
    }

    @Override
    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append(super.toString() + "\n");
        s.append("  character:  " + this.character + "\n");
        s.append("  image:      " + this.image + "\n");
        return s.toString();
    }
}

