/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.cgm;

import java.io.IOException;
import org.freehep.graphicsio.cgm.CGMOutputStream;
import org.freehep.graphicsio.cgm.CGMTag;
import org.freehep.graphicsio.cgm.CGMWriter;

public class MetafileElementList
extends CGMTag {
    public static final int DRAWING_SET = 0;
    public static final int DRAWING_PLUS_SET = 1;
    public static final int VERSION_2_SET = 2;
    public static final int EXTENDED_PRIMITIVES_SET = 3;
    public static final int VERSION_2_GKSM_SET = 4;
    public static final int VERSION_3_SET = 5;
    public static final int VERSION_4_SET = 6;
    private int set;

    public MetafileElementList() {
        super(1, 11, 1);
    }

    public MetafileElementList(int set) {
        this();
        this.set = set;
    }

    @Override
    public void write(int tagID, CGMOutputStream cgm) throws IOException {
        cgm.writeInteger(1);
        cgm.writeIntegerIndex(-1);
        cgm.writeIntegerIndex(this.set);
    }

    @Override
    public void write(int tagID, CGMWriter cgm) throws IOException {
        cgm.print("MFELEMLIST ");
        switch (this.set) {
            default: {
                cgm.writeString("DRAWINGSET");
                break;
            }
            case 1: {
                cgm.writeString("DRAWINGPLUS");
                break;
            }
            case 2: {
                cgm.writeString("VERSION2");
                break;
            }
            case 3: {
                cgm.writeString("EXTDPRIM");
                break;
            }
            case 4: {
                cgm.writeString("VERSION2GKSM");
                break;
            }
            case 5: {
                cgm.writeString("VERSION3");
                break;
            }
            case 6: {
                cgm.writeString("VERSION4");
            }
        }
    }
}

