/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.aid;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.freehep.aid.AbstractGenerator;
import org.freehep.aid.AidUtil;
import org.freehep.rtti.IClass;
import org.freehep.rtti.IField;
import org.freehep.rtti.IMethod;
import org.freehep.rtti.INamedType;
import org.freehep.rtti.IType;
import org.freehep.util.UserProperties;
import org.freehep.util.io.IndentPrintWriter;

public abstract class AbstractJavaGenerator
extends AbstractGenerator {
    protected static final String language = "java";
    protected UserProperties importProperties = new UserProperties();
    protected UserProperties typeProperties = new UserProperties();
    protected UserProperties valueProperties = new UserProperties();
    protected UserProperties templateProperties = new UserProperties();
    protected UserProperties primitiveProperties = new UserProperties();
    private Map template;

    public AbstractJavaGenerator(String propDir) {
        AidUtil.loadProperties(this.properties, this.getClass(), propDir, "aid.java.properties");
        AidUtil.loadProperties(this.importProperties, this.getClass(), propDir, "aid.imports.java.properties");
        AidUtil.loadProperties(this.typeProperties, this.getClass(), propDir, "aid.types.java.properties");
        AidUtil.loadProperties(this.valueProperties, this.getClass(), propDir, "aid.values.java.properties");
        AidUtil.loadProperties(this.templateProperties, this.getClass(), propDir, "aid.templates.java.properties");
        AidUtil.loadProperties(this.primitiveProperties, this.getClass(), propDir, "aid.primitives.java.properties");
    }

    @Override
    public String directory(IClass clazz) {
        String directory = clazz.getPackageName();
        return directory.replace('.', File.separatorChar);
    }

    @Override
    public abstract String filename(IClass var1);

    protected boolean isClass(IClass clazz) {
        return clazz.isClass();
    }

    @Override
    public boolean print(File file, IClass clazz) throws IOException {
        IndentPrintWriter out = new IndentPrintWriter(new PrintWriter(new BufferedWriter(new FileWriter(file))));
        out.setIndentString("    ");
        this.printEnumFields(file, clazz);
        this.printHeader(out, clazz);
        this.printImportStatements(out, clazz);
        this.printClassHeader(out, clazz);
        String[] concrete = this.getConcrete(clazz);
        if (concrete == null) {
            this.printClassMembers(out, clazz, null);
        } else {
            for (int i = 0; i < concrete.length; ++i) {
                StringBuffer innerClassName = new StringBuffer();
                String[] templateVars = concrete[i].split(",");
                for (int j = 0; j < templateVars.length; ++j) {
                    String varName = templateVars[j].trim();
                    innerClassName.append(this.primitiveProperties.getProperty(varName, varName));
                }
                out.println();
                out.indent();
                out.println("/**");
                out.println("/* Template Instantiated Interface: " + clazz.getName() + "<" + concrete[i].trim() + ">");
                out.println("*/");
                out.print("public static interface ");
                out.print(innerClassName.toString());
                out.print(" extends ");
                out.print(clazz.getName());
                out.println(" {");
                this.printClassMembers(out, clazz, concrete[i]);
                out.println("} //" + clazz.getName() + "." + innerClassName.toString());
                out.outdent();
                out.println();
            }
        }
        this.printEOCComments(out, clazz);
        out.println("} // class or interface");
        this.printEOPComments(out, clazz);
        this.printEOFComments(out, clazz);
        out.println();
        out.close();
        return false;
    }

    private void printHeader(IndentPrintWriter out, IClass clazz) {
        this.warning(out);
        out.println();
        String[] packageComments = clazz.getPackageComments(language);
        for (int i = 0; i < packageComments.length; ++i) {
            out.println(packageComments[i]);
        }
        String packageName = this.getPackageName(clazz);
        if (!packageName.equals("")) {
            out.println("package " + packageName + ";");
        }
    }

    private void printEnumFields(File file, IClass clazz) throws IOException {
        IField[] enums = clazz.getEnumFields();
        for (int i = 0; i < enums.length; ++i) {
            IndentPrintWriter eout = new IndentPrintWriter(new BufferedWriter(new FileWriter(new File(file.getParentFile(), enums[i].getNamedType().getType().getName() + ".java"))));
            this.printHeader(eout, clazz);
            this.printField(eout, enums[i], false);
            eout.close();
        }
    }

    private void printClassMembers(IndentPrintWriter out, IClass clazz, String concrete) {
        this.template = this.getTemplateMap(clazz.getTemplateParameters(), concrete);
        IMethod[] methods = clazz.getMethods();
        if (methods.length > 0) {
            out.println();
        }
        for (int i = 0; i < methods.length; ++i) {
            if (i != 0) {
                out.println();
            }
            this.printMethod(out, clazz, methods[i], concrete != null);
        }
        IField[] fields = clazz.getFields();
        if (fields.length > 0) {
            out.println();
        }
        for (int i = 0; i < fields.length; ++i) {
            if (i != 0) {
                out.println();
            }
            this.printField(out, fields[i], true);
        }
    }

    protected abstract void printClassHeader(IndentPrintWriter var1, IClass var2);

    protected void printEOCComments(IndentPrintWriter out, IClass clazz) {
    }

    protected void printEOPComments(IndentPrintWriter out, IClass clazz) {
    }

    protected void printEOFComments(IndentPrintWriter out, IClass clazz) {
    }

    protected void printImportStatements(IndentPrintWriter out, IClass clazz) {
        TreeSet imports = new TreeSet();
        String packageName = clazz.getPackageName();
        String[] interfaces = clazz.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            this.importFrom(interfaces[i], packageName, imports);
        }
        IMethod[] methods = clazz.getMethods();
        for (int m = 0; m < methods.length; ++m) {
            this.importFrom(methods[m].getReturnType(), packageName, imports);
            INamedType[] parameterTypes = methods[m].getParameterTypes();
            for (int p = 0; p < parameterTypes.length; ++p) {
                this.importFrom(parameterTypes[p].getType(), packageName, imports);
            }
            String[] exceptionTypes = methods[m].getExceptionTypes();
            for (int e = 0; e < exceptionTypes.length; ++e) {
                this.importFrom(exceptionTypes[e], packageName, imports);
            }
        }
        IField[] fields = clazz.getFields();
        for (int i = 0; i < fields.length; ++i) {
            IType type = fields[i].getNamedType().getType();
            this.importFrom(type, packageName, imports);
        }
        out.println();
        Iterator i = imports.iterator();
        while (i.hasNext()) {
            out.println("import " + i.next() + ";");
        }
    }

    protected void importFrom(IType type, String packageName, SortedSet imports) {
        if (type.isPrimitive()) {
            return;
        }
        this.importFrom(type.getName(), packageName, imports);
    }

    protected void importFrom(String name, String packageName, SortedSet imports) {
        if (name == null) {
            return;
        }
        String importName = this.importProperties.getProperty(name = this.typeProperties.getProperty(name, name), null);
        if (!(importName == null || importName.equals("") || importName.equals("java.lang." + name) || importName.equals(packageName + "." + name))) {
            imports.add(importName);
        }
    }

    protected void printMethod(IndentPrintWriter out, IClass clazz, IMethod method, boolean useFullyQualifiedNames) {
        this.printMethod(out, clazz, method, useFullyQualifiedNames, method.getParameterTypes().length);
    }

    protected void printMethod(IndentPrintWriter out, IClass clazz, IMethod method, boolean useFullyQualifiedNames, int noOfParameters) {
        INamedType[] parameterTypes = method.getParameterTypes();
        if (noOfParameters > 0) {
            String init = parameterTypes[noOfParameters - 1].getInit();
            if (init != null) {
                init = this.valueProperties.getProperty(init, init);
            }
            if (init != null && !init.equals("")) {
                this.printMethod(out, clazz, method, useFullyQualifiedNames, noOfParameters - 1);
            }
        }
        this.printMethodComments(out, method, noOfParameters);
        this.printMethodHeader(out, clazz, method, useFullyQualifiedNames, noOfParameters);
        this.printMethodBody(out, clazz, method, noOfParameters);
    }

    protected void printMethodComments(IndentPrintWriter out, IMethod method, int noOfParameters) {
    }

    protected void printMethodHeader(IndentPrintWriter out, IClass clazz, IMethod method, boolean useFullyQualifiedNames, int noOfParameters) {
        int i;
        out.print("    public ");
        INamedType[] parameterTypes = method.getParameterTypes();
        if (this.isClass(clazz) && noOfParameters == parameterTypes.length) {
            out.print("abstract ");
        }
        HashMap methodTemplate = this.template;
        String[] templateParameters = method.getTemplateParameters();
        if (templateParameters.length > 0) {
            methodTemplate = new HashMap();
            String[] concrete = this.getConcrete(clazz);
            if (concrete == null) {
                out.print(" <");
                out.print(templateParameters[0]);
                for (i = 1; i < templateParameters.length; ++i) {
                    out.print(", ");
                    out.print(templateParameters[i]);
                }
                out.print("> ");
            } else {
                System.err.println("Cannot use templated methods in concrete template interfaces");
                System.exit(1);
            }
        }
        out.print(this.type(method.getReturnType(), methodTemplate, useFullyQualifiedNames));
        out.print(" ");
        out.print(method.getName());
        out.print("(");
        for (int i2 = 0; i2 < noOfParameters; ++i2) {
            out.print(this.namedType(parameterTypes[i2], methodTemplate, useFullyQualifiedNames));
            if (i2 >= noOfParameters - 1) continue;
            out.print(", ");
        }
        out.print(")");
        String[] exceptionTypes = method.getExceptionTypes();
        if (exceptionTypes.length > 0) {
            out.print(" throws ");
            for (i = 0; i < exceptionTypes.length; ++i) {
                out.print(exceptionTypes[i]);
                if (i >= exceptionTypes.length - 1) continue;
                out.print(", ");
            }
        }
    }

    protected void printMethodBody(IndentPrintWriter out, IClass clazz, IMethod method, int noOfParameters) {
        INamedType[] parameterTypes = method.getParameterTypes();
        if (!this.isClass(clazz) || noOfParameters == parameterTypes.length) {
            out.println(";");
        } else {
            out.println(" {");
            out.print("        ");
            if (!method.getReturnType().isVoid()) {
                out.print("return ");
            }
            out.print(method.getName() + "(");
            for (int i = 0; i < noOfParameters; ++i) {
                out.print(parameterTypes[i].getName());
                out.print(", ");
            }
            String init = parameterTypes[noOfParameters].getInit();
            init = this.valueProperties.getProperty(init, init);
            out.print(init);
            out.println(");");
            out.println("    }");
        }
    }

    protected void printField(IndentPrintWriter out, IField field, boolean innerClass) {
    }

    protected String namedType(INamedType namedType, Map template, boolean useFullyQualifiedNames) {
        return this.type(namedType.getType(), template, useFullyQualifiedNames) + " " + namedType.getName();
    }

    protected String type(IType type, Map template, boolean useFullyQualifiedNames) {
        return this.type(type, 0, template, useFullyQualifiedNames);
    }

    private String type(IType type, int nesting, Map template, boolean useFullyQualifiedNames) {
        StringBuffer s;
        block8: {
            IType[] types;
            block9: {
                String typeName;
                block7: {
                    types = type.getTypes();
                    s = new StringBuffer();
                    String string = typeName = type.isEnumeration() ? "int" : type.getName();
                    if (!typeName.equals("[]")) break block7;
                    s.append(this.type(types[0], template, useFullyQualifiedNames));
                    break block8;
                }
                String javaType = this.typeProperties.getProperty(typeName, typeName);
                if (template != null) {
                    String templateType = (String)template.get(javaType);
                    String string = javaType = templateType != null ? templateType : javaType;
                }
                if (useFullyQualifiedNames) {
                    javaType = this.importProperties.getProperty(javaType, javaType);
                }
                s.append(javaType);
                if (types.length <= 0) break block8;
                if (template != null && template.size() != 0) break block9;
                if (!javaType.equals("")) {
                    if (nesting == 0 && template == null) {
                        s.append("/*");
                    }
                    s.append("<");
                }
                s.append(this.type(types[0], nesting + 1, template, useFullyQualifiedNames));
                for (int i = 1; i < types.length; ++i) {
                    s.append(", ");
                    s.append(this.type(types[i], nesting + 1, template, useFullyQualifiedNames));
                }
                if (javaType.equals("")) break block8;
                s.append(">");
                if (nesting != 0 || template != null) break block8;
                s.append("*/");
                break block8;
            }
            s.append(".");
            for (int i = 0; i < types.length; ++i) {
                String varName = (String)template.get(types[i].getName());
                s.append(this.primitiveProperties.getProperty(varName, varName));
            }
        }
        for (int i = 0; i < type.getDimension(); ++i) {
            s.append("[]");
        }
        return s.toString();
    }

    private String getPackageName(IClass clazz) {
        String packageName = clazz.getPackageName();
        if (!packageName.equals("")) {
            packageName = this.typeProperties.getProperty(packageName, packageName);
        }
        return packageName;
    }

    protected String[] getConcrete(IClass clazz) {
        String concrete = this.templateProperties.getProperty(this.getPackageName(clazz) + "." + clazz.getName(), null);
        if (concrete == null) {
            return null;
        }
        return concrete.split(";");
    }

    protected Map getTemplateMap(String[] templateParameters, String concrete) {
        HashMap<String, String> template = null;
        if (templateParameters.length > 0) {
            template = new HashMap<String, String>();
            if (concrete != null) {
                String[] templateVars = concrete.split(",");
                if (templateVars.length != templateParameters.length) {
                    System.err.println("Number of template variables (" + templateVars.length + ") not equal to number of template parameters (" + templateParameters.length + ")");
                    System.exit(1);
                }
                for (int j = 0; j < templateVars.length; ++j) {
                    template.put(templateParameters[j], templateVars[j].trim());
                }
            }
        }
        return template;
    }
}

