/*
 * Decompiled with CFR 0.152.
 */
package hep.physics.vec;

import hep.physics.vec.BasicHep3Vector;
import hep.physics.vec.Hep3Vector;
import hep.physics.vec.HepLorentzVector;
import hep.physics.vec.VecOp;
import java.io.Serializable;
import org.apache.commons.math3.util.FastMath;

public class BasicHepLorentzVector
implements HepLorentzVector,
Serializable {
    static final long serialVersionUID = -6544699016896436061L;
    private double t;
    private Hep3Vector v;
    private boolean vIsOwned = false;

    public BasicHepLorentzVector() {
        this.t = 0.0;
        this.v = new BasicHep3Vector();
        this.vIsOwned = true;
    }

    public BasicHepLorentzVector(double t, double x, double y, double z) {
        this.t = t;
        this.v = new BasicHep3Vector(x, y, z);
        this.vIsOwned = true;
    }

    public BasicHepLorentzVector(double t, double[] x) {
        this.t = t;
        this.v = new BasicHep3Vector(x);
        this.vIsOwned = true;
    }

    public BasicHepLorentzVector(double t, float[] x) {
        this.t = t;
        this.v = new BasicHep3Vector(x);
        this.vIsOwned = true;
    }

    public BasicHepLorentzVector(double t, Hep3Vector v) {
        this.t = t;
        this.v = v;
        this.vIsOwned = false;
    }

    public void setV3(double t, double x, double y, double z) {
        this.t = t;
        if (this.vIsOwned) {
            ((BasicHep3Vector)this.v).setV(x, y, z);
        } else {
            this.v = new BasicHep3Vector(x, y, z);
            this.vIsOwned = true;
        }
    }

    public void setV3(double t, Hep3Vector v) {
        this.t = t;
        this.v = v;
        this.vIsOwned = false;
    }

    public void setT(double t) {
        this.t = t;
    }

    @Override
    public double t() {
        return this.t;
    }

    @Override
    public Hep3Vector v3() {
        return this.v;
    }

    @Override
    public double magnitude() {
        return FastMath.sqrt((double)VecOp.dot(this, this));
    }

    @Override
    public double magnitudeSquared() {
        return VecOp.dot(this, this);
    }

    public boolean equals(Object obj) {
        if (obj instanceof HepLorentzVector) {
            HepLorentzVector that = (HepLorentzVector)obj;
            return this.v.equals(that.v3()) && that.t() == this.t;
        }
        return false;
    }

    public int hashCode() {
        return this.v.hashCode() + (int)Double.doubleToRawLongBits(this.t);
    }

    public String toString() {
        return VecOp.toString(this);
    }
}

