/*
 * Decompiled with CFR 0.152.
 */
package hep.physics.particle.properties;

import hep.physics.particle.properties.ParticlePropertyProvider;
import hep.physics.particle.properties.ParticleType;
import hep.physics.particle.properties.UnknownParticleIDException;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DefaultParticlePropertyProvider
implements ParticlePropertyProvider {
    private Map map = new HashMap();

    protected DefaultParticlePropertyProvider() {
        double m = 100.0;
        double cm = 1.0;
        double mm = 0.1;
        double GeV = 1.0;
        double MeV = 0.001;
        double keV = 1.0E-6;
        double hbarc = 197.327 * MeV * m * 1.0E-15;
        double ec = 0.00299792;
        this.PART("gluon", "gluon_bar", 21, 2, 0.0, 0.0, 0.0);
        this.PART("gamma", 22, 2, 0, 0.0);
        this.PART("e-", "e+", 11, 1, -1.0, 511.0 * keV);
        this.PART("mu-", "mu+", 13, 1, -1.0, 105.658 * MeV, hbarc / (658.65 * m));
        this.PART("tau-", "tau+", 15, 1, -1.0, 1.777 * GeV, hbarc / (8.72E-5 * m));
        this.PART("nu_e", "nu_e_bar", 12, 1, 0.0, 0.0);
        this.PART("nu_mu", "nu_mu_bar", 14, 1, 0.0, 0.0);
        this.PART("nu_tau", "nu_tau_bar", 16, 1, 0.0, 0.0, 0.0);
        this.PART("d", "d_bar", 1, 1, -0.3333333333333333, 6.0 * MeV, 0.0);
        this.PART("u", "u_bar", 2, 1, 0.6666666666666666, 3.25 * MeV, 0.0);
        this.PART("s", "s_bar", 3, 1, -0.3333333333333333, 115.0 * MeV, 0.0);
        this.PART("c", "c_bar", 4, 1, 0.6666666666666666, 1.4 * GeV, 0.0);
        this.PART("b", "b_bar", 5, 1, -0.3333333333333333, 4.25 * GeV, 0.0);
        this.PART("t", "t_bar", 6, 1, 0.6666666666666666, 175.0 * GeV, 0.0);
        this.PART("a1+", "a1-", 20213, 2, 0.0, 1.23 * GeV, 400.0 * MeV);
        this.PART("eta", "eta_bar", 221, 0, 0.0, 547.45 * MeV, 0.0);
        this.PART("eta'", "eta'_bar", 331, 0, 0.0, 957.77 * MeV, 0.201 * MeV);
        this.PART("eta(c)(1S)", "eta(c)(1S)_bar", 441, 0, 0.0, 29.798 * MeV, 13.2 * MeV);
        this.PART("Delta+", "Delta+_bar", 2214, 3, 1.0, 1.232 * GeV, 350.0 * MeV);
        this.PART("Delta-", "Delta-_bar", 1114, 3, -1.0, 1.232 * GeV, 350.0 * MeV);
        this.PART("Deltao", "Deltao_bar", 2114, 3, 0.0, 1.232 * GeV, 120.0 * MeV);
        this.PART("Delta++", "Delta--", 2224, 3, 2.0, 1.232 * GeV, 120.0 * MeV);
        this.PART("Lambda(c)+", "Lambda(c)-", 4122, 1, 0.0, 2.285 * GeV, hbarc / (6.18E-5 * m));
        this.PART("Lambda(b)o", "Lambda(b)o_bar", 5122, 1, 0.0, 5.6415 * GeV, 0.0);
        this.PART("B*+", "B*-", 523, 2, 1.0, 5.325 * GeV, 0.0);
        this.PART("B*o", "B*o_bar", 513, 2, 0.0, 5.325 * GeV, 0.0);
        this.PART("B(s)o", "B(s)o_bar", 531, 0, 0.0, 5.3693 * GeV, hbarc / (4.83E-4 * m));
        this.PART("B(s)*o", "B(s)*o_bar", 533, 2, 0.0, 5.51 * GeV, 0.0);
        this.PART("Xi-", "Xi+", 3312, 1, -1.0, 1.321 * GeV, hbarc / (0.00491 * m));
        this.PART("Xi(b)-", "Xi(b)+", 5132, 1, -1.0, 6000.0, 6000.0);
        this.PART("Xi(b)*-", "Xi(b)*+", 5314, 2, -1.0, 5.81 * GeV, 0.0);
        this.PART("Xi(b)'-", "Xi(b)'+", 5312, 1, -1.0, 5.77 * GeV, 0.0);
        this.PART("Xi(b)o", "Xi(b)o_bar", 5232, 1, 0.0, 6.0, 0.0);
        this.PART("Xi(b)*o", "Xi(b)*o_bar", 5324, 2, 0.0, 6.0, 0.0);
        this.PART("Xi(b)'o", "Xi(b)'o_bar", 5322, 1, 0.0, 6.0, 0.0);
        this.PART("Xi(c)+", "Xi(c)-", 4232, 1, 1.0, 2.465 * GeV, 0.0);
        this.PART("Xi(c)o", "Xi(c)o_bar", 4132, 1, 0.0, 2.47 * GeV, 0.0);
        this.PART("Xi(c)*+", "Xi(c)*-", 4324, 2, 1.0, 2.6446 * GeV, 0.0);
        this.PART("Xi(c)*o", "Xi(c)*o_bar", 4314, 2, 0.0, 2.6438 * GeV, 0.0);
        this.PART("Xi(c)'+", "Xi(c)'-", 4322, 1, 1.0, 2.465 * GeV, 0.0);
        this.PART("Xi(c)'o", "Xi(c)'o_bar", 4312, 1, 0.0, 2.47 * GeV, 0.0);
        this.PART("Xi(c0)(1P)", "Xi(c0)(1P)_bar", 10441, 0, 0.0, 3.415 * GeV, 13.5 * MeV);
        this.PART("Xi(c1)(1P)", "Xi(c1)(1P)_bar", 20443, 2, 0.0, 3.5105 * GeV, 0.88 * MeV);
        this.PART("Xi(c2)(1P)", "Xi(c)(1P)_bar", 445, 4, 0.0, 3.556 * GeV, 2.0 * MeV);
        this.PART("Xi(1530)o", "Xi(1530)o_bar", 3324, 3, 0.0, 1.532 * GeV, 9.1 * MeV);
        this.PART("Sigma(b)-", "Sigma(b)-_bar", 5112, 1, -1.0, 5.812 * GeV, 0.0);
        this.PART("Sigma(b)+", "Sigma(b)+_bar", 5222, 1, 1.0, 5.812 * GeV, 0.0);
        this.PART("Sigma(b)*+", "Sigma(b)*+_bar", 5224, 2, 1.0, 5.812 * GeV, 0.0);
        this.PART("Sigma(b)*-", "Sigma(b)*-_bar", 5114, 2, -1.0, 5.812 * GeV, 0.0);
        this.PART("Sigma(b)o", "Sigma(b)o_bar", 5212, 1, 0.0, 1.193 * GeV, 0.0);
        this.PART("Sigma(b)*o", "Sigma(b)*o_bar", 5214, 2, 0.0, 1.193 * GeV, 0.0);
        this.PART("Sigma(c)+", "Sigma(c)-", 4212, 1, 1.0, 2.453 * GeV, 0.0);
        this.PART("Sigma(c)o", "Sigma(c)o_bar", 4112, 1, 0.0, 2.452 * GeV, 0.0);
        this.PART("Sigma(c)*o", "Sigma(c)*o_bar", 4114, 2, 0.0, 2.452 * GeV, 0.0);
        this.PART("Sigma(c)*+", "Sigma(c)*-", 4214, 2, 1.0, 2.4535 * GeV, 0.0);
        this.PART("Sigma(c)++", "Sigma(c)--", 4222, 1, 2.0, 2.453 * GeV, 0.0);
        this.PART("Sigma(c)*++", "Sigma(c)*--", 4224, 2, 2.0, 2.455 * GeV, 0.0);
        this.PART("Sigma(1385)+", "Sigma(1385)-", 3224, 3, 1.0, 1.383 * GeV, 35.8 * MeV);
        this.PART("Ko", "Ko_bar", 311, 0, 0.0, 497.672 * MeV, 0.0);
        this.PART("K(1410)*o", "K(1410)*o_bar", 100313, 2, 0.0, 1.414 * GeV, 227.0 * MeV);
        this.PART("K(1410)*+", "K(1410)*-", 100323, 2, 1.0, 1.414 * GeV, 227.0 * MeV);
        this.PART("K(892)*o", "K*o(892)_bar", 313, 2, 0.0, 896.1 * MeV, 50.5 * MeV);
        this.PART("K(892)*+", "K*-(892)", 323, 2, 0.0, 891.59 * MeV, 49.8 * MeV);
        this.PART("K(1270)1o", "K(1270)1o_bar", 10313, 2, 0.0, 1.273 * GeV, 90.0 * MeV);
        this.PART("K1(1270)+", "K1(1270)-", 10323, 2, 1.0, 1.273 * GeV, 90.0 * MeV);
        this.PART("K2(1430)*o", "K2(1430)*o_bar", 315, 4, 0.0, 1.4254 * GeV, 98.4 * MeV);
        this.PART("K2(1430)*+", "K2(1430)*-", 325, 4, 1.0, 1.4254 * GeV, 98.4 * MeV);
        this.PART("Omega(b)-", "Omega(b)+", 5332, 3, -1.0, 6.0 * GeV, 0.0);
        this.PART("Omega(b)*-", "Omega(b)*+", 5334, 4, -1.0, 6.0 * GeV, 0.0);
        this.PART("Omega(c)o", "Omega(c)o_bar", 4332, 1, 0.0, 2.704 * GeV, 0.0);
        this.PART("Omega(c)*o", "Omega(c)*o_bar", 4334, 2, 0.0, 2.704 * GeV, 0.0);
        this.PART("T+", "T-", 611, 0, 1.0, 175.0 * GeV, 0.0);
        this.PART("T*+", "T*-", 613, 2, 1.0, 175.14 * GeV, 0.0);
        this.PART("To", "To_bar", 621, 0, 0.0, 175.0 * GeV, 0.0);
        this.PART("T*o", "T*o_bar", 623, 2, 0.0, 175.14 * GeV, 0.0);
        this.PART("W+", "W-", 24, 2, 1.0, 80.33 * GeV, 2.07 * GeV);
        this.PART("J/psi(1S)", "J/psi(1S)", 443, 2, 0.0, 3.0969 * GeV, 87.0 * keV);
        this.PART("sdl-", "sdl+", 1000001, 0, -0.3333333333333333, 100.0 * GeV, 0.0);
        this.PART("sul-", "sul+", 1000002, 0, -0.6666666666666666, 100.0 * GeV, 0.0);
        this.PART("ssl-", "ssl+", 1000003, 0, -0.3333333333333333, 100.0 * GeV, 0.0);
        this.PART("scl-", "scl+", 1000004, 0, -0.6666666666666666, 100.0 * GeV, 0.0);
        this.PART("sbl-", "sbl+", 1000005, 0, -0.3333333333333333, 100.0 * GeV, 0.0);
        this.PART("stl-", "stl+", 1000006, 0, -0.6666666666666666, 100.0 * GeV, 0.0);
        this.PART("sel-", "sel+", 1000011, 0, -1.0, 100.0 * GeV, 0.0);
        this.PART("snuel", "snuel_bar", 1000012, 0, 0.0, 100.0 * GeV, 0.0);
        this.PART("smul-", "smul+", 1000013, 0, -1.0, 100.0 * GeV, 0.0);
        this.PART("snumul", "snumul_bar", 1000014, 0, 0.0, 100.0 * GeV, 0.0);
        this.PART("staul-", "staul+", 1000015, 0, -1.0, 100.0 * GeV, 0.0);
        this.PART("snutaul", "snutaul_bar", 1000016, 0, 0.0, 100.0 * GeV, 0.0);
        this.PART("sdr-", "sdr+", 2000001, 0, -0.3333333333333333, 100.0 * GeV, 0.0);
        this.PART("sur-", "sur+", 2000002, 0, -0.6666666666666666, 100.0 * GeV, 0.0);
        this.PART("ssr-", "ssr+", 2000003, 0, -0.3333333333333333, 100.0 * GeV, 0.0);
        this.PART("scr-", "scr+", 2000004, 0, -0.6666666666666666, 100.0 * GeV, 0.0);
        this.PART("sbr-", "sbr+", 2000005, 0, -0.3333333333333333, 100.0 * GeV, 0.0);
        this.PART("str-", "str+", 2000006, 0, -0.6666666666666666, 100.0 * GeV, 0.0);
        this.PART("ser-", "ser+", 2000011, 0, -1.0, 100.0 * GeV, 0.0);
        this.PART("snuer", "snuer_bar", 2000012, 0, 0.0, 100.0 * GeV, 0.0);
        this.PART("smur-", "smur+", 2000013, 0, -1.0, 100.0 * GeV, 0.0);
        this.PART("snumur", "snumur_bar", 2000014, 0, 0.0, 100.0 * GeV, 0.0);
        this.PART("staur-", "staur+", 2000015, 0, -1.0, 100.0 * GeV, 0.0);
        this.PART("snutaur", "snutaur_bar", 2000016, 0, 1.0, 100.0 * GeV, 0.0);
        this.PART("gluino", 1000021, 1, 0, 0.0);
        this.PART("neut10", "neut10_bar", 1000022, 0, 0.0, 100.0 * GeV, 0.0);
        this.PART("neut20", "neut20_bar", 1000023, 0, 0.0, 100.0 * GeV, 0.0);
        this.PART("charg1+", "charg1-", 1000024, 0, 1.0, 100.0 * GeV, 0.0);
        this.PART("neut30", "neut30_bar", 1000025, 0, 0.0, 100.0 * GeV, 0.0);
        this.PART("zino2", "zino2_bar", 1000032, 0, 0.0, 0.0, 0.0);
        this.PART("zino3", "zino3_bar", 1000033, 0, 0.0, 0.0, 0.0);
        this.PART("wino2", "wino2_bar", 1000034, 0, 0.0, 0.0, 0.0);
        this.PART("zino4", "zino4_bar", 1000056, 0, 0.0, 0.0, 0.0);
        this.PART("neut40", "neut40_bar", 1000035, 0, 0.0, 100.0 * GeV, 0.0);
        this.PART("charg2+", "charg2-", 1000037, 0, 1.0, 100.0 * GeV, 0.0);
        this.PART("gravitino", 1000039, 2, 0, 0.0);
        this.PART("pi+", "pi-", 211, 0, 1.0, 139.5675 * MeV, hbarc / (7.804 * m));
        this.PART("pi0", 111, 0, 0, 134.9739 * MeV, hbarc / (2.5E-6 * cm));
        this.PART("K+", "K-", 321, 1, 1.0, 493.646 * MeV, hbarc / (379.9 * cm));
        this.PART("K0_S", 310, 0, 0, 497.671 * MeV, hbarc / (2.675 * cm));
        this.PART("K0_L", 130, 0, 0, 497.671 * MeV, hbarc / (15.5 * m));
        this.PART("rho+", "rho-", 213, 2, 1.0, 768.3 * MeV, 149.0 * MeV);
        this.PART("rho0", 113, 2, 0, 768.3 * MeV, 149.0 * MeV);
        this.PART("omega", 223, 2, 0, 781.95 * MeV, 8.43 * MeV);
        this.PART("phi", 333, 2, 0, 1019.412 * MeV, 4.41 * MeV);
        this.PART("p", "p_bar", 2212, 1, 1.0, 938.272 * MeV);
        this.PART("n", "n_bar", 2112, 1, 0.0, 939.566 * MeV);
        this.PART("J/psi", 443, 2, 0, 3097.0 * MeV, 0.07 * MeV);
        this.PART("Lambda", "Lambda_bar", 3122, 1, 0.0, 1115.63 * MeV, hbarc / (7.89 * cm));
        this.PART("Sigma+", "Sigma+_bar", 3222, 1, 1.0, 1189.37 * MeV, hbarc / (2.4 * cm));
        this.PART("Sigma0", "Sigma0_bar", 3212, 1, 0.0, 1192.55 * MeV, hbarc / (2.2E-9 * cm));
        this.PART("Sigma-", "Sigma-_bar", 3112, 1, -1.0, 1197.43 * MeV, hbarc / (4.43 * cm));
        this.PART("Sigma0(1385)", "Sigma0(1385)_bar", 3214, 3, 0.0, 1.384 * GeV, 36.0 * MeV);
        this.PART("Sigma(1385)-", "Sigma(1385)-_bar", 3114, 3, 0.0, 1.3872 * GeV, 39.4 * MeV);
        this.PART("Xi0", "Xi0_bar", 3322, 1, 0.0, 1314.9 * MeV, hbarc / (8.69 * cm));
        this.PART("Xi-", "Xi-_bar", 3312, 1, -1.0, 1321.32 * MeV, hbarc / (4.91 * cm));
        this.PART("Omega-", "Omega-_bar", 3334, 3, -1.0, 1672.43 * MeV, hbarc / (2.46 * cm));
        this.PART("D+", "D-", 411, 0, 1.0, 1869.3 * MeV, hbarc / (m * 3.2E-4));
        this.PART("D0", "D0-bar", 421, 0, 0.0, 1864.5 * MeV, hbarc / (m * 1.259E-4));
        this.PART("D*+", "D*-", 413, 1, 1.0, 2010.1 * MeV, 0.5 * MeV);
        this.PART("D*0", "D*0-bar", 423, 1, 0.0, 2007.1 * MeV, 0.5 * MeV);
        this.PART("D(s)+", "D(s)-", 431, 0, 1.0, 1968.8 * MeV, 1.46E-12 * GeV);
        this.PART("D(s)*+", "D(s)*-", 433, 0, 0.0, 2110.3 * MeV);
        this.PART("B+", "B-", 521, 0, 1.0, 5278.6 * MeV, hbarc / (m * 3.87E-4));
        this.PART("B0", "B0-bar", 511, 0, 0.0, 5278.7 * MeV, hbarc / (m * 3.87E-4));
        this.PART("upsilon(4S)", 70553, 2, 0, 10.58 * GeV, 23.8 * MeV);
        this.PART("deutron", 10002, 1, 1, 1876.01 * MeV);
        this.PART("triton", 10003, 2, 1, 2809.26 * MeV);
        this.PART("alpha", 20001, 0, 2, 3728.17 * MeV);
        this.PART("Z0", 33, 2, 0, 91.187 * GeV, 2.49 * GeV);
        this.PART("Zo", 23, 2, 0, 91.187 * GeV, 2.49 * GeV);
        this.PART("H0/H02", 35, 0, 0, 300.0 * GeV, 1.0 * GeV);
        this.PART("h0/H01", 25, 0, 0, 44.0 * GeV, 0.0);
        this.PART("H+", 37, 0, 1, 140.0 * GeV, 1.0 * GeV);
    }

    private void PART(String pname, String aname, int id, int spin, double charge, double mass, double width) {
        this.add(new Type(pname, id, spin, charge, mass, width));
        this.add(new Type(aname, -id, spin, -charge, mass, width));
    }

    private void PART(String pname, String aname, int id, int spin, double charge, double mass) {
        this.add(new Type(pname, id, spin, charge, mass, 0.0));
        this.add(new Type(aname, -id, spin, -charge, mass, 0.0));
    }

    private void PART(String pname, int id, int spin, int charge, double mass, double width) {
        this.add(new Type(pname, id, spin, charge, mass, width));
    }

    private void PART(String pname, int id, int spin, int charge, double mass) {
        this.add(new Type(pname, id, spin, charge, mass, 0.0));
    }

    private void add(Type type) {
        this.map.put(new Integer(type.getPDGID()), type);
    }

    @Override
    public ParticleType get(int PDGID) {
        ParticleType pt = (ParticleType)this.map.get(new Integer(PDGID));
        if (pt == null) {
            pt = new UnknownType(PDGID);
        }
        return pt;
    }

    @Override
    public Set types() {
        return new HashSet(this.map.values());
    }

    private class Type
    implements ParticleType {
        private String name;
        private int id;
        private int spin;
        private double charge;
        private double mass;
        private double width;

        Type(String name, int id, int spin, double charge, double mass, double width) {
            this.name = name;
            this.id = id;
            this.spin = spin;
            this.charge = charge;
            this.mass = mass;
            this.width = width;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getPDGID() {
            return this.id;
        }

        @Override
        public int get2xSpin() {
            return this.spin;
        }

        @Override
        public double getCharge() {
            return this.charge;
        }

        @Override
        public double getMass() {
            return this.mass;
        }

        @Override
        public double getWidth() {
            return this.width;
        }

        public String toString() {
            Formatter formatter = new Formatter();
            formatter.format("%s (mass=%5g id=%d charge=%5g)", this.name, this.mass, this.id, this.charge);
            return formatter.toString();
        }

        public boolean equals(Object o) {
            if (o instanceof ParticleType) {
                ParticleType that = (ParticleType)o;
                return Math.abs(this.getPDGID()) == Math.abs(that.getPDGID());
            }
            return false;
        }

        public int hashCode() {
            return Math.abs(this.getPDGID());
        }

        @Override
        public ParticlePropertyProvider getParticlePropertyProvider() {
            return DefaultParticlePropertyProvider.this;
        }
    }

    private class UnknownType
    implements ParticleType {
        private int id;

        UnknownType(int pdgid) {
            this.id = pdgid;
        }

        @Override
        public String getName() {
            return "unknown";
        }

        @Override
        public int getPDGID() {
            return this.id;
        }

        @Override
        public int get2xSpin() {
            throw new UnknownParticleIDException(this.id);
        }

        @Override
        public double getCharge() {
            throw new UnknownParticleIDException(this.id);
        }

        @Override
        public double getMass() {
            throw new UnknownParticleIDException(this.id);
        }

        @Override
        public double getWidth() {
            throw new UnknownParticleIDException(this.id);
        }

        public String toString() {
            return "unknown (id=" + this.id + ")";
        }

        @Override
        public ParticlePropertyProvider getParticlePropertyProvider() {
            return DefaultParticlePropertyProvider.this;
        }
    }
}

