/*
 * Decompiled with CFR 0.152.
 */
package hep.physics.event.generator.diagnostic;

import hep.physics.event.generator.EventGenerator;
import hep.physics.event.generator.GeneratorFactory;
import hep.physics.event.generator.MCEvent;
import hep.physics.particle.BasicParticle;
import hep.physics.particle.properties.ParticlePropertyManager;
import hep.physics.particle.properties.ParticlePropertyProvider;
import hep.physics.particle.properties.ParticleType;
import hep.physics.particle.properties.UnknownParticleIDException;
import hep.physics.vec.BasicHep3Matrix;
import hep.physics.vec.BasicHep3Vector;
import hep.physics.vec.BasicHepLorentzVector;
import hep.physics.vec.Hep3Matrix;
import hep.physics.vec.Hep3Vector;
import hep.physics.vec.HepLorentzVector;
import hep.physics.vec.VecOp;
import java.util.ArrayList;
import java.util.Random;

public class DiagnosticEventGenerator
implements EventGenerator {
    private int m_ievent;
    private int m_irun = 1;
    private ParticleType m_ptype;
    private ParticleType m_ptypeBar;
    private int m_inparts = 1;
    private double m_dlowp = 5.0;
    private double m_dhighp = 5.0;
    private double m_dlowcosth = -1.0;
    private double m_dhighcosth = 1.0;
    private double m_dlowphi = 0.0;
    private double m_dhighphi = Math.PI * 2;
    private BasicHep3Vector m_origin = new BasicHep3Vector(0.0, 0.0, 0.0);
    private double m_dxrange = 0.0;
    private double m_dyrange = 0.0;
    private double m_dzrange = 0.0;
    private double m_dangres = -1.0;
    boolean m_bseedset = false;
    private long m_lseed;
    private Random myRandom;
    boolean m_branPPBar = false;
    private GeneratorFactory factory;
    private ParticlePropertyProvider provider;

    public DiagnosticEventGenerator() {
        this(ParticlePropertyManager.getParticlePropertyProvider());
    }

    public DiagnosticEventGenerator(ParticlePropertyProvider ppp) {
        this(ppp, new GeneratorFactory());
    }

    public DiagnosticEventGenerator(ParticlePropertyProvider ppp, GeneratorFactory factory) {
        this(ppp, factory, new Random());
    }

    public DiagnosticEventGenerator(ParticlePropertyProvider ppp, GeneratorFactory factory, Random random) {
        this.provider = ppp;
        this.factory = factory;
        this.setParticleType(this.provider.get(13));
        this.myRandom = random;
    }

    public ParticlePropertyProvider getParticlePropertyProvider() {
        return this.provider;
    }

    @Override
    public void reset() {
        this.m_ievent = 0;
    }

    public void setRunNumber(int nrun) {
        this.m_irun = nrun;
    }

    public void setParticleType(ParticleType ptype) {
        this.m_ptype = ptype;
        try {
            this.m_ptypeBar = ptype.getParticlePropertyProvider().get(-1 * ptype.getPDGID());
            this.m_ptypeBar.getMass();
        }
        catch (UnknownParticleIDException x) {
            this.m_ptypeBar = ptype;
        }
    }

    public ParticleType getParticleType() {
        return this.m_ptype;
    }

    public void setNumberOfParticles(int nparts) {
        if (nparts < 1) {
            throw new IllegalArgumentException("Invalid number of particles.");
        }
        this.m_inparts = nparts;
    }

    public int getNumberOfParticles() {
        return this.m_inparts;
    }

    public void setMomentumRange(double lowp, double highp) {
        if (lowp < 0.0 | highp <= 0.0 | lowp > highp) {
            throw new IllegalArgumentException("Invalid momentum range value.");
        }
        this.m_dlowp = lowp;
        this.m_dhighp = highp;
    }

    public void setCosthRange(double lowcosth, double highcosth) {
        if (lowcosth < -1.0 | highcosth > 1.0 | lowcosth > highcosth) {
            throw new IllegalArgumentException("Invalid costheta range value.");
        }
        this.m_dlowcosth = lowcosth;
        this.m_dhighcosth = highcosth;
    }

    public void setPhiRange(double lowphi, double highphi) {
        if (lowphi > highphi) {
            throw new IllegalArgumentException("Invalid phi range value.");
        }
        this.m_dlowphi = lowphi;
        this.m_dhighphi = highphi;
    }

    public void setOrigin(double x, double y, double z) {
        this.m_origin.setV(x, y, z);
    }

    public void setXRange(double dx) {
        this.m_dxrange = dx;
    }

    public void setYRange(double dy) {
        this.m_dyrange = dy;
    }

    public void setZRange(double dz) {
        this.m_dzrange = dz;
    }

    public void setRandomParticleAntiParticle(boolean ppbar) {
        this.m_branPPBar = ppbar;
    }

    public void setTwoParticleRes(double angres) {
        this.m_dangres = angres;
    }

    public void setSeed(long seed) {
        this.m_lseed = seed;
        this.m_bseedset = true;
    }

    public void printParameters() {
        System.out.println("Diagnostic Generator Parameter Settings.");
        System.out.println("Particle type = " + this.m_ptype);
        System.out.println("Number of particles per event = " + this.m_inparts);
        System.out.println("Momentum range = (" + this.m_dlowp + ", " + this.m_dhighp + ")");
        System.out.println("Cosine theta range = (" + this.m_dlowcosth + ", " + this.m_dhighcosth + ")");
        System.out.println("Phi range = (" + this.m_dlowphi + ", " + this.m_dhighphi + ")");
        System.out.println("Particle origin = (" + this.m_origin.x() + ", " + this.m_origin.y() + ", " + this.m_origin.z() + ")");
        System.out.println("Origin ranges = (" + this.m_dxrange + ", " + this.m_dyrange + ", " + this.m_dzrange + ")");
        System.out.println("Angular resolution = " + this.m_dangres);
        System.out.println("Random number seed = " + this.m_lseed);
    }

    @Override
    public MCEvent generate() {
        if (this.m_ievent == 0 && this.m_bseedset) {
            this.myRandom.setSeed(this.m_lseed);
        }
        int nExpected = this.m_dangres < 0.0 ? this.m_inparts : 2 * this.m_inparts;
        ArrayList<BasicParticle> partVec = new ArrayList<BasicParticle>(nExpected);
        for (int i = 0; i < this.m_inparts; ++i) {
            Hep3Vector origin = this.selectOrigin();
            HepLorentzVector p = this.selectP();
            ParticleType ptype = this.m_branPPBar && this.myRandom.nextDouble() < 0.5 ? this.m_ptypeBar : this.m_ptype;
            BasicParticle part = this.factory.createParticle(origin, p, ptype, 1, 0.0);
            partVec.add(part);
            if (!(this.m_dangres >= 0.0)) continue;
            BasicHep3Vector v = new BasicHep3Vector(0.0, 0.0, p.v3().magnitude());
            double ranphi = Math.PI * 2 * this.myRandom.nextDouble();
            BasicHep3Matrix rot = new BasicHep3Matrix();
            rot.setActiveEuler(ranphi, this.m_dangres, 0.0);
            Hep3Vector vtwin = VecOp.mult((Hep3Matrix)rot, (Hep3Vector)v);
            double theta = Math.acos(p.v3().z() / p.v3().magnitude());
            BasicHep3Vector pprojxy = new BasicHep3Vector(p.v3().x(), p.v3().y(), 0.0);
            double xymag = pprojxy.magnitude();
            int signy = 1;
            if (p.v3().y() < 0.0) {
                signy = -1;
            }
            double phi = xymag > 0.0 ? (double)signy * Math.acos(p.v3().x() / xymag) : 0.0;
            rot.setActiveEuler(1.5707963267948966 + phi, theta, 0.0);
            BasicHepLorentzVector pTwin = new BasicHepLorentzVector(p.t(), VecOp.mult((Hep3Matrix)rot, vtwin));
            ParticleType pTwintype = this.m_branPPBar && this.myRandom.nextDouble() < 0.5 ? this.m_ptypeBar : this.m_ptype;
            BasicParticle twin = this.factory.createParticle(origin, pTwin, pTwintype, 1, 0.0);
            partVec.add(twin);
        }
        ++this.m_ievent;
        MCEvent event = this.factory.createEvent(this.m_irun, this.m_ievent);
        event.put("MCParticle", partVec);
        return event;
    }

    protected HepLorentzVector selectP() {
        double mom = this.selectMom();
        double theta = Math.acos(this.selectCosth());
        double phi = this.selectPhi();
        double px = mom * Math.sin(theta) * Math.cos(phi);
        double py = mom * Math.sin(theta) * Math.sin(phi);
        double pz = mom * Math.cos(theta);
        double mass = this.m_ptype.getMass();
        double energy = Math.sqrt(mass * mass + mom * mom);
        return new BasicHepLorentzVector(energy, px, py, pz);
    }

    protected Hep3Vector selectOrigin() {
        double x = this.m_origin.x() + this.m_dxrange * (this.myRandom.nextDouble() - 0.5);
        double y = this.m_origin.y() + this.m_dyrange * (this.myRandom.nextDouble() - 0.5);
        double z = this.m_origin.z() + this.m_dzrange * (this.myRandom.nextDouble() - 0.5);
        return new BasicHep3Vector(x, y, z);
    }

    protected double selectMom() {
        if (this.m_dlowp == this.m_dhighp) {
            return this.m_dlowp;
        }
        return this.m_dlowp + (this.m_dhighp - this.m_dlowp) * this.myRandom.nextDouble();
    }

    protected double selectCosth() {
        if (this.m_dlowcosth == this.m_dhighcosth) {
            return this.m_dlowcosth;
        }
        return this.m_dlowcosth + (this.m_dhighcosth - this.m_dlowcosth) * this.myRandom.nextDouble();
    }

    protected double selectPhi() {
        if (this.m_dlowphi == this.m_dhighphi) {
            return this.m_dlowphi;
        }
        return this.m_dlowphi + (this.m_dhighphi - this.m_dlowphi) * this.myRandom.nextDouble();
    }

    public long getSeed() {
        return this.m_lseed;
    }

    public int getRunNumber() {
        return this.m_irun;
    }

    public double getTwoParticleRes() {
        return this.m_dangres;
    }

    public boolean isRandomParticleAntiParticle() {
        return this.m_branPPBar;
    }

    public double getZRange() {
        return this.m_dzrange;
    }

    public double getYRange() {
        return this.m_dyrange;
    }

    public double getXRange() {
        return this.m_dxrange;
    }
}

