/*
 * Decompiled with CFR 0.152.
 */
package hep.io.xdr;

import hep.io.xdr.XDRDataOutput;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class XDROutputStream
extends DataOutputStream
implements XDRDataOutput {
    private CountedOutputStream cout;
    private static final byte[] padding = new byte[]{0, 0, 0, 0};

    public XDROutputStream(OutputStream out) {
        super(new CountedOutputStream(out));
        this.cout = (CountedOutputStream)this.out;
    }

    @Override
    public void writeString(String s) throws IOException {
        this.writeInt(s.length());
        byte[] ascii = s.getBytes();
        this.write(ascii);
        this.pad();
    }

    @Override
    public void writeStringChars(String s) throws IOException {
        byte[] ascii = s.getBytes();
        this.write(ascii);
        this.pad();
    }

    @Override
    public void writeIntArray(int[] array) throws IOException {
        this.writeInt(array.length);
        for (int i = 0; i < array.length; ++i) {
            this.writeInt(array[i]);
        }
    }

    @Override
    public void writeIntArray(int[] array, int start, int n) throws IOException {
        this.writeInt(n);
        for (int i = start; i < n; ++i) {
            this.writeInt(array[i]);
        }
    }

    @Override
    public void writeDoubleArray(double[] array) throws IOException {
        this.writeInt(array.length);
        for (int i = 0; i < array.length; ++i) {
            this.writeDouble(array[i]);
        }
    }

    @Override
    public void writeDoubleArray(double[] array, int start, int n) throws IOException {
        this.writeInt(n);
        for (int i = start; i < n; ++i) {
            this.writeDouble(array[i]);
        }
    }

    @Override
    public void writeFloatArray(float[] array) throws IOException {
        this.writeInt(array.length);
        for (int i = 0; i < array.length; ++i) {
            this.writeFloat(array[i]);
        }
    }

    @Override
    public void writeFloatArray(float[] array, int start, int n) throws IOException {
        this.writeInt(n);
        for (int i = start; i < n; ++i) {
            this.writeFloat(array[i]);
        }
    }

    @Override
    public void pad() throws IOException {
        int offset = (int)(this.getBytesWritten() % 4L);
        if (offset != 0) {
            this.write(padding, 0, 4 - offset);
        }
    }

    public long getBytesWritten() {
        return this.cout.getBytesWritten();
    }

    private static final class CountedOutputStream
    extends FilterOutputStream {
        private long count = 0L;

        CountedOutputStream(OutputStream out) {
            super(out);
        }

        @Override
        public void write(int b) throws IOException {
            this.out.write(b);
            ++this.count;
        }

        @Override
        public void write(byte[] data) throws IOException {
            this.out.write(data);
            this.count += (long)data.length;
        }

        @Override
        public void write(byte[] data, int off, int len) throws IOException {
            this.out.write(data, off, len);
            this.count += (long)len;
        }

        public long getBytesWritten() {
            return this.count;
        }
    }
}

