/*
 * Decompiled with CFR 0.152.
 */
package hep.io.sio;

import hep.io.sio.SIORef;
import hep.io.xdr.XDRInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public class SIOInputStream
extends XDRInputStream {
    private Vector map;
    private static final SIORef nullRef = new NullRef();

    SIOInputStream(InputStream in) {
        super(in);
        this.map = new Vector();
    }

    public SIOInputStream(InputStream in, SIOInputStream parent) {
        super(in);
        this.map = parent.map;
    }

    void clear() {
        this.map.removeAllElements();
    }

    public void readPTag(Object o) throws IOException {
        int i = this.readInt();
        if (i < 0) {
            return;
        }
        if (this.map.size() < i + 1) {
            this.map.setSize(i + 1);
        }
        this.map.setElementAt(o, i);
    }

    public SIORef readPntr() throws IOException {
        int i = this.readInt();
        if (i == 0) {
            return nullRef;
        }
        return new SIORefImpl(i);
    }

    @Override
    public void close() throws IOException {
    }

    private static class NullRef
    implements SIORef {
        private NullRef() {
        }

        @Override
        public Object getObject() {
            return null;
        }
    }

    private class SIORefImpl
    implements SIORef {
        private int index;

        SIORefImpl(int i) {
            this.index = i;
        }

        @Override
        public Object getObject() {
            try {
                return SIOInputStream.this.map.elementAt(this.index);
            }
            catch (Exception x) {
                return null;
            }
        }
    }
}

