/*
 * Decompiled with CFR 0.152.
 */
package hep.graphics.heprep.ref;

import hep.graphics.heprep.HepRep;
import hep.graphics.heprep.HepRepAction;
import hep.graphics.heprep.HepRepAttDef;
import hep.graphics.heprep.HepRepAttValue;
import hep.graphics.heprep.HepRepAttribute;
import hep.graphics.heprep.HepRepDefinition;
import hep.graphics.heprep.HepRepInstance;
import hep.graphics.heprep.HepRepInstanceTree;
import hep.graphics.heprep.HepRepPoint;
import hep.graphics.heprep.HepRepTreeID;
import hep.graphics.heprep.HepRepType;
import hep.graphics.heprep.HepRepTypeTree;
import hep.graphics.heprep.HepRepWriter;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class DefaultHepRepWriter
implements HepRepWriter {
    protected ObjectOutputStream out;
    protected ZipOutputStream zip;
    protected Map properties;

    protected DefaultHepRepWriter(OutputStream out, boolean randomAccess, boolean compress) throws IOException {
        if (randomAccess) {
            this.zip = new ZipOutputStream(out);
            this.zip.setLevel(compress ? -1 : 0);
        } else {
            this.out = compress ? new ObjectOutputStream(new GZIPOutputStream(out)) : new ObjectOutputStream(out);
        }
        this.properties = new HashMap();
    }

    @Override
    public void addProperty(String key, String value) throws IOException {
        this.properties.put(key, value);
    }

    @Override
    public void close() throws IOException {
        if (this.zip != null) {
            this.zip.putNextEntry(new ZipEntry("heprep.properties"));
            PrintStream ps = new PrintStream(this.zip);
            for (String key : this.properties.keySet()) {
                ps.println(key + "=" + (String)this.properties.get(key));
            }
            this.zip.closeEntry();
            this.zip.close();
        }
        if (this.out != null) {
            this.out.close();
        }
    }

    @Override
    public void write(HepRep heprep, String name) throws IOException {
        if (this.zip != null) {
            this.zip.putNextEntry(new ZipEntry(name));
            this.out = new ObjectOutputStream(this.zip);
        }
        this.out.writeObject(heprep);
        if (this.zip != null) {
            this.zip.closeEntry();
        }
    }

    @Override
    public void write(List layerOrder) throws IOException {
        this.out.writeObject(layerOrder);
    }

    @Override
    public void write(HepRepTypeTree typeTree) throws IOException {
        this.out.writeObject(typeTree);
    }

    @Override
    public void write(HepRepType type) throws IOException {
        this.out.writeObject(type);
    }

    @Override
    public void write(HepRepTreeID treeID) throws IOException {
        this.out.writeObject(treeID);
    }

    @Override
    public void write(HepRepAction action) throws IOException {
        this.out.writeObject(action);
    }

    @Override
    public void write(HepRepInstanceTree instanceTree) throws IOException {
        this.out.writeObject(instanceTree);
    }

    @Override
    public void write(HepRepInstance instance) throws IOException {
        this.out.writeObject(instance);
    }

    @Override
    public void write(HepRepPoint point) throws IOException {
        this.out.writeObject(point);
    }

    @Override
    public void write(HepRepAttribute attribute) throws IOException {
        this.out.writeObject(attribute);
    }

    @Override
    public void write(HepRepDefinition definition) throws IOException {
        this.out.writeObject(definition);
    }

    @Override
    public void write(HepRepAttValue attValue) throws IOException {
        this.out.writeObject(attValue);
    }

    @Override
    public void write(HepRepAttDef attDef) throws IOException {
        this.out.writeObject(attDef);
    }
}

