/*
 * Decompiled with CFR 0.152.
 */
package hep.graphics.heprep.corbavalue;

import hep.graphics.heprep.HepRepFactory;
import hep.graphics.heprep.HepRepInstance;
import hep.graphics.heprep.HepRepInstanceTree;
import hep.graphics.heprep.HepRepSelectFilter;
import hep.graphics.heprep.HepRepTypeTree;
import hep.graphics.heprep.corbavalue.HepRepInstanceAdapter;
import hep.graphics.heprep.corbavalue.HepRepTreeIDAdapter;
import hep.graphics.heprep.corbavalue.idl.HepRepTreeID;
import hep.graphics.heprep.ref.DefaultHepRepFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class HepRepInstanceTreeAdapter
extends HepRepTreeIDAdapter
implements HepRepInstanceTree {
    private hep.graphics.heprep.corbavalue.idl.HepRepInstanceTree hepRepInstanceTree;
    private transient List instances;
    private transient Set instanceTrees;
    private transient List instanceTreeList;

    public HepRepInstanceTreeAdapter(hep.graphics.heprep.corbavalue.idl.HepRepInstanceTree hepRepInstanceTree) {
        super((HepRepTreeID)hepRepInstanceTree);
        this.hepRepInstanceTree = hepRepInstanceTree;
    }

    @Override
    public void overlay(HepRepInstanceTree instanceTree) {
        throw new RuntimeException("HepRepInstanceTreeAdapter.overlay is not implemented.");
    }

    @Override
    public HepRepInstanceTree copy(HepRepTypeTree typeTree) throws CloneNotSupportedException {
        return this.copy(typeTree, null);
    }

    @Override
    public HepRepInstanceTree copy(HepRepTypeTree typeTree, HepRepSelectFilter filter) throws CloneNotSupportedException {
        DefaultHepRepFactory factory = new DefaultHepRepFactory();
        HepRepInstanceTree copy = ((HepRepFactory)factory).createHepRepInstanceTree(this.getName(), this.getVersion(), this.getTypeTree());
        for (HepRepInstance instance : this.getInstances()) {
            if (filter != null && !filter.select(instance)) continue;
            copy.addInstance(instance.copy(typeTree, copy, filter));
        }
        for (hep.graphics.heprep.HepRepTreeID id : this.getInstanceTreeList()) {
            copy.addInstanceTree(((HepRepFactory)factory).createHepRepTreeID(id.getName(), id.getVersion(), id.getQualifier()));
        }
        return copy;
    }

    @Override
    public List getInstances() {
        if (this.instances == null) {
            this.instances = new LinkedList();
            int n = this.hepRepInstanceTree.instances.length;
            for (int i = 0; i < n; ++i) {
                this.instances.add(new HepRepInstanceAdapter(this.hepRepInstanceTree.instances[i], null));
            }
        }
        return this.instances;
    }

    @Override
    public void addInstance(HepRepInstance instance) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("HepRepInstanceTreeAdapter.addInstance is not implemented.");
    }

    @Override
    public void addInstanceTree(hep.graphics.heprep.HepRepTreeID instanceTree) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("HepRepInstanceTreeAdapter.addInstanceTree is not implemented.");
    }

    @Override
    public void removeInstance(HepRepInstance instance) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("HepRepInstanceAdapter.removeInstance is not implemented.");
    }

    @Override
    public hep.graphics.heprep.HepRepTreeID getTypeTree() {
        return new HepRepTreeIDAdapter(this.hepRepInstanceTree.typeTreeID);
    }

    @Override
    public Set getInstanceTrees() {
        if (this.instanceTrees == null) {
            int n = this.hepRepInstanceTree.instanceTreeIDs.length;
            this.instanceTrees = new HashSet(n);
            for (int i = 0; i < n; ++i) {
                this.instanceTrees.add(new HepRepTreeIDAdapter(this.hepRepInstanceTree.instanceTreeIDs[i]));
            }
        }
        return this.instanceTrees;
    }

    @Override
    public List getInstanceTreeList() {
        if (this.instanceTreeList == null) {
            int n = this.hepRepInstanceTree.instanceTreeIDs.length;
            this.instanceTreeList = new ArrayList(n);
            for (int i = 0; i < n; ++i) {
                this.instanceTreeList.add(new HepRepTreeIDAdapter(this.hepRepInstanceTree.instanceTreeIDs[i]));
            }
        }
        return this.instanceTreeList;
    }

    public String toString() {
        return "[HepRepInstanceTree (corba):" + this.getQualifier() + ":" + this.getName() + ":" + this.getVersion() + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (o instanceof HepRepInstanceTree) {
            HepRepInstanceTree ref = (HepRepInstanceTree)o;
            if (!ref.getTypeTree().getName().equals(this.getTypeTree().getName())) {
                return false;
            }
            if (!ref.getTypeTree().getVersion().equals(this.getTypeTree().getVersion())) {
                return false;
            }
            if (!ref.getInstances().equals(this.getInstances())) {
                return false;
            }
            return ref.getInstanceTreeList().equals(this.getInstanceTreeList());
        }
        return false;
    }

    @Override
    public int hashCode() {
        long code = this.getTypeTree().hashCode();
        code += (long)this.getInstances().hashCode();
        return (int)(code += (long)this.getInstanceTreeList().hashCode());
    }
}

