/*
 * Decompiled with CFR 0.152.
 */
package hep.graphics.heprep.corba;

import hep.graphics.heprep.HepRepInstance;
import hep.graphics.heprep.HepRepInstanceTree;
import hep.graphics.heprep.HepRepPoint;
import hep.graphics.heprep.HepRepSelectFilter;
import hep.graphics.heprep.HepRepType;
import hep.graphics.heprep.HepRepTypeTree;
import hep.graphics.heprep.corba.CORBAHepRepAttribute;
import hep.graphics.heprep.corba.HepRepPointAdapter;
import hep.graphics.heprep.corba.idl.HepRepAttValue;
import hep.graphics.heprep.ref.DefaultHepRepFactory;
import java.util.LinkedList;
import java.util.List;

public class HepRepInstanceAdapter
extends CORBAHepRepAttribute
implements HepRepInstance {
    private HepRepTypeTree typeTree;
    private hep.graphics.heprep.corba.idl.HepRepInstance hepRepInstance;
    private HepRepInstance parent;
    private HepRepType type;
    private transient Object userObject;
    private transient LinkedList points;
    private transient LinkedList instances;
    private transient boolean valid;
    private transient String layer;
    private transient boolean hasFrame;

    public HepRepInstanceAdapter(HepRepTypeTree typeTree, hep.graphics.heprep.corba.idl.HepRepInstance hepRepInstance, HepRepInstance parent) {
        this.typeTree = typeTree;
        this.hepRepInstance = hepRepInstance;
        this.parent = parent;
        this.type = typeTree.getType(hepRepInstance.typeName);
        if (this.type == null) {
            throw new RuntimeException("HepRepInstance cannot be created without a HepRepType.Was unable to find '" + hepRepInstance.typeName + "'");
        }
    }

    @Override
    public HepRepInstance getSuperInstance() {
        return this.parent;
    }

    @Override
    public void overlay(HepRepInstance instance) {
        throw new RuntimeException("HepRepInstanceAdapter.overlay is not implemented.");
    }

    @Override
    public HepRepInstance copy(HepRepTypeTree typeTree, HepRepInstanceTree parent) throws CloneNotSupportedException {
        return this.copy(typeTree, parent, null);
    }

    @Override
    public HepRepInstance copy(HepRepTypeTree typeTree, HepRepInstance parent) throws CloneNotSupportedException {
        return this.copy(typeTree, parent, null);
    }

    @Override
    public HepRepInstance copy(HepRepTypeTree typeTree, HepRepInstance parent, HepRepSelectFilter filter) throws CloneNotSupportedException {
        HepRepType type = typeTree.getType(this.getType().getFullName());
        HepRepInstance copy = new DefaultHepRepFactory().createHepRepInstance(parent, type);
        return this.copy(typeTree, copy, filter);
    }

    @Override
    public HepRepInstance copy(HepRepTypeTree typeTree, HepRepInstanceTree parent, HepRepSelectFilter filter) throws CloneNotSupportedException {
        HepRepType type = typeTree.getType(this.getType().getFullName());
        HepRepInstance copy = new DefaultHepRepFactory().createHepRepInstance(parent, type);
        return this.copy(typeTree, copy, filter);
    }

    @Override
    public void setUserObject(Object object) {
        this.userObject = object;
    }

    @Override
    public Object getUserObject() {
        return this.userObject;
    }

    @Override
    public HepRepType getType() {
        return this.type;
    }

    @Override
    public List getInstances() {
        if (this.instances == null) {
            this.instances = new LinkedList();
            int n = this.hepRepInstance.instances.length;
            for (int i = 0; i < n; ++i) {
                this.instances.add(new HepRepInstanceAdapter(this.typeTree, this.hepRepInstance.instances[i], this));
            }
        }
        return this.instances;
    }

    @Override
    public List getPoints() {
        if (this.points == null) {
            this.points = new LinkedList();
            int n = this.hepRepInstance.points.length;
            for (int i = 0; i < n; ++i) {
                this.points.add(new HepRepPointAdapter(this.hepRepInstance.points[i], this));
            }
        }
        return this.points;
    }

    @Override
    public int getPoints(double[][] xyz) {
        return -1;
    }

    @Override
    public void addPoint(HepRepPoint point) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("HepRepInstanceAdapter.addPoint is not implemented.");
    }

    @Override
    public void addInstance(HepRepInstance instance) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("HepRepInstanceAdapter.addInstance is not implemented.");
    }

    @Override
    public void removeInstance(HepRepInstance instance) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("HepRepInstanceAdapter.removeInstance is not implemented.");
    }

    @Override
    public hep.graphics.heprep.HepRepAttValue getAttValue(String name) {
        String lowerCaseName = name.toLowerCase();
        hep.graphics.heprep.HepRepAttValue attValue = this.getAttValueFromNode(lowerCaseName);
        return attValue != null ? attValue : this.getType().getAttValue(lowerCaseName);
    }

    @Override
    protected HepRepAttValue[] getAttValues() {
        return this.hepRepInstance.attValues;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (o instanceof HepRepInstance) {
            HepRepInstance ref = (HepRepInstance)o;
            if (!ref.getType().equals(this.getType())) {
                return false;
            }
            if (!ref.getInstances().equals(this.getInstances())) {
                return false;
            }
            return ref.getPoints().equals(this.getPoints());
        }
        return false;
    }

    @Override
    public int hashCode() {
        long code = this.getType().hashCode();
        code += (long)this.getInstances().hashCode();
        return (int)(code += (long)this.getPoints().hashCode());
    }

    public boolean isValid() {
        return this.valid;
    }

    public void validate() {
        if (this.valid) {
            return;
        }
        this.layer = this.getAttValue("layer").getString();
        this.hasFrame = this.getAttValue("hasframe").getBoolean();
        this.valid = true;
    }

    @Override
    public String getLayer() {
        this.validate();
        return this.layer;
    }

    @Override
    public boolean hasFrame() {
        this.validate();
        return this.hasFrame;
    }
}

