/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.test.pdf;

import hep.aida.ICloud1D;
import hep.aida.ref.pdf.Dependent;
import hep.aida.ref.pdf.Function;
import hep.aida.ref.pdf.Gaussian;
import hep.aida.ref.pdf.Parameter;
import hep.aida.ref.pdf.PdfFitter;
import hep.aida.ref.pdf.Sum;
import hep.aida.ref.test.pdf.AbstractPdfTestCase;
import java.util.Random;

public class SumOfGaussianFit
extends AbstractPdfTestCase {
    private ICloud1D c1 = this.histogramFactory().createCloud1D("Cloud 1D");

    public SumOfGaussianFit(String name) {
        super(name);
        Random r_1 = new Random(123L);
        Random r_2 = new Random(456L);
        for (int i = 0; i < 100000; ++i) {
            double x = r_1.nextGaussian();
            if (r_1.nextDouble() < 0.2) {
                x += 3.0 * r_2.nextGaussian();
            }
            this.c1.fill(x);
        }
    }

    public void testFit() {
        Dependent x = new Dependent("x", this.c1.lowerEdge(), this.c1.upperEdge());
        Parameter m1 = new Parameter("mean1", this.c1.mean(), 0.01);
        Parameter s1 = new Parameter("sigma1", 1.0);
        Parameter m2 = new Parameter("mean2", this.c1.mean(), 0.01);
        Parameter s2 = new Parameter("sigma2", 3.0);
        Gaussian gauss1 = new Gaussian("myGauss1", x, m1, s1);
        Gaussian gauss2 = new Gaussian("myGauss2", x, m2, s2);
        Sum s = new Sum("Sum of Gauss", gauss1, gauss2);
        Parameter f0 = s.getParameter("f0");
        f0.setValue(0.2);
        f0.setBounds(0.0, 1.0);
        PdfFitter fitter = new PdfFitter("uml", "minuit");
        fitter.fit(this.c1, (Function)s);
        SumOfGaussianFit.assertEquals((double)this.c1.mean(), (double)s.getParameter("mean1").value(), (double)0.01);
        SumOfGaussianFit.assertEquals((double)1.0, (double)s.getParameter("sigma1").value(), (double)0.02);
        SumOfGaussianFit.assertEquals((double)this.c1.mean(), (double)s.getParameter("mean2").value(), (double)0.01);
        SumOfGaussianFit.assertEquals((double)3.0, (double)s.getParameter("sigma2").value(), (double)0.2);
    }
}

