/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.remote.rmi.converters;

import hep.aida.IAnnotation;
import hep.aida.IManagedObject;
import hep.aida.ref.Annotation;
import hep.aida.ref.remote.RemoteTable;
import hep.aida.ref.remote.interfaces.ITable;
import hep.aida.ref.remote.rmi.converters.RmiConverter;
import hep.aida.ref.remote.rmi.data.RmiAnnotationItem;
import hep.aida.ref.remote.rmi.data.RmiTableData;
import java.text.DateFormat;
import java.util.Date;

public class RmiTableConverter
extends RmiConverter {
    protected static RmiTableConverter converter = null;

    public static RmiTableConverter getInstance() {
        if (converter == null) {
            converter = new RmiTableConverter();
        }
        return converter;
    }

    protected RmiTableConverter() {
        this.dataType = "RmiTableData";
        this.aidaType = "ITable";
    }

    @Override
    public Object createAidaObject(String name) {
        RemoteTable result = new RemoteTable(name);
        return result;
    }

    @Override
    public Object extractData(Object aidaObject) {
        RmiTableData data = null;
        if (aidaObject instanceof ITable) {
            data = this.createData((ITable)aidaObject);
        } else if (aidaObject instanceof Object[] && ((Object[])aidaObject)[0] instanceof ITable) {
            ITable[] arr = new ITable[((Object[])aidaObject).length];
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = (ITable)((Object[])aidaObject)[i];
            }
            data = this.createData(arr);
        } else {
            throw new IllegalArgumentException("Not supported data type: " + aidaObject.getClass().getName());
        }
        return data;
    }

    @Override
    public boolean updateAidaObject(Object aidaObject, Object newData) {
        RmiTableData data = null;
        if (newData instanceof RmiTableData) {
            data = (RmiTableData)newData;
        }
        if (!(aidaObject instanceof RemoteTable)) {
            throw new IllegalArgumentException("Not supported object type: " + aidaObject.getClass().getName());
        }
        if (data == null || !(data instanceof RmiTableData)) {
            throw new IllegalArgumentException("Not supported data type: " + (newData == null ? "null" : newData.getClass().getName()));
        }
        this.updateData((RemoteTable)aidaObject, data);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IManagedObject updateData(RemoteTable hist, RmiTableData data) {
        if (data == null) {
            return hist;
        }
        RemoteTable remoteTable = hist;
        synchronized (remoteTable) {
            hist.setFillable(true);
            RmiAnnotationItem[] items = data.getAnnotationItems();
            if (items != null && items.length > 0) {
                boolean sticky = false;
                IAnnotation localAnnotation = hist.annotation();
                if (localAnnotation instanceof Annotation) {
                    ((Annotation)localAnnotation).setFillable(true);
                }
                for (int i = 0; i < items.length; ++i) {
                    String key = items[i].key;
                    String newValue = items[i].value;
                    String oldValue = null;
                    try {
                        oldValue = localAnnotation.value(key);
                    }
                    catch (IllegalArgumentException e) {
                        // empty catch block
                    }
                    if (oldValue == null) {
                        localAnnotation.addItem(key, newValue, sticky);
                        continue;
                    }
                    if (newValue.equals(oldValue)) continue;
                    localAnnotation.setValue(key, newValue);
                    localAnnotation.setSticky(key, sticky);
                }
                Date date = new Date();
                DateFormat df = DateFormat.getTimeInstance();
                String dateString = df.format(date);
                try {
                    String value = localAnnotation.value("stat.Updated");
                    if (value == null || value.equals("0") || value.equals("")) {
                        localAnnotation.setValue("stat.Updated", dateString);
                    }
                }
                catch (IllegalArgumentException e) {
                    localAnnotation.addItem("stat.Updated", dateString);
                }
                if (localAnnotation instanceof Annotation) {
                    ((Annotation)localAnnotation).setFillable(false);
                }
            }
            hist.setLabels(data.getLabels());
            hist.setValues(data.getValues());
            hist.setFillable(false);
            hist.setDataValid(true);
        }
        return hist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RmiTableData createData(ITable hist) {
        RmiTableData data = new RmiTableData();
        RmiAnnotationItem[] rAnnotation = null;
        String[] labels = null;
        Object[][] values = null;
        ITable iTable = hist;
        synchronized (iTable) {
            boolean sticky = false;
            IAnnotation lAnnotation = hist.annotation();
            if (lAnnotation != null && lAnnotation.size() > 0) {
                rAnnotation = new RmiAnnotationItem[lAnnotation.size()];
                for (int i = 0; i < lAnnotation.size(); ++i) {
                    String key = lAnnotation.key(i);
                    String value = lAnnotation.value(key);
                    rAnnotation[i] = new RmiAnnotationItem(key, value, sticky);
                }
            }
            int columns = hist.columnCount();
            int rows = hist.rowCount();
            labels = new String[columns];
            values = new Object[rows][columns];
            for (int i = 0; i < columns; ++i) {
                labels[i] = hist.columnName(i);
                for (int j = 0; j < rows; ++j) {
                    values[j][i] = hist.valueAt(j, i);
                }
            }
        }
        data.setAnnotationItems(rAnnotation);
        data.setLabels(labels);
        data.setValues(values);
        return data;
    }

    public RmiTableData createData(ITable[] arr) {
        RmiTableData data = this.createData(arr[0]);
        return data;
    }
}

