/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.remote.basic;

import hep.aida.ITree;
import hep.aida.ref.remote.basic.BasicTreeServant;
import hep.aida.ref.remote.basic.interfaces.AidaTreeClient;
import hep.aida.ref.remote.basic.interfaces.AidaTreeServant;
import hep.aida.ref.remote.basic.interfaces.AidaTreeServer;
import java.util.Hashtable;

public class BasicTreeServer
implements AidaTreeServer {
    protected ITree tree;
    protected String treeName;
    protected Hashtable hash;

    public BasicTreeServer(ITree tree) {
        this(tree, tree.storeName());
    }

    public BasicTreeServer(ITree tree, String treeName) {
        System.out.print("\nStarting TreeServer with Tree Name: " + treeName + " ... ");
        this.tree = tree;
        this.treeName = treeName;
        this.init();
        System.out.print(" Done.\n");
    }

    protected void init() {
        this.hash = new Hashtable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean disconnectClient(Object client) {
        System.out.print("\n\tBasicTreeServer.disconnectClient disconnecting Client: " + client.toString());
        BasicTreeServant servant = null;
        Hashtable hashtable = this.hash;
        synchronized (hashtable) {
            if (!this.hash.containsKey(client)) {
                System.out.print("\n\t*** Warning: Can not find AidaTreeServant for this Client!");
                return false;
            }
            servant = (BasicTreeServant)this.hash.get(client);
            this.hash.remove(client);
        }
        servant.close();
        System.out.print(" Done.\n");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        System.out.print("Shutting down BasicTreeServer ... ");
        BasicTreeServer basicTreeServer = this;
        synchronized (basicTreeServer) {
            if (!this.hash.isEmpty()) {
                for (BasicTreeServant servant : this.hash.values()) {
                    servant.close();
                }
                this.hash.clear();
            }
            this.hash = null;
            this.tree = null;
            this.treeName = null;
        }
        System.out.print(" Done!\n");
    }

    @Override
    public AidaTreeServant connectDuplex(AidaTreeClient client) {
        BasicTreeServant servant = null;
        if (this.hash.containsKey(client)) {
            System.out.println("Warning: this Client is already connected, returning its servant");
            servant = (BasicTreeServant)this.hash.get(client);
        } else {
            servant = new BasicTreeServant(this.tree, client);
            this.hash.put(client, servant);
        }
        return servant;
    }

    @Override
    public AidaTreeServant connectNonDuplex(String clientID) {
        BasicTreeServant servant = null;
        System.out.print("\nBasicTreeServer.connect: clientID=" + clientID + " ... ");
        if (this.hash.containsKey(clientID)) {
            System.out.println("Warning: this Client is already connected, returning its servant");
            servant = (BasicTreeServant)this.hash.get(clientID);
        } else {
            servant = new BasicTreeServant(this.tree, clientID);
            this.hash.put(clientID, servant);
        }
        System.out.print(" Done.\n");
        return servant;
    }

    @Override
    public boolean disconnectDuplex(AidaTreeClient client) {
        return this.disconnectClient(client);
    }

    @Override
    public boolean disconnectNonDuplex(String clientID) {
        return this.disconnectClient(clientID);
    }

    @Override
    public boolean supportDuplexMode() {
        return true;
    }

    @Override
    public String treeName() {
        return this.treeName;
    }
}

