/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.remote;

import hep.aida.IAnnotation;
import hep.aida.IAxis;
import hep.aida.IBaseHistogram;
import hep.aida.IHistogram1D;
import hep.aida.dev.IDevMutableStore;
import hep.aida.ref.Annotation;
import hep.aida.ref.ReadOnlyException;
import hep.aida.ref.event.HistogramEvent;
import hep.aida.ref.histogram.FixedAxis;
import hep.aida.ref.remote.RemoteManagedObject;
import java.util.EventObject;

public class RemoteHistogram1D
extends RemoteManagedObject
implements IHistogram1D {
    private Annotation annotation = null;
    private IAxis axis = null;
    private double[] heights = null;
    private double[] errors = null;
    private int[] entries = null;
    private double[] means = null;
    private double[] rmss = null;
    private double mean = DEFAULT_DOUBLE;
    private double rms = DEFAULT_DOUBLE;
    private int inRangeEntries = DEFAULT_INT;
    private int nanEntries = DEFAULT_INT;
    private int minBinEntries = DEFAULT_INT;
    private int maxBinEntries = DEFAULT_INT;
    private double inRangeHeights = DEFAULT_DOUBLE;
    private double equivalentBinEntries = DEFAULT_DOUBLE;
    private double minBinHeights = DEFAULT_DOUBLE;
    private double maxBinHeights = DEFAULT_DOUBLE;

    public RemoteHistogram1D(String name) {
        this(null, name);
    }

    public RemoteHistogram1D(IDevMutableStore store, String name) {
        this(store, name, name, 1, 0.0, 1.0);
    }

    public RemoteHistogram1D(IDevMutableStore store, String name, String title, int bins, double min, double max) {
        super(name);
        this.aidaType = "IHistogram1D";
        this.store = store;
        this.annotation = new Annotation();
        this.annotation.setFillable(true);
        this.annotation.addItem(Annotation.titleKey, title, true);
        this.annotation.setFillable(false);
        this.dataIsValid = false;
        this.setAxis(bins, min, max);
    }

    @Override
    protected EventObject createEvent() {
        return new HistogramEvent((IBaseHistogram)this);
    }

    @Override
    public void setTreeFolder(String treeFolder) {
        super.setTreeFolder(treeFolder);
        boolean flbl = this.annotation.isFillable();
        if (!flbl) {
            this.annotation.setFillable(true);
        }
        if (this.annotation.hasKey(Annotation.fullPathKey)) {
            this.annotation.setValue(Annotation.fullPathKey, this.treePath);
        } else {
            this.annotation.addItem(Annotation.fullPathKey, this.treePath, true);
        }
        if (!flbl) {
            this.annotation.setFillable(false);
        }
    }

    private int convertAIDAIndex(int index) {
        int mi = index == -2 ? 0 : (index == -1 ? this.axis().bins() + 1 : index + 1);
        return mi;
    }

    public void setAxis(int bins, double min, double max) {
        this.axis = new FixedAxis(bins, min, max);
    }

    public void setEquivalentBinEntries(double d) {
        this.equivalentBinEntries = d;
    }

    public void setNanEntries(int i) {
        this.nanEntries = i;
    }

    public void setRms(double rms) {
        this.rms = rms;
    }

    public void setMean(double mean) {
        this.mean = mean;
    }

    public void setHeights(double[] h) {
        if (h == null || h.length == 0) {
            this.heights = null;
            this.inRangeHeights = DEFAULT_DOUBLE;
            this.minBinHeights = DEFAULT_DOUBLE;
            this.maxBinHeights = DEFAULT_DOUBLE;
            return;
        }
        this.heights = h;
        this.inRangeHeights = 0.0;
        this.minBinHeights = Double.MAX_VALUE;
        this.maxBinHeights = Double.MIN_VALUE;
        for (int i = 1; i < h.length - 1; ++i) {
            this.inRangeHeights += h[i];
            if (h[i] > this.maxBinHeights) {
                this.maxBinHeights = h[i];
            }
            if (!(h[i] < this.minBinHeights)) continue;
            this.minBinHeights = h[i];
        }
    }

    public void setEntries(int[] h) {
        if (h == null || h.length == 0) {
            this.entries = null;
            this.inRangeEntries = DEFAULT_INT;
            this.minBinEntries = DEFAULT_INT;
            this.maxBinEntries = DEFAULT_INT;
            return;
        }
        this.entries = h;
        this.inRangeEntries = 0;
        this.minBinEntries = Integer.MAX_VALUE;
        this.maxBinEntries = Integer.MIN_VALUE;
        for (int i = 1; i < h.length - 1; ++i) {
            this.inRangeEntries += h[i];
            if (h[i] > this.maxBinEntries) {
                this.maxBinEntries = h[i];
            }
            if (h[i] >= this.minBinEntries) continue;
            this.minBinEntries = h[i];
        }
    }

    public void setErrors(double[] h) {
        if (h == null || h.length == 0) {
            this.errors = null;
            return;
        }
        this.errors = h;
    }

    public void setMeans(double[] h) {
        if (h == null || h.length == 0) {
            this.means = null;
            return;
        }
        this.means = new double[h.length];
        System.arraycopy(h, 0, this.means, 0, h.length);
    }

    public void setRmss(double[] h) {
        if (h == null || h.length == 0) {
            this.rmss = null;
            return;
        }
        this.rmss = h;
    }

    public int[] getBinEntries() {
        return this.entries;
    }

    public double[] getBinHeights() {
        return this.heights;
    }

    public double[] getBinErrors() {
        return this.errors;
    }

    public double[] getBinMeans() {
        return this.means;
    }

    public double[] getBinRms() {
        return this.rmss;
    }

    public IAnnotation annotation() {
        this.makeSureDataIsValid();
        return this.annotation;
    }

    public IAxis axis() {
        this.makeSureDataIsValid();
        return this.axis;
    }

    public int dimension() {
        return 1;
    }

    public double mean() {
        this.makeSureDataIsValid();
        return this.mean;
    }

    public double rms() {
        this.makeSureDataIsValid();
        return this.rms;
    }

    public double equivalentBinEntries() {
        this.makeSureDataIsValid();
        if (this.entries == null) {
            return DEFAULT_INT;
        }
        return this.equivalentBinEntries;
    }

    public int entries() {
        this.makeSureDataIsValid();
        if (this.entries == null && this.heights != null) {
            return (int)this.inRangeHeights;
        }
        return this.inRangeEntries;
    }

    public int allEntries() {
        this.makeSureDataIsValid();
        if (this.entries == null) {
            if (this.heights != null) {
                return (int)this.sumAllBinHeights();
            }
            return DEFAULT_INT;
        }
        return this.entries() + this.extraEntries();
    }

    public int extraEntries() {
        this.makeSureDataIsValid();
        if (this.entries == null) {
            if (this.heights != null) {
                return (int)(this.heights[0] + this.heights[this.heights.length - 1]);
            }
            return DEFAULT_INT;
        }
        return this.entries[0] + this.entries[this.entries.length - 1];
    }

    public int nanEntries() {
        this.makeSureDataIsValid();
        return this.nanEntries;
    }

    public double maxBinHeight() {
        this.makeSureDataIsValid();
        if (this.heights == null && this.entries != null) {
            return this.maxBinEntries;
        }
        return this.maxBinHeights;
    }

    public double minBinHeight() {
        this.makeSureDataIsValid();
        if (this.heights == null && this.entries != null) {
            return this.minBinEntries;
        }
        return this.minBinHeights;
    }

    public double sumAllBinHeights() {
        this.makeSureDataIsValid();
        if (this.heights == null) {
            if (this.entries != null) {
                return this.allEntries();
            }
            return DEFAULT_DOUBLE;
        }
        return this.sumBinHeights() + this.sumExtraBinHeights();
    }

    public double sumBinHeights() {
        this.makeSureDataIsValid();
        if (this.heights == null && this.entries != null) {
            return this.inRangeEntries;
        }
        return this.inRangeHeights;
    }

    public double sumExtraBinHeights() {
        this.makeSureDataIsValid();
        if (this.heights == null) {
            if (this.entries != null) {
                return this.entries[0] + this.entries[this.entries.length - 1];
            }
            return DEFAULT_DOUBLE;
        }
        return this.heights[0] + this.heights[this.heights.length - 1];
    }

    public int binEntries(int param) throws IllegalArgumentException {
        this.makeSureDataIsValid();
        if (this.entries == null) {
            if (this.heights != null) {
                return (int)this.binHeight(param);
            }
            return DEFAULT_INT;
        }
        return this.entries[this.convertAIDAIndex(param)];
    }

    public double binError(int param) throws IllegalArgumentException {
        this.makeSureDataIsValid();
        if (this.errors == null) {
            return Math.sqrt(this.binHeight(param));
        }
        return this.errors[this.convertAIDAIndex(param)];
    }

    public double binHeight(int param) throws IllegalArgumentException {
        this.makeSureDataIsValid();
        if (this.heights == null) {
            if (this.entries != null) {
                return this.binEntries(param);
            }
            return DEFAULT_DOUBLE;
        }
        return this.heights[this.convertAIDAIndex(param)];
    }

    public double binMean(int param) throws IllegalArgumentException {
        this.makeSureDataIsValid();
        double d = DEFAULT_DOUBLE;
        d = this.means == null ? (param == -2 ? Double.NEGATIVE_INFINITY : (param == -1 ? Double.POSITIVE_INFINITY : this.axis.binCenter(param))) : this.means[this.convertAIDAIndex(param)];
        return d;
    }

    public double binRms(int param) {
        this.makeSureDataIsValid();
        double d = DEFAULT_DOUBLE;
        d = this.rmss == null ? (param == -2 ? DEFAULT_DOUBLE : (param == -1 ? DEFAULT_DOUBLE : this.axis.binWidth(param) / rmsFactor)) : this.rmss[this.convertAIDAIndex(param)];
        return d;
    }

    public int coordToIndex(double param) {
        this.makeSureDataIsValid();
        return this.axis.coordToIndex(param);
    }

    public String title() {
        return this.annotation.value(Annotation.titleKey);
    }

    public void setTitle(String title) throws IllegalArgumentException {
        if (!this.fillable) {
            throw new ReadOnlyException();
        }
        this.annotation.setFillable(true);
        this.annotation.setValue(Annotation.titleKey, title);
        this.annotation.setFillable(false);
    }

    public void add(IHistogram1D iHistogram1D) throws IllegalArgumentException {
        throw new ReadOnlyException();
    }

    public void fill(double param) throws IllegalArgumentException {
        throw new ReadOnlyException();
    }

    public void fill(double param, double param1) throws IllegalArgumentException {
        throw new ReadOnlyException();
    }

    public void reset() throws RuntimeException {
        throw new ReadOnlyException();
    }

    public void scale(double param) throws IllegalArgumentException {
        throw new ReadOnlyException();
    }
}

