/*
 * Decompiled with CFR 0.152.
 */
package com.edsdev.jconvert.util;

import com.edsdev.jconvert.util.JConvertSettingsProperties;
import java.lang.reflect.Method;
import java.util.Date;

public class Logger {
    private Class clazz;
    private Object log4jLogger = null;
    private static boolean searchedForLog4j = false;
    private static final String LOG4J_PATH = "dissabled by Sergei";
    private static final String DEBUG = "debug";
    private static final String INFO = "info";
    private static final String WARN = "warn";
    private static final String ERROR = "error";
    private static final String FATAL = "fatal";

    public static Logger getInstance(Class clazz) {
        return new Logger(clazz);
    }

    public Logger(Class clazz) {
        this.clazz = clazz;
        if (!searchedForLog4j) {
            searchedForLog4j = true;
            try {
                Class<?> clazz2 = Class.forName(LOG4J_PATH);
                Method method = clazz2.getMethod("getLogger", Class.class);
                this.log4jLogger = method.invoke(null, this.clazz);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void invokeLoggerMethod(String string, Object object) {
        try {
            Method method = this.log4jLogger.getClass().getMethod(string, Object.class);
            method.invoke(this.log4jLogger, object);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void invokeLoggerMethod(String string, Object object, Throwable throwable) {
        try {
            Method method = this.log4jLogger.getClass().getMethod(string, Object.class, Throwable.class);
            method.invoke(this.log4jLogger, object, throwable);
        }
        catch (Exception exception) {
            System.out.println("Failed to log using the logger. Message is :" + object);
            throwable.printStackTrace();
        }
    }

    private void printMessage(String string, Object object, Throwable throwable) {
        if (this.log4jLogger == null) {
            if (this.shouldLog(string)) {
                System.out.println(new Date() + " - " + string.toUpperCase() + " - " + this.clazz.getName() + " - " + object);
                if (throwable != null) {
                    throwable.printStackTrace();
                }
            }
        } else if (throwable == null) {
            this.invokeLoggerMethod(string, object);
        } else {
            this.invokeLoggerMethod(string, object, throwable);
        }
    }

    private boolean shouldLog(String string) {
        String string2 = "";
        try {
            string2 = JConvertSettingsProperties.getLogLevel();
        }
        catch (Exception exception) {
            return true;
        }
        if (string2.equalsIgnoreCase(DEBUG)) {
            return true;
        }
        if (string2.equalsIgnoreCase(INFO)) {
            return !string.equalsIgnoreCase(DEBUG);
        }
        if (string2.equalsIgnoreCase(WARN)) {
            return !string.equalsIgnoreCase(DEBUG) && !string.equalsIgnoreCase(INFO);
        }
        if (string2.equalsIgnoreCase(ERROR)) {
            return string.equalsIgnoreCase(ERROR) || string.equalsIgnoreCase(FATAL);
        }
        if (string2.equalsIgnoreCase(FATAL)) {
            return string.equalsIgnoreCase(FATAL);
        }
        return false;
    }

    public void debug(Object object) {
        this.printMessage(DEBUG, object, null);
    }

    public void info(Object object) {
        this.printMessage(INFO, object, null);
    }

    public void warn(Object object) {
        this.printMessage(WARN, object, null);
    }

    public void warn(Object object, Throwable throwable) {
        this.printMessage(DEBUG, object, throwable);
    }

    public void error(Object object) {
        this.printMessage(ERROR, object, null);
    }

    public void error(Object object, Throwable throwable) {
        this.printMessage(ERROR, object, throwable);
    }

    public void fatal(Object object) {
        this.printMessage(FATAL, object, null);
    }

    public void fatal(Object object, Throwable throwable) {
        this.printMessage(DEBUG, object, throwable);
    }
}

