/*
 * Decompiled with CFR 0.152.
 */
package com.edsdev.jconvert.presentation;

import com.edsdev.jconvert.common.CustomConversionDataInterface;
import com.edsdev.jconvert.domain.ConversionType;
import com.edsdev.jconvert.persistence.DataLoader;
import com.edsdev.jconvert.presentation.AboutDialog;
import com.edsdev.jconvert.presentation.AddCustomConversionDlg;
import com.edsdev.jconvert.presentation.ConversionPanel;
import com.edsdev.jconvert.presentation.ConversionTypeData;
import com.edsdev.jconvert.presentation.ConversionsChangedListener;
import com.edsdev.jconvert.presentation.SettingsDlg;
import com.edsdev.jconvert.presentation.component.CustomTabConversionPanel;
import com.edsdev.jconvert.util.JCClassLoader;
import com.edsdev.jconvert.util.JConvertProperties;
import com.edsdev.jconvert.util.JConvertSettingsProperties;
import com.edsdev.jconvert.util.Messages;
import com.edsdev.jconvert.util.ResourceManager;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;

public class MainFrame
extends JFrame
implements ConversionsChangedListener {
    private static final long serialVersionUID = 1L;
    private AboutDialog aboutDlg = null;
    private JTabbedPane tabbedPane = null;
    private List data;

    public static void main(String[] stringArray) {
        MainFrame mainFrame = new MainFrame();
        mainFrame.setIconImage(ResourceManager.getImage("icon.jpg"));
        mainFrame.setVisible(true);
    }

    private static void initializeLocale() {
        Locale[] localeArray = Locale.getAvailableLocales();
        for (int i = 0; i < localeArray.length; ++i) {
        }
        String string = JConvertSettingsProperties.getLocaleLanguage();
        if (string != null) {
            String string2 = JConvertSettingsProperties.getLocaleCountry();
            String string3 = JConvertSettingsProperties.getLocaleVariant();
            if (string2 == null) {
                string2 = "";
            }
            if (string3 == null) {
                string3 = "";
            }
            Locale.setDefault(new Locale(string, string2, string3));
        }
    }

    public MainFrame() {
        MainFrame.initializeLocale();
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.initFonts();
        this.setDefaultCloseOperation(2);
        this.init();
    }

    private void init() {
        this.setTitle("JConvert (" + JConvertProperties.getBuidVersion() + ")");
        this.setJMenuBar(this.getMenu());
        this.setContent();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                MainFrame.this.saveSettings();
            }
        });
        this.loadSettings();
    }

    private void setPos(int n, int n2) {
        this.setLocation(n, n2);
    }

    private void loadSettings() {
        this.setSize(600, 400);
        try {
            String string = JConvertSettingsProperties.getAppWidth();
            if (string != null) {
                this.setSize(new Integer(string), new Integer(JConvertSettingsProperties.getAppHeight()));
                this.setPos(new Integer(JConvertSettingsProperties.getAppX()), new Integer(JConvertSettingsProperties.getAppY()));
                this.restorTabInfo();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void restorTabInfo() {
        String string = JConvertSettingsProperties.getLastTab();
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            if (!this.tabbedPane.getTitleAt(i).equals(string)) continue;
            this.tabbedPane.setSelectedIndex(i);
            ConversionPanel conversionPanel = (ConversionPanel)this.tabbedPane.getComponent(i);
            conversionPanel.setFromUnit(JConvertSettingsProperties.getLastFrom());
            conversionPanel.setToUnit(JConvertSettingsProperties.getLastTo());
            conversionPanel.setFromValue(JConvertSettingsProperties.getLastValue());
            conversionPanel.convert();
        }
    }

    public void recordCurrentTabInfo() {
        JConvertSettingsProperties.setLastTab(this.tabbedPane.getTitleAt(this.tabbedPane.getSelectedIndex()));
        ConversionPanel conversionPanel = (ConversionPanel)this.tabbedPane.getSelectedComponent();
        JConvertSettingsProperties.setLastValue(conversionPanel.getFromValue());
        JConvertSettingsProperties.setLastFrom(conversionPanel.getFromUnit());
        JConvertSettingsProperties.setLastTo(conversionPanel.getToUnit());
    }

    private void saveSettings() {
        JConvertSettingsProperties.setAppWidth(this.getWidth() + "");
        JConvertSettingsProperties.setAppHeight(this.getHeight() + "");
        JConvertSettingsProperties.setAppX(this.getX() + "");
        JConvertSettingsProperties.setAppY(this.getY() + "");
        this.recordCurrentTabInfo();
        JConvertSettingsProperties.setLocaleLanguage(Locale.getDefault().getLanguage());
        JConvertSettingsProperties.setLocaleCountry(Locale.getDefault().getCountry());
        JConvertSettingsProperties.setLocaleVariant(Locale.getDefault().getVariant());
        JConvertSettingsProperties.persist();
    }

    private void setContent() {
        this.getContentPane().removeAll();
        this.tabbedPane = new JTabbedPane();
        this.getContentPane().add(this.tabbedPane);
        this.data = this.getData();
        Collections.sort(this.data);
        Iterator iterator = this.data.iterator();
        List list = this.getHiddenTabs();
        while (iterator.hasNext()) {
            ConversionTypeData conversionTypeData = (ConversionTypeData)iterator.next();
            if (list.contains(conversionTypeData.getTypeName())) continue;
            JPanel jPanel = this.getNewPanel(conversionTypeData);
            this.tabbedPane.addTab(Messages.getUnitTranslation(conversionTypeData.getTypeName()), jPanel);
        }
        this.addCustomPanel(JConvertSettingsProperties.getCustomConversionClass(), JConvertSettingsProperties.getCustomConversionJar());
    }

    private void addCustomPanel(String string, String string2) {
        if (string == null || string.trim().length() == 0) {
            return;
        }
        try {
            JCClassLoader jCClassLoader = null;
            jCClassLoader = string2 == null || string2.trim().length() == 0 ? new JCClassLoader(ResourceManager.getJarPath()) : new JCClassLoader(string2);
            CustomConversionDataInterface customConversionDataInterface = (CustomConversionDataInterface)jCClassLoader.loadClass(string).newInstance();
            CustomTabConversionPanel customTabConversionPanel = new CustomTabConversionPanel(customConversionDataInterface);
            this.tabbedPane.addTab(customConversionDataInterface.getConversions().getTypeName(), customTabConversionPanel);
        }
        catch (Throwable throwable) {
            System.err.println("Failed to create custom tab.");
        }
    }

    private List getHiddenTabs() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = JConvertSettingsProperties.getHiddenTabs();
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken());
            }
        }
        return arrayList;
    }

    private JPanel getNewPanel(ConversionTypeData conversionTypeData) {
        return new ConversionPanel(conversionTypeData);
    }

    private JMenuBar getMenu() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu(Messages.getResource("fileMenu"));
        jMenu.setMnemonic(this.getChar("fileMenuMnemonic"));
        JMenuItem jMenuItem = new JMenuItem(Messages.getResource("fileMenuSettings"));
        jMenuItem.setMnemonic(this.getChar("fileMenuSettingsMnemonic"));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SettingsDlg settingsDlg = new SettingsDlg((Frame)MainFrame.this, MainFrame.this.data);
                settingsDlg.addConversionsChangedListener(MainFrame.this);
                settingsDlg.show();
            }
        });
        JMenuItem jMenuItem2 = new JMenuItem(Messages.getResource("fileMenuCustom"));
        jMenuItem2.setMnemonic(this.getChar("fileMenuCustomMnemonic"));
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddCustomConversionDlg addCustomConversionDlg = new AddCustomConversionDlg(MainFrame.this);
                addCustomConversionDlg.addConversionsChangedListener(MainFrame.this);
                addCustomConversionDlg.show();
            }
        });
        JMenuItem jMenuItem3 = new JMenuItem(Messages.getResource("fileMenuExit"));
        jMenuItem3.setMnemonic(this.getChar("fileMenuExitMnemonic"));
        jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        });
        jMenu.add(jMenuItem);
        jMenu.add(jMenuItem2);
        jMenu.addSeparator();
        jMenu.add(jMenuItem3);
        JMenu jMenu2 = new JMenu(Messages.getResource("helpMenu"));
        jMenu2.setMnemonic(this.getChar("helpMenuMnemonic"));
        JMenuItem jMenuItem4 = new JMenuItem(Messages.getResource("helpAbout"));
        jMenuItem4.setMnemonic(this.getChar("helpAboutMnemonic"));
        jMenuItem4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.displayAboutDialog();
            }
        });
        jMenu2.add(jMenuItem4);
        jMenuBar.add(jMenu);
        jMenuBar.add(jMenu2);
        return jMenuBar;
    }

    private char getChar(String string) {
        String string2 = Messages.getResource(string);
        return string2.charAt(0);
    }

    private void displayAboutDialog() {
        if (this.aboutDlg == null) {
            this.aboutDlg = new AboutDialog(this);
        }
        this.aboutDlg.setVisible(true);
    }

    private List getData() {
        ArrayList<ConversionTypeData> arrayList = new ArrayList<ConversionTypeData>();
        List list = new DataLoader().loadData();
        for (ConversionType conversionType : list) {
            ConversionTypeData conversionTypeData = new ConversionTypeData(conversionType);
            arrayList.add(conversionTypeData);
        }
        return arrayList;
    }

    @Override
    public void conversionsUpdated() {
        this.saveSettings();
        Messages.resetBundle();
        this.initFonts();
        this.setJMenuBar(this.getMenu());
        this.setContent();
        this.loadSettings();
    }

    private void initFonts() {
        String string = Messages.getResource("Acceleration") + Messages.getResource("meter/sec\u00b2");
        JLabel jLabel = new JLabel();
        if (jLabel.getFont().canDisplayUpTo(string) == -1) {
            return;
        }
        Font[] fontArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
        for (int i = 0; i < fontArray.length; ++i) {
            if (fontArray[i].canDisplayUpTo(string) != -1) continue;
            this.setUIFont(new FontUIResource(fontArray[i].getFontName(), 0, 10));
            return;
        }
        System.err.println("Unable to determine a proper font for the language " + Locale.getDefault().getDisplayName() + ".");
        System.err.println("This will most likely result in poor rendering of JConvert.");
    }

    private void setUIFont(FontUIResource fontUIResource) {
        Enumeration enumeration = UIManager.getDefaults().keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Object object = UIManager.get(k);
            if (!(object instanceof FontUIResource)) continue;
            UIManager.put(k, fontUIResource);
        }
    }
}

