/*
 * Decompiled with CFR 0.152.
 */
package com.edsdev.jconvert.domain;

import com.edsdev.jconvert.domain.Conversion;
import com.edsdev.jconvert.util.Logger;
import java.math.BigInteger;

public class FractionalConversion
extends Conversion {
    private BigInteger fromToWholeNumber = BigInteger.ZERO;
    private BigInteger fromToTopFactor = BigInteger.ZERO;
    private BigInteger fromToBottomFactor = BigInteger.ONE;
    private static Logger log = Logger.getInstance(FractionalConversion.class);

    public FractionalConversion(String string, String string2, String string3, String string4, String string5, double d) {
        super(string, string2, string3, string4, string5, d);
        this.setFromToFactorString(string5);
    }

    @Override
    public double convertValue(double d, String string) {
        if (string.equals(this.getFromUnit())) {
            return this.getRoundedResult(d * this.getEffectiveNumerator(this).doubleValue() / this.fromToBottomFactor.doubleValue() + this.getFromToOffset());
        }
        return this.getRoundedResult((d - this.getFromToOffset()) * this.fromToBottomFactor.doubleValue() / this.getEffectiveNumerator(this).doubleValue());
    }

    @Override
    public String convertValue(BigInteger bigInteger, BigInteger bigInteger2, String string) {
        if (FractionalConversion.isWholeNumber(this.getFromToOffset() + "")) {
            if (string.equals(this.getFromUnit())) {
                BigInteger bigInteger3 = bigInteger.multiply(this.getEffectiveNumerator(this));
                BigInteger bigInteger4 = bigInteger2.multiply(this.fromToBottomFactor);
                bigInteger3 = bigInteger3.add(bigInteger4.multiply(this.getBigInteger(this.getFromToOffset() + "")));
                return FractionalConversion.reduceFraction(bigInteger3 + "/" + bigInteger4);
            }
            BigInteger bigInteger5 = bigInteger.subtract(bigInteger2.multiply(this.getBigInteger(this.getFromToOffset() + "")));
            bigInteger5 = bigInteger5.multiply(this.fromToBottomFactor);
            BigInteger bigInteger6 = bigInteger2.multiply(this.getEffectiveNumerator(this));
            return FractionalConversion.reduceFraction(bigInteger5 + "/" + bigInteger6);
        }
        return "unknown";
    }

    @Override
    public String multiply(Conversion conversion) {
        String string = "1";
        if (conversion instanceof FractionalConversion) {
            FractionalConversion fractionalConversion = (FractionalConversion)conversion;
            BigInteger bigInteger = this.getEffectiveNumerator(fractionalConversion);
            string = this.getEffectiveNumerator(this).multiply(bigInteger) + "/" + this.getFromToBottomFactor().multiply(fractionalConversion.getFromToBottomFactor());
            if (!string.equals("Infinity")) {
                return string;
            }
        }
        string = this.getEffectiveNumerator(this).doubleValue() * conversion.getFromToFactor() / this.getFromToBottomFactor().doubleValue() + "";
        return string;
    }

    @Override
    public String divide(Conversion conversion) {
        String string = "1";
        if (conversion instanceof FractionalConversion) {
            FractionalConversion fractionalConversion = (FractionalConversion)conversion;
            BigInteger bigInteger = this.getEffectiveNumerator(fractionalConversion);
            string = this.getEffectiveNumerator(this).multiply(fractionalConversion.getFromToBottomFactor()) + "/" + this.getFromToBottomFactor().multiply(bigInteger);
            if (!string.equals("Infinity")) {
                return string;
            }
        }
        string = this.getEffectiveNumerator(this).doubleValue() / (this.getFromToBottomFactor().doubleValue() * conversion.getFromToFactor()) + "";
        return string;
    }

    @Override
    public BigInteger getFromToBottomFactor() {
        return this.fromToBottomFactor;
    }

    @Override
    public void setFromToBottomFactor(BigInteger bigInteger) {
        this.fromToBottomFactor = bigInteger;
    }

    @Override
    public BigInteger getFromToTopFactor() {
        return this.fromToTopFactor;
    }

    @Override
    public void setFromToTopFactor(BigInteger bigInteger) {
        this.fromToTopFactor = bigInteger;
    }

    @Override
    public double getFromToFactor() {
        throw new RuntimeException("Not Supported");
    }

    @Override
    public void setFromToFactor(double d) {
        throw new RuntimeException("Not Supported");
    }

    @Override
    public void setFromToFactorString(String string) {
        int n = string.indexOf("/");
        if (n > 0) {
            int n2 = string.indexOf(" ");
            if (n2 < 0) {
                n2 = 0;
            }
            String string2 = string.substring(0, n2).trim();
            String string3 = string.substring(n2, n).trim();
            String string4 = string.substring(n + 1).trim();
            this.fromToTopFactor = this.getBigInteger(string3);
            this.fromToBottomFactor = this.getBigInteger(string4);
            if (string2.length() > 0) {
                this.fromToWholeNumber = this.getBigInteger(string2);
            }
        } else if (FractionalConversion.isWholeNumber(string)) {
            this.fromToWholeNumber = this.getBigInteger(string);
            this.fromToTopFactor = BigInteger.ZERO;
            this.fromToBottomFactor = BigInteger.ONE;
        } else {
            log.error("Tried to process decimal as fraction:" + string);
        }
    }

    private static BigInteger getTop(String string) {
        int n = string.indexOf(" ");
        if (n < 0) {
            n = 0;
        }
        int n2 = string.indexOf("/");
        return new BigInteger(string.substring(n, n2).trim());
    }

    private static BigInteger getBottom(String string) {
        int n = string.indexOf("/");
        return new BigInteger(string.substring(n + 1, string.length()));
    }

    private static BigInteger getWholeNum(String string) {
        int n = string.indexOf(" ");
        if (n < 0) {
            return BigInteger.ZERO;
        }
        return new BigInteger(string.substring(0, n).trim());
    }

    public BigInteger getEffectiveNumerator(FractionalConversion fractionalConversion) {
        return fractionalConversion.getFromToTopFactor().add(fractionalConversion.getFromToWholeNumber().multiply(fractionalConversion.getFromToBottomFactor()));
    }

    @Override
    public BigInteger getFromToWholeNumber() {
        return this.fromToWholeNumber;
    }

    @Override
    public void setFromToWholeNumber(BigInteger bigInteger) {
        this.fromToWholeNumber = bigInteger;
    }

    public static String reduceFraction(String string) {
        Object object;
        Object object2;
        BigInteger bigInteger = FractionalConversion.getTop(string);
        BigInteger bigInteger2 = FractionalConversion.getBottom(string);
        BigInteger bigInteger3 = FractionalConversion.getWholeNum(string);
        if (bigInteger.abs().compareTo(bigInteger2.abs()) == 1) {
            object2 = bigInteger.divideAndRemainder(bigInteger2);
            object = object2[0];
            bigInteger = bigInteger.subtract(((BigInteger)object).multiply(bigInteger2)).abs();
            bigInteger3 = bigInteger3.add((BigInteger)object);
        }
        if (bigInteger.equals(BigInteger.ZERO)) {
            return bigInteger3 + "";
        }
        object2 = bigInteger.gcd(bigInteger2);
        if (!((BigInteger)object2).equals(BigInteger.ONE)) {
            bigInteger = bigInteger.divide((BigInteger)object2);
            bigInteger2 = bigInteger2.divide((BigInteger)object2);
        }
        object = "";
        if (!bigInteger3.equals(BigInteger.ZERO)) {
            object = bigInteger3 + " ";
        }
        object = (String)object + bigInteger + "/" + bigInteger2;
        return ((String)object).trim();
    }

    @Override
    public String getFromToFactorString() {
        return this.fromToWholeNumber + " " + this.fromToTopFactor + "/" + this.fromToBottomFactor;
    }
}

