/*
 * Decompiled with CFR 0.152.
 */
package tig.xml;

import java.io.File;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXParseException;
import tig.GeneralConstants;
import tig.Strings;

public class DomDoc
implements GeneralConstants {
    private Document _doc;
    private String _curPath;
    private int _regExMode;
    private static final String SLASH = "/";
    private static final String WILDCARD = "*";
    private static final String POINT_WILDCARD = ".*";
    public static final int REGEX_NORMAL = 0;
    public static final int REGEX_WILDCARD_ONLY = 1;

    public DomDoc(Document doc) {
        this._doc = doc;
        this._curPath = "";
        this._regExMode = 1;
    }

    public void setCurrentPath(String path) {
        this._curPath = path;
    }

    public String getCurrentPath() {
        return this._curPath;
    }

    public void setDocument(Document doc) {
        this._doc = doc;
        this._curPath = "";
    }

    public Document getDocument() {
        return this._doc;
    }

    public void setRegExMode(int regExMode) {
        this._regExMode = regExMode;
    }

    public String getAttributeValue(String tagName, String attributeName) {
        if (tagName == null || attributeName == null) {
            return null;
        }
        NodeList nodeList = this._doc.getElementsByTagName(tagName);
        int len = nodeList.getLength();
        if (len == 0) {
            return null;
        }
        int curIndex = 0;
        while (!DomDoc.belongsToPath(nodeList.item(curIndex), this._curPath)) {
            ++curIndex;
        }
        Node node = nodeList.item(curIndex);
        NamedNodeMap nnm = node.getAttributes();
        if (nnm == null) {
            return null;
        }
        for (int i = 0; i < nnm.getLength(); ++i) {
            node = nnm.item(i);
            if (!node.getNodeName().equals(attributeName)) continue;
            return node.getNodeValue();
        }
        return null;
    }

    public String[][] getAttributesValues(String tagName, String[] attributeNames) throws Exception {
        if (tagName == null || attributeNames == null || attributeNames.length == 0) {
            return null;
        }
        Vector<String[]> res = new Vector<String[]>();
        NodeList nodeList = this._doc.getElementsByTagName(tagName);
        int nlSize = nodeList.getLength();
        if (nlSize == 0) {
            return null;
        }
        int nbAttrs = attributeNames.length;
        for (int i = 0; i < nlSize; ++i) {
            Node node = nodeList.item(i);
            if (!DomDoc.belongsToPath(nodeList.item(i), this._curPath)) continue;
            String[] attrs = new String[nbAttrs];
            NamedNodeMap nnm = node.getAttributes();
            for (int j = 0; j < nnm.getLength(); ++j) {
                node = nnm.item(j);
                for (int k = 0; k < attributeNames.length; ++k) {
                    if (!node.getNodeName().equals(attributeNames[k])) continue;
                    attrs[k] = node.getNodeValue();
                }
            }
            res.add(attrs);
        }
        int nbTags = res.size();
        if (nbTags == 0) {
            return null;
        }
        String[][] res2 = new String[nbTags][nbAttrs];
        for (int i = 0; i < nbTags; ++i) {
            res2[i] = (String[])res.get(i);
        }
        return res2;
    }

    public String[][] getAttributesValues(String tagName, String attributeNames) {
        if (tagName == null || attributeNames == null) {
            return null;
        }
        if (this._regExMode == 1) {
            attributeNames = Strings.replace(attributeNames, WILDCARD, POINT_WILDCARD);
        }
        Vector res = new Vector();
        Pattern pattern = Pattern.compile(attributeNames);
        NodeList nodeList = this._doc.getElementsByTagName(tagName);
        int nlSize = nodeList.getLength();
        if (nlSize == 0) {
            return null;
        }
        for (int i = 0; i < nlSize; ++i) {
            Node node = nodeList.item(i);
            if (!DomDoc.belongsToPath(nodeList.item(i), this._curPath)) continue;
            Vector<String> attrs = new Vector<String>();
            NamedNodeMap nnm = node.getAttributes();
            for (int j = 0; j < nnm.getLength(); ++j) {
                node = nnm.item(j);
                Matcher matcher = pattern.matcher(node.getNodeName());
                if (!matcher.matches()) continue;
                attrs.add(node.getNodeValue());
            }
            res.add(attrs);
        }
        int nbTags = res.size();
        if (nbTags == 0) {
            return null;
        }
        String[][] res2 = new String[nbTags][];
        for (int i = 0; i < nbTags; ++i) {
            Vector curV = (Vector)res.get(i);
            int len = curV.size();
            res2[i] = new String[len];
            for (int j = 0; j < len; ++j) {
                res2[i][j] = (String)curV.get(j);
            }
        }
        return res2;
    }

    private static void sendError(String str) throws Exception {
        throw new Exception(str);
    }

    public static String getPath(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("getPath can't be called with a null node");
        }
        StringBuffer path = new StringBuffer();
        Vector<String> parentNames = new Vector<String>();
        Node curNode = node.getParentNode();
        if (curNode == null) {
            return "";
        }
        while (curNode.getParentNode() != null) {
            parentNames.add(curNode.getNodeName());
            curNode = curNode.getParentNode();
        }
        int n = parentNames.size();
        for (int i = 0; i < n; ++i) {
            path.append((String)parentNames.elementAt(n - 1 - i));
            if (i >= n - 1) continue;
            path.append(SLASH);
        }
        return path.toString();
    }

    public static boolean belongsToPath(Node node, String path) {
        int pathLen;
        if (node == null) {
            throw new IllegalArgumentException("belongsToPath can't be called with a null node");
        }
        if (path == null) {
            throw new IllegalArgumentException("belongsToPath can't be called with a null path");
        }
        if (path.equals("")) {
            return true;
        }
        String[] aPath = Strings.stringToStringArray(path, '/');
        String[] aNodePath = Strings.stringToStringArray(DomDoc.getPath(node), '/');
        int nodePathLen = aNodePath.length;
        if (nodePathLen < (pathLen = aPath.length)) {
            return false;
        }
        boolean res = true;
        for (int i = 0; i < pathLen; ++i) {
            if (aPath[i].equals(aNodePath[i])) continue;
            res = false;
        }
        return res;
    }

    public static void main(String[] args) {
        if (args[0].equalsIgnoreCase("testGetAttributeValue")) {
            DomDoc.testGetAttributeValue(args[1], args[2], args[3]);
        } else if (args[0].equalsIgnoreCase("testGetAttributesValues")) {
            DomDoc.testGetAttributesValues(args[1], args[2], args[3]);
        } else if (args[0].equalsIgnoreCase("testGetAttributesValues2")) {
            DomDoc.testGetAttributesValues2(args[1], args[2], args[3]);
        } else {
            String possibleArgs = "'testGetAttributeValue' or 'testGetAttributesValues' or 'testGetAttributesValues2'";
            System.out.println("first argument must be " + possibleArgs);
        }
    }

    private static void testGetAttributeValue(String xmlFile, String tagName, String attrName) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new File(xmlFile));
            DomDoc domDoc = new DomDoc(doc);
            System.out.println(domDoc.getAttributeValue(tagName, attrName));
        }
        catch (SAXParseException spe) {
            System.out.println("Parse error occured - line " + spe.getLineNumber() + " col " + spe.getColumnNumber() + " :");
            spe.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void testGetAttributesValues(String xmlFile, String tagName, String attrNames) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new File(xmlFile));
            DomDoc domDoc = new DomDoc(doc);
            String[] attrNames2 = Strings.stringToStringArray(attrNames);
            String[][] res = domDoc.getAttributesValues(tagName, attrNames2);
            for (int i = 0; i < res.length; ++i) {
                for (int j = 0; j < res[i].length; ++j) {
                    if (res[i][j] != null) {
                        System.out.println("res[" + i + "][" + j + "] = " + res[i][j]);
                        continue;
                    }
                    System.out.println("res[" + i + "][" + j + "] = null");
                }
            }
        }
        catch (SAXParseException spe) {
            System.out.println("Parse error occured - line " + spe.getLineNumber() + " col " + spe.getColumnNumber() + " :");
            spe.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void testGetAttributesValues2(String xmlFile, String tagName, String attrNames) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new File(xmlFile));
            DomDoc domDoc = new DomDoc(doc);
            String[][] res = domDoc.getAttributesValues(tagName, attrNames);
            for (int i = 0; i < res.length; ++i) {
                for (int j = 0; j < res[i].length; ++j) {
                    if (res[i][j] != null) {
                        System.out.println("res[" + i + "][" + j + "] = " + res[i][j]);
                        continue;
                    }
                    System.out.println("res[" + i + "][" + j + "] = null");
                }
            }
        }
        catch (SAXParseException spe) {
            System.out.println("Parse error occured - line " + spe.getLineNumber() + " col " + spe.getColumnNumber() + " :");
            spe.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

