/*
 * Decompiled with CFR 0.152.
 */
package tig.maths;

import tig.maths.Matrix2;

public class Vector2 {
    public double x0;
    public double x1;

    public Vector2(double a0, double a1) {
        this.x0 = a0;
        this.x1 = a1;
    }

    public Vector2(double[] coords) {
        if (coords.length != 2) {
            throw new IllegalArgumentException("Array passed to Vector2 constructor must have 2 elements");
        }
        this.x0 = coords[0];
        this.x1 = coords[1];
    }

    public String toString() {
        return "(" + this.x0 + ", " + this.x1 + ")";
    }

    public static double norm(Vector2 v) {
        return Math.sqrt(v.x0 * v.x0 + v.x1 * v.x1);
    }

    public static Vector2 mul(Matrix2 M, Vector2 a) {
        return new Vector2(M.m00 * a.x0 + M.m01 * a.x1, M.m10 * a.x0 + M.m11 * a.x1);
    }

    public static Vector2 mul(double k, Vector2 a) {
        return new Vector2(k * a.x0, k * a.x1);
    }

    public static Vector2 sub(Vector2 a, Vector2 b) {
        return new Vector2(a.x0 - b.x0, a.x1 - b.x1);
    }

    public static Vector2 add(Vector2 a, Vector2 b) {
        return new Vector2(a.x0 + b.x0, a.x1 + b.x1);
    }

    public static Vector2 negate(Vector2 a) {
        return new Vector2(-a.x0, -a.x1);
    }
}

