/*
 * Decompiled with CFR 0.152.
 */
package tig;

import java.util.GregorianCalendar;
import tig.DateFormatException;
import tig.Formats;
import tig.GeneralConstants;
import tig.HourFormatException;

public abstract class Dates
implements GeneralConstants {
    private static final String EN = "en";
    private static final String FR = "fr";
    private static final String ERROR_LANG = "Parameter 'lang' must be \"en\" or \"fr\"";

    public static double dateToJd(int[] date) {
        if (date.length != 6) {
            throw new IllegalArgumentException("Parameter 'date' must have 6 elements");
        }
        return Dates.dateToJd(date[0], date[1], date[2], date[3], date[4], date[5]);
    }

    public static double dateToJd(int year, int month, int day, int hour, int minut, int sec) {
        double m1;
        double y1;
        double decDay = (double)day + (double)hour / 24.0 + (double)minut / 1440.0 + (double)sec / 86400.0;
        if (month > 2) {
            y1 = year;
            m1 = month;
        } else {
            y1 = year - 1;
            m1 = month + 12;
        }
        double jd = year > 0 ? Math.floor(365.25 * y1) + Math.floor(30.6001 * (m1 + 1.0)) + decDay + 1720994.5 : Math.floor(365.25 * y1 - 0.75) + Math.floor(30.6001 * (m1 + 1.0)) + decDay + 1720994.5;
        if ((double)year + (double)month / 100.0 + decDay / 10000.0 >= 1582.1015) {
            double a = Math.floor(y1 / 100.0);
            double b = 2.0 - a + Math.floor(a / 4.0);
            jd += b;
        }
        return jd;
    }

    public static int[] jdToDate(double jd) {
        double a;
        int[] res = new int[6];
        double DAYS_PER_YEAR = 365.25;
        if (jd < 0.0) {
            throw new IllegalArgumentException("jdToDate() not valid for negative julian days");
        }
        double z = Math.floor(jd);
        double f = jd - z;
        if (z < 2299161.0) {
            a = z;
        } else {
            double alpha = Math.floor((z - 1867216.25) / 36524.25);
            a = z + 1.0 + alpha - Math.floor(alpha / 4.0);
        }
        double b = a + 1524.0;
        double c = Math.floor((b - 122.1) / DAYS_PER_YEAR);
        double d = Math.floor(DAYS_PER_YEAR * c);
        double e = Math.floor((b - d) / 30.6001);
        res[1] = e < 14.0 ? (int)(e - 1.0) : (int)(e - 13.0);
        res[0] = res[1] > 2 ? (int)(c - 4716.0) : (int)(c - 4715.0);
        res[2] = (int)(b - d - Math.floor(30.6001 * e));
        double hours = (f + 0.5) % 1.0 * 24.0;
        res[3] = (int)Math.floor(hours);
        double minuts = (hours - Math.floor(hours)) * 60.0;
        res[4] = (int)Math.floor(minuts);
        double secs = (minuts - Math.floor(minuts)) * 60.0;
        res[5] = (int)Math.round(secs);
        return res;
    }

    public static boolean isLeapYear(int y) {
        if (y < 0) {
            return false;
        }
        return y % 4 == 0 && y % 100 != 0 || y % 400 == 0;
    }

    public static int[] now() {
        int[] date = new int[6];
        GregorianCalendar c = new GregorianCalendar();
        date[0] = c.get(1);
        date[1] = c.get(2);
        date[2] = c.get(5);
        date[3] = c.get(11);
        date[4] = c.get(12);
        date[5] = c.get(13);
        return date;
    }

    public static String formatHourDate(int[] hourDate, String lang) {
        if (hourDate.length != 6) {
            throw new IllegalArgumentException("Parameter 'hourDate' must contain 6 integers");
        }
        if (!lang.equals(EN) && !lang.equals(FR)) {
            throw new IllegalArgumentException(ERROR_LANG);
        }
        String strDate = Dates.formatDate(new int[]{hourDate[0], hourDate[1], hourDate[2]}, lang);
        String strHour = Dates.formatHour(new int[]{hourDate[3], hourDate[4], hourDate[5]}, lang);
        return strDate + " " + strHour;
    }

    public static String formatDate(int[] date, String lang) {
        if (date.length != 3) {
            throw new IllegalArgumentException("Parameter 'date' must contain 3 integers");
        }
        if (!lang.equals(EN) && !lang.equals(FR)) {
            throw new IllegalArgumentException(ERROR_LANG);
        }
        String[] strDate = new String[3];
        strDate[0] = String.valueOf(date[0]);
        for (int i = 1; i < 3; ++i) {
            strDate[i] = Formats.addZero(date[i]);
        }
        if (lang.equals(EN)) {
            return strDate[1] + "/" + strDate[2] + "/" + strDate[0];
        }
        return strDate[2] + "/" + strDate[1] + "/" + strDate[0];
    }

    public static String formatHour(int[] hour, String lang) {
        if (hour.length != 3) {
            throw new IllegalArgumentException("Parameter 'hour' must contain 3 integers");
        }
        if (!lang.equals(EN) && !lang.equals(FR)) {
            throw new IllegalArgumentException(ERROR_LANG);
        }
        String[] strHour = new String[3];
        for (int i = 0; i < 3; ++i) {
            strHour[i] = Formats.addZero(hour[i]);
        }
        return strHour[0] + ":" + strHour[1] + ":" + strHour[2];
    }

    public static String formatHourDate(String strDate, String strHour, String lang) throws DateFormatException, HourFormatException {
        try {
            int[] hourDate = Dates.parseHourDate(strDate, strHour, lang);
            return Dates.formatHourDate(hourDate, lang);
        }
        catch (HourFormatException e) {
            throw e;
        }
        catch (DateFormatException e) {
            throw e;
        }
    }

    public static String formatDate(String strDate, String lang) throws DateFormatException {
        int[] date = Dates.parseDate(strDate, lang);
        return Dates.formatDate(date, lang);
    }

    public static String formatHour(String strHour, String lang) throws HourFormatException {
        int[] hour = Dates.parseHour(strHour, lang);
        return Dates.formatHour(hour, lang);
    }

    public static int[] parseHourDate(String strDate, String strHour, String lang) throws DateFormatException, HourFormatException, IllegalArgumentException {
        if (!lang.equals(EN) && !lang.equals(FR)) {
            throw new IllegalArgumentException("Parameter 'lang' must be 'en' or 'fr'");
        }
        try {
            int[] date = Dates.parseDate(strDate, lang);
            int[] hour = Dates.parseHour(strHour, lang);
            return new int[]{date[0], date[1], date[2], hour[0], hour[1], hour[2]};
        }
        catch (DateFormatException e) {
            throw e;
        }
        catch (HourFormatException e) {
            throw e;
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
    }

    public static int[] parseDate(String strDate, String lang) throws DateFormatException, IllegalArgumentException {
        int i;
        if (!lang.equals(EN) && !lang.equals(FR)) {
            throw new IllegalArgumentException("Parameter 'lang' must be 'en' or 'fr'");
        }
        int[] results = new int[3];
        String str1 = "";
        String str2 = "";
        String str3 = "";
        String yearSep = "";
        strDate = strDate.trim();
        int len = strDate.length();
        for (i = 0; i < len && Character.isDigit(strDate.charAt(i)); ++i) {
            str1 = str1 + String.valueOf(strDate.charAt(i));
        }
        while (i < len && !Character.isDigit(strDate.charAt(i))) {
            ++i;
        }
        while (i < len && Character.isDigit(strDate.charAt(i))) {
            str2 = str2 + String.valueOf(strDate.charAt(i));
            ++i;
        }
        while (i < len && !Character.isDigit(strDate.charAt(i))) {
            yearSep = yearSep + String.valueOf(strDate.charAt(i));
            ++i;
        }
        while (i < len && Character.isDigit(strDate.charAt(i))) {
            str3 = str3 + String.valueOf(strDate.charAt(i));
            ++i;
        }
        if (i != len || str1 == "" || str2 == "" || str3 == "") {
            throw new DateFormatException();
        }
        if (lang.equals(FR)) {
            results[2] = Integer.valueOf(str1);
            results[1] = Integer.valueOf(str2);
        } else if (lang.equals(EN)) {
            results[1] = Integer.valueOf(str1);
            results[2] = Integer.valueOf(str2);
        }
        results[0] = Integer.valueOf(str3);
        if (yearSep.length() > 1 && yearSep.charAt(yearSep.length() - 1) == '-') {
            results[0] = -results[0];
        }
        Dates.checkDate(results[0], results[1], results[2]);
        return results;
    }

    public static int[] parseHour(String strHour, String lang) throws HourFormatException, IllegalArgumentException {
        int i;
        if (!lang.equals(EN) && !lang.equals(FR)) {
            throw new IllegalArgumentException("Parameter 'lang' must be 'en' or 'fr'");
        }
        int[] results = new int[3];
        strHour = strHour.trim();
        int len = strHour.length();
        if (len == 0) {
            results[0] = 0;
            results[1] = 0;
            results[2] = 0;
            return results;
        }
        String str3 = "";
        String str2 = "";
        String str1 = "";
        for (i = 0; i < len && !Character.isDigit(strHour.charAt(i)); ++i) {
        }
        while (i < len && Character.isDigit(strHour.charAt(i))) {
            str1 = str1 + String.valueOf(strHour.charAt(i));
            ++i;
        }
        while (i < len && !Character.isDigit(strHour.charAt(i))) {
            ++i;
        }
        while (i < len && Character.isDigit(strHour.charAt(i))) {
            str2 = str2 + String.valueOf(strHour.charAt(i));
            ++i;
        }
        while (i < len && !Character.isDigit(strHour.charAt(i))) {
            ++i;
        }
        while (i < len && Character.isDigit(strHour.charAt(i))) {
            str3 = str3 + String.valueOf(strHour.charAt(i));
            ++i;
        }
        if (str1.equals("")) {
            results[0] = 0;
            results[1] = 0;
            results[2] = 0;
            return results;
        }
        results[0] = Integer.valueOf(str1);
        if (str2.equals("")) {
            results[1] = 0;
            results[2] = 0;
        } else {
            results[1] = Integer.valueOf(str2);
            results[2] = str3.equals("") ? 0 : Integer.valueOf(str3);
        }
        Dates.checkHour(results[0], results[1], results[2]);
        return results;
    }

    public static double calcDecDay(int d, int h, int m, int s) {
        return (double)d + (double)h / 24.0 + (double)m / 1440.0 + (double)s / 86400.0;
    }

    private static void checkHour(int h, int m, int s) throws HourFormatException {
        if (h < 0 || h > 23) {
            throw new HourFormatException("Hours must be between 0 and 23");
        }
        if (m < 0 || m > 59) {
            throw new HourFormatException("Minutes must be between 0 and 59");
        }
        if (s < 0 || s > 59) {
            throw new HourFormatException("Seconds must be between 0 and 59");
        }
    }

    private static void checkDate(int y, int m, int d) throws DateFormatException {
        int[] dpm = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        if (m < 1 || m > 12) {
            throw new DateFormatException("Months must be between 1 and 12");
        }
        if (m == 2) {
            if (Dates.isLeapYear(y)) {
                if (d > 29) {
                    throw new DateFormatException("Days < 29 in february of a leap year");
                }
            } else if (d > 28) {
                throw new DateFormatException("Days < 28 in february of a normal year");
            }
        } else if (d > dpm[m - 1]) {
            throw new DateFormatException("Days of this can't be greater than " + dpm[m - 1]);
        }
    }
}

