/*
 * Decompiled with CFR 0.152.
 */
package sgtplot.util;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import sgtplot.dm.SGTData;
import sgtplot.dm.SGTGrid;
import sgtplot.dm.SGTLine;
import sgtplot.dm.SGTMetaData;
import sgtplot.dm.SimpleGrid;
import sgtplot.dm.SimpleLine;

class Temperature
implements Serializable {
    private static final String[] name = new String[]{"C", "degC", "K", "degK", "F", "degF", "k", "deg_c", "deg_k"};
    private static final double[] scale = new double[]{1.0, 1.0, 1.0, 1.0, 0.5555555555555556, 0.5555555555555556, 1.0, 1.0, 1.0};
    private static final double[] offset = new double[]{0.0, 0.0, -273.15, -273.15, 17.77777777777778, 17.77777777777778, -273.15, 0.0, -273.15};
    private static final String timeArrayName = "[Lgov.noaa.pmel.util.GeoDate";
    private static final String doubleArrayName = "[D";
    private static final String stringName = "java.lang.String";

    Temperature() {
    }

    static SGTData convertToBaseUnit(SGTData grid, int comp) {
        double[] values;
        int unit;
        SGTMetaData meta;
        SGTData new_grid = null;
        switch (comp) {
            default: {
                meta = ((SGTLine)grid).getXMetaData();
                break;
            }
            case 1: {
                meta = ((SGTLine)grid).getYMetaData();
                break;
            }
            case 2: {
                meta = ((SGTGrid)grid).getZMetaData();
            }
        }
        String units = meta.getUnits();
        for (unit = 0; unit < name.length && !units.equals(name[unit]); ++unit) {
        }
        if (unit >= name.length) {
            return grid;
        }
        if (scale[unit] == 1.0 && offset[unit] == 0.0) {
            return grid;
        }
        switch (comp) {
            default: {
                values = ((SGTLine)grid).getXArray();
                break;
            }
            case 1: {
                values = ((SGTLine)grid).getYArray();
                break;
            }
            case 2: {
                values = ((SGTGrid)grid).getZArray();
            }
        }
        double[] new_values = new double[values.length];
        for (int count = 0; count < values.length; ++count) {
            new_values[count] = scale[unit] * values[count] + offset[unit];
        }
        SGTMetaData newMeta = new SGTMetaData(meta.getName(), "degC", meta.isReversed(), meta.isModulo());
        newMeta.setModuloValue(meta.getModuloValue());
        newMeta.setModuloTime(meta.getModuloTime());
        if (grid instanceof SGTLine) {
            boolean simpleLine = grid instanceof SimpleLine;
            if (simpleLine) {
                new_grid = (SGTLine)grid.copy();
            }
            Class[] classArgs = new Class[3];
            Object[] constructArgs = new Object[3];
            Class<?> gridClass = grid.getClass();
            switch (comp) {
                default: {
                    if (simpleLine) {
                        ((SimpleLine)new_grid).setXArray(new_values);
                    } else {
                        if (((SGTLine)grid).isYTime()) {
                            try {
                                classArgs[0] = Class.forName(doubleArrayName);
                                classArgs[1] = Class.forName(timeArrayName);
                                classArgs[2] = Class.forName(stringName);
                                Constructor<?> gridConstruct = gridClass.getConstructor(classArgs);
                                constructArgs[0] = new_values;
                                constructArgs[1] = ((SGTLine)grid).getTimeArray();
                                constructArgs[2] = ((SGTLine)grid).getTitle();
                                new_grid = (SGTData)gridConstruct.newInstance(constructArgs);
                            }
                            catch (Exception e) {
                                System.out.println("Temperature conversion: " + e);
                            }
                        } else {
                            try {
                                classArgs[0] = Class.forName(doubleArrayName);
                                classArgs[1] = Class.forName(doubleArrayName);
                                classArgs[2] = Class.forName(stringName);
                                Constructor<?> gridConstruct = gridClass.getConstructor(classArgs);
                                constructArgs[0] = new_values;
                                constructArgs[1] = ((SGTLine)grid).getYArray();
                                constructArgs[2] = ((SGTLine)grid).getTitle();
                                new_grid = (SGTData)gridConstruct.newInstance(constructArgs);
                            }
                            catch (Exception e) {
                                System.out.println("Temperature conversion: " + e);
                            }
                        }
                        ((SimpleLine)new_grid).setYMetaData(((SGTLine)grid).getYMetaData());
                    }
                    ((SimpleLine)new_grid).setXMetaData(newMeta);
                    break;
                }
                case 1: {
                    if (simpleLine) {
                        ((SimpleLine)new_grid).setYArray(new_values);
                    } else {
                        if (((SGTLine)grid).isXTime()) {
                            try {
                                classArgs[0] = Class.forName(timeArrayName);
                                classArgs[1] = Class.forName(doubleArrayName);
                                classArgs[2] = Class.forName(stringName);
                                Constructor<?> gridConstruct = gridClass.getConstructor(classArgs);
                                constructArgs[0] = ((SGTLine)grid).getTimeArray();
                                constructArgs[1] = new_values;
                                constructArgs[2] = ((SGTLine)grid).getTitle();
                                new_grid = (SGTData)gridConstruct.newInstance(constructArgs);
                            }
                            catch (Exception e) {
                                System.out.println("Temperature conversion: " + e);
                            }
                        } else {
                            try {
                                classArgs[0] = Class.forName(doubleArrayName);
                                classArgs[1] = Class.forName(doubleArrayName);
                                classArgs[2] = Class.forName(stringName);
                                Constructor<?> gridConstruct = gridClass.getConstructor(classArgs);
                                constructArgs[0] = ((SGTLine)grid).getXArray();
                                constructArgs[1] = new_values;
                                constructArgs[2] = ((SGTLine)grid).getTitle();
                                new_grid = (SGTData)gridConstruct.newInstance(constructArgs);
                            }
                            catch (Exception e) {
                                System.out.println("Temperature conversion: " + e);
                            }
                        }
                        ((SimpleLine)new_grid).setXMetaData(((SGTLine)grid).getXMetaData());
                    }
                    ((SimpleLine)new_grid).setYMetaData(newMeta);
                    break;
                }
            }
        } else if (grid instanceof SGTGrid) {
            boolean simpleGrid = grid instanceof SimpleGrid;
            if (simpleGrid) {
                new_grid = (SGTGrid)grid.copy();
            }
            Class[] classArgs = new Class[4];
            Object[] constructArgs = new Object[4];
            Class<?> gridClass = grid.getClass();
            switch (comp) {
                default: {
                    if (simpleGrid) {
                        ((SimpleGrid)new_grid).setXArray(new_values);
                    } else {
                        if (((SGTGrid)grid).isYTime()) {
                            try {
                                classArgs[0] = Class.forName(doubleArrayName);
                                classArgs[1] = Class.forName(doubleArrayName);
                                classArgs[2] = Class.forName(timeArrayName);
                                classArgs[3] = Class.forName(stringName);
                                Constructor<?> gridConstruct = gridClass.getConstructor(classArgs);
                                constructArgs[0] = ((SGTGrid)grid).getZArray();
                                constructArgs[1] = new_values;
                                constructArgs[2] = ((SGTGrid)grid).getTimeArray();
                                constructArgs[2] = ((SGTGrid)grid).getTitle();
                                new_grid = (SGTData)gridConstruct.newInstance(constructArgs);
                            }
                            catch (Exception e) {
                                System.out.println("Temperature conversion: " + e);
                            }
                        } else {
                            try {
                                classArgs[0] = Class.forName(doubleArrayName);
                                classArgs[1] = Class.forName(doubleArrayName);
                                classArgs[2] = Class.forName(doubleArrayName);
                                classArgs[3] = Class.forName(stringName);
                                Constructor<?> gridConstruct = gridClass.getConstructor(classArgs);
                                constructArgs[0] = ((SGTGrid)grid).getZArray();
                                constructArgs[1] = new_values;
                                constructArgs[2] = ((SGTGrid)grid).getYArray();
                                constructArgs[2] = ((SGTGrid)grid).getTitle();
                                new_grid = (SGTData)gridConstruct.newInstance(constructArgs);
                            }
                            catch (Exception e) {
                                System.out.println("Temperature conversion: " + e);
                            }
                        }
                        ((SimpleGrid)new_grid).setYMetaData(((SGTGrid)grid).getYMetaData());
                        ((SimpleGrid)new_grid).setZMetaData(((SGTGrid)grid).getZMetaData());
                    }
                    ((SimpleGrid)new_grid).setXMetaData(newMeta);
                    break;
                }
                case 1: {
                    if (simpleGrid) {
                        ((SimpleGrid)new_grid).setYArray(new_values);
                    } else {
                        if (((SGTGrid)grid).isXTime()) {
                            try {
                                classArgs[0] = Class.forName(doubleArrayName);
                                classArgs[1] = Class.forName(timeArrayName);
                                classArgs[2] = Class.forName(doubleArrayName);
                                classArgs[3] = Class.forName(stringName);
                                Constructor<?> gridConstruct = gridClass.getConstructor(classArgs);
                                constructArgs[0] = ((SGTGrid)grid).getZArray();
                                constructArgs[1] = ((SGTGrid)grid).getTimeArray();
                                constructArgs[2] = new_values;
                                constructArgs[2] = ((SGTGrid)grid).getTitle();
                                new_grid = (SGTData)gridConstruct.newInstance(constructArgs);
                            }
                            catch (Exception e) {
                                System.out.println("Temperature conversion: " + e);
                            }
                        } else {
                            try {
                                classArgs[0] = Class.forName(doubleArrayName);
                                classArgs[1] = Class.forName(doubleArrayName);
                                classArgs[2] = Class.forName(doubleArrayName);
                                classArgs[3] = Class.forName(stringName);
                                Constructor<?> gridConstruct = gridClass.getConstructor(classArgs);
                                constructArgs[0] = ((SGTGrid)grid).getZArray();
                                constructArgs[1] = ((SGTGrid)grid).getXArray();
                                constructArgs[2] = new_values;
                                constructArgs[2] = ((SGTGrid)grid).getTitle();
                                new_grid = (SGTData)gridConstruct.newInstance(constructArgs);
                            }
                            catch (Exception e) {
                                System.out.println("Temperature conversion: " + e);
                            }
                        }
                        ((SimpleGrid)new_grid).setXMetaData(((SGTGrid)grid).getXMetaData());
                        ((SimpleGrid)new_grid).setZMetaData(((SGTGrid)grid).getZMetaData());
                    }
                    ((SimpleGrid)new_grid).setYMetaData(newMeta);
                    break;
                }
                case 2: {
                    if (simpleGrid) {
                        ((SimpleGrid)new_grid).setZArray(new_values);
                    } else {
                        if (((SGTGrid)grid).isXTime()) {
                            try {
                                classArgs[0] = Class.forName(doubleArrayName);
                                classArgs[1] = Class.forName(timeArrayName);
                                classArgs[2] = Class.forName(doubleArrayName);
                                classArgs[3] = Class.forName(stringName);
                                Constructor<?> gridConstruct = gridClass.getConstructor(classArgs);
                                constructArgs[0] = new_values;
                                constructArgs[1] = ((SGTGrid)grid).getTimeArray();
                                constructArgs[2] = ((SGTGrid)grid).getYArray();
                                constructArgs[2] = ((SGTGrid)grid).getTitle();
                                new_grid = (SGTData)gridConstruct.newInstance(constructArgs);
                            }
                            catch (Exception e) {
                                System.out.println("Temperature conversion: " + e);
                            }
                        } else if (((SGTGrid)grid).isYTime()) {
                            try {
                                classArgs[0] = Class.forName(doubleArrayName);
                                classArgs[1] = Class.forName(doubleArrayName);
                                classArgs[2] = Class.forName(timeArrayName);
                                classArgs[3] = Class.forName(stringName);
                                Constructor<?> gridConstruct = gridClass.getConstructor(classArgs);
                                constructArgs[0] = new_values;
                                constructArgs[1] = ((SGTGrid)grid).getXArray();
                                constructArgs[2] = ((SGTGrid)grid).getTimeArray();
                                constructArgs[2] = ((SGTGrid)grid).getTitle();
                                new_grid = (SGTData)gridConstruct.newInstance(constructArgs);
                            }
                            catch (Exception e) {
                                System.out.println("Temperature conversion: " + e);
                            }
                        } else {
                            try {
                                classArgs[0] = Class.forName(doubleArrayName);
                                classArgs[1] = Class.forName(doubleArrayName);
                                classArgs[2] = Class.forName(doubleArrayName);
                                classArgs[3] = Class.forName(stringName);
                                Constructor<?> gridConstruct = gridClass.getConstructor(classArgs);
                                constructArgs[0] = new_values;
                                constructArgs[1] = ((SGTGrid)grid).getXArray();
                                constructArgs[2] = ((SGTGrid)grid).getYArray();
                                constructArgs[2] = ((SGTGrid)grid).getTitle();
                                new_grid = (SGTData)gridConstruct.newInstance(constructArgs);
                            }
                            catch (Exception e) {
                                System.out.println("Temperature conversion: " + e);
                            }
                        }
                        ((SimpleGrid)new_grid).setXMetaData(((SGTGrid)grid).getXMetaData());
                        ((SimpleGrid)new_grid).setYMetaData(((SGTGrid)grid).getYMetaData());
                    }
                    ((SimpleGrid)new_grid).setZMetaData(newMeta);
                }
            }
        }
        return new_grid;
    }

    static boolean isBaseUnit(SGTMetaData meta) {
        String units = meta.getUnits();
        for (int count = 0; count < name.length; ++count) {
            if (!units.equals(name[count])) continue;
            return true;
        }
        return false;
    }
}

