/*
 * Decompiled with CFR 0.152.
 */
package sgtplot.util;

import java.io.Serializable;
import sgtplot.util.GeoDate;
import sgtplot.util.SoTValue;

public class SoTPoint
implements Serializable,
Cloneable {
    private SoTValue x_;
    private SoTValue y_;

    public SoTPoint() {
    }

    public SoTPoint(SoTValue x, SoTValue y) {
        this.x_ = x;
        this.y_ = y;
    }

    public SoTPoint(double x, double y) {
        this(new SoTValue.Double(x), new SoTValue.Double(y));
    }

    public SoTPoint(double x, GeoDate y) {
        this(new SoTValue.Double(x), new SoTValue.Time(y));
    }

    public SoTPoint(double x, long y) {
        this(new SoTValue.Double(x), new SoTValue.Time(y));
    }

    public SoTPoint(GeoDate x, double y) {
        this(new SoTValue.Time(x), new SoTValue.Double(y));
    }

    public SoTPoint(long x, double y) {
        this(new SoTValue.Time(x), new SoTValue.Double(y));
    }

    public SoTPoint(SoTPoint pt) {
        this(pt.getX(), pt.getY());
    }

    public SoTValue getX() {
        return this.x_;
    }

    public void setX(SoTValue x) {
        this.x_ = x;
    }

    public SoTValue getY() {
        return this.y_;
    }

    public void setY(SoTValue y) {
        this.y_ = y;
    }

    public boolean equals(SoTPoint stp) {
        return this.x_.equals(stp.getX()) && this.y_.equals(stp.getY());
    }

    public boolean isXTime() {
        return this.x_.isTime();
    }

    public boolean isYTime() {
        return this.y_.isTime();
    }

    public void add(SoTPoint point) {
        this.x_.add(point.getX());
        this.y_.add(point.getY());
    }

    public SoTPoint copy() {
        try {
            return (SoTPoint)this.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public String toString() {
        return new String("(" + this.x_ + ", " + this.y_ + ")");
    }
}

