/*
 * Decompiled with CFR 0.152.
 */
package sgtplot.swing.prop;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import sgtplot.Axis;
import sgtplot.JPane;
import sgtplot.TimeAxis;
import sgtplot.pmel.swing.ThreeDotsButton;
import sgtplot.swing.prop.ColorEntryPanel;
import sgtplot.swing.prop.FontDialog;
import sgtplot.swing.prop.GeoDateDialog;
import sgtplot.swing.prop.GridBagConstraints;
import sgtplot.util.GeoDate;
import sgtplot.util.IllegalTimeValue;
import sgtplot.util.Range2D;
import sgtplot.util.TimePoint;
import sgtplot.util.TimeRange;

public class TimeAxisDialog
extends JDialog {
    private JPane pane_;
    private TimeAxis ta_;
    private Font labelFont_;
    private GeoDate startDate_;
    private GeoDate endDate_;
    private String[] styleNames_ = new String[]{"plain", "bold", "italic", "bold-italic"};
    private String dateFormat_ = "yyyy-MM-dd HH:mm:ss";
    boolean fComponentsAdjusted = false;
    JPanel buttonPanel = new JPanel();
    JButton okButton = new JButton();
    JButton applyButton = new JButton();
    JButton cancelButton = new JButton();
    EtchedBorder etchedBorder1 = new EtchedBorder();
    JTabbedPane TabbedPane = new JTabbedPane();
    JPanel labelPanel = new JPanel();
    JLabel JLabel4 = new JLabel();
    JLabel JLabel5 = new JLabel();
    JLabel JLabel2 = new JLabel();
    JTextField majorFormatTextField = new JTextField();
    JTextField majorIntervalTextField = new JTextField();
    JLabel JLabel3 = new JLabel();
    JTextField minorFormatTextField = new JTextField();
    JTextField minorIntervalTextField = new JTextField();
    JLabel JLabel11 = new JLabel();
    ColorEntryPanel textColorPanel = new ColorEntryPanel();
    JLabel JLabel15 = new JLabel();
    JPanel fontPanel = new JPanel();
    JLabel fontLabel = new JLabel();
    ThreeDotsButton fontEditor = new ThreeDotsButton();
    JLabel JLabel16 = new JLabel();
    JTextField heightTextField = new JTextField();
    JLabel JLabel1 = new JLabel();
    JComboBox positionComboBox = new JComboBox();
    JPanel rangePanel = new JPanel();
    JPanel userPanel = new JPanel();
    JLabel JLabel8 = new JLabel();
    JTextField minUserTextField = new JTextField();
    ThreeDotsButton minDateEditor = new ThreeDotsButton();
    JLabel JLabel9 = new JLabel();
    JTextField maxUserTextField = new JTextField();
    ThreeDotsButton maxDateEditor = new ThreeDotsButton();
    JPanel physicalPanel = new JPanel();
    JLabel JLabel10 = new JLabel();
    JTextField minPhysicalTextField = new JTextField();
    JLabel JLabel17 = new JLabel();
    JTextField maxPhysicalTextField = new JTextField();
    JLabel originLabel = new JLabel();
    JTextField originTextField = new JTextField();
    JPanel ticsStylePanel = new JPanel();
    JPanel ticsPanel = new JPanel();
    JLabel JLabel18 = new JLabel();
    JTextField largeTicTextField = new JTextField();
    JLabel JLabel19 = new JLabel();
    JTextField smallTicTextField = new JTextField();
    JLabel JLabel20 = new JLabel();
    JTextField numSmallTicsTextField = new JTextField();
    JLabel JLabel21 = new JLabel();
    JComboBox ticPositionComboBox = new JComboBox();
    JPanel stylePanel = new JPanel();
    JLabel JLabel22 = new JLabel();
    JComboBox axisStyleComboBox = new JComboBox();
    JLabel JLabel7 = new JLabel();
    JCheckBox axislVisibleCheckBox = new JCheckBox();
    JLabel JLabel6 = new JLabel();
    JCheckBox axisSelectableCheckBox = new JCheckBox();
    JPanel attachPanel = new JPanel();
    JLabel JLabel23 = new JLabel();
    JCheckBox transformCheckBox = new JCheckBox();
    JLabel axisLabel = new JLabel();
    JCheckBox axisCheckBox = new JCheckBox();
    DefaultComboBoxModel horizCBModel = new DefaultComboBoxModel();
    DefaultComboBoxModel vertCBModel = new DefaultComboBoxModel();
    DefaultComboBoxModel positionCBModel = new DefaultComboBoxModel();
    TitledBorder userBorder = new TitledBorder("User Range");
    TitledBorder physicalBorder = new TitledBorder("Physical Range");
    TitledBorder ticsBorder = new TitledBorder("Tics");
    TitledBorder styleBorder = new TitledBorder("Axis Style");
    DefaultComboBoxModel ticPositionCBModel = new DefaultComboBoxModel();
    DefaultComboBoxModel styleCBModel = new DefaultComboBoxModel();
    private JLabel jLabel1 = new JLabel();
    private ColorEntryPanel lineColorPanel = new ColorEntryPanel();

    public TimeAxisDialog(Frame parent) {
        super(parent);
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        int i;
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        this.setSize(new Dimension(457, 354));
        this.setVisible(false);
        this.buttonPanel.setBorder(this.etchedBorder1);
        this.buttonPanel.setLayout(new FlowLayout(1, 5, 5));
        this.jLabel1.setText("Line Color:");
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.okButton.setText("OK");
        this.okButton.setActionCommand("OK");
        this.buttonPanel.add(this.okButton);
        this.applyButton.setText("Apply");
        this.applyButton.setActionCommand("Apply");
        this.buttonPanel.add(this.applyButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.setActionCommand("Cancel");
        this.buttonPanel.add(this.cancelButton);
        this.getContentPane().add((Component)this.TabbedPane, "Center");
        this.labelPanel.setLayout(new GridBagLayout());
        this.TabbedPane.add((Component)this.labelPanel, "labelPanel");
        this.labelPanel.setBounds(2, 27, 452, 275);
        this.labelPanel.setVisible(false);
        this.JLabel4.setText("format");
        this.labelPanel.add((Component)this.JLabel4, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.JLabel5.setText("interval");
        this.labelPanel.add((Component)this.JLabel5, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.JLabel2.setText("Minor:");
        this.labelPanel.add((Component)this.JLabel2, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.majorFormatTextField.setColumns(5);
        this.labelPanel.add((Component)this.majorFormatTextField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.majorIntervalTextField.setColumns(3);
        this.labelPanel.add((Component)this.majorIntervalTextField, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.JLabel3.setText("Major:");
        this.labelPanel.add((Component)this.JLabel3, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.labelPanel.add((Component)this.minorFormatTextField, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.minorIntervalTextField.setColumns(3);
        this.labelPanel.add((Component)this.minorIntervalTextField, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.JLabel11.setText("Color:");
        this.labelPanel.add((Component)this.JLabel11, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(15, 5, 0, 5), 0, 0));
        this.textColorPanel.setLayout(new FlowLayout(1, 5, 5));
        this.labelPanel.add((Component)this.textColorPanel, new GridBagConstraints(1, 3, 2, 1, 0.0, 0.0, 17, 0, new Insets(15, 5, 0, 5), 0, 0));
        this.JLabel15.setText("Font:");
        this.labelPanel.add((Component)this.JLabel15, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.fontPanel.setLayout(new FlowLayout(1, 5, 5));
        this.labelPanel.add((Component)this.fontPanel, new GridBagConstraints(1, 4, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.fontLabel.setText("Dialog, 12, Bold");
        this.fontPanel.add(this.fontLabel);
        this.fontLabel.setForeground(Color.black);
        this.fontEditor.setToolTipText("Edit font.");
        this.fontEditor.setActionCommand("...");
        this.fontPanel.add(this.fontEditor);
        this.JLabel16.setText("Height:");
        this.labelPanel.add((Component)this.JLabel16, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(15, 5, 0, 5), 0, 0));
        this.heightTextField.setColumns(10);
        this.labelPanel.add((Component)this.heightTextField, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(15, 5, 5, 5), 0, 0));
        this.JLabel1.setText("Position:");
        this.labelPanel.add((Component)this.JLabel1, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.positionComboBox.setModel(this.positionCBModel);
        this.labelPanel.add((Component)this.positionComboBox, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.rangePanel.setLayout(new GridBagLayout());
        this.TabbedPane.add((Component)this.rangePanel, "rangePanel");
        this.rangePanel.setBounds(2, 27, 452, 275);
        this.rangePanel.setVisible(false);
        this.userPanel.setBorder(this.userBorder);
        this.userPanel.setLayout(new GridBagLayout());
        this.rangePanel.add((Component)this.userPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 0), 20, 15));
        this.JLabel8.setText("Minimum:");
        this.userPanel.add((Component)this.JLabel8, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.minUserTextField.setColumns(25);
        this.userPanel.add((Component)this.minUserTextField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.minDateEditor.setToolTipText("Edit minimum date.");
        this.minDateEditor.setActionCommand("...");
        this.userPanel.add((Component)this.minDateEditor, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.JLabel9.setText("Maximum:");
        this.userPanel.add((Component)this.JLabel9, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.maxUserTextField.setColumns(25);
        this.userPanel.add((Component)this.maxUserTextField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.maxDateEditor.setToolTipText("Edit max date.");
        this.maxDateEditor.setActionCommand("...");
        this.userPanel.add((Component)this.maxDateEditor, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.physicalPanel.setBorder(this.physicalBorder);
        this.physicalPanel.setLayout(new GridBagLayout());
        this.rangePanel.add((Component)this.physicalPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 0), 20, 15));
        this.JLabel10.setText("Minimum:");
        this.physicalPanel.add((Component)this.JLabel10, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.minPhysicalTextField.setColumns(20);
        this.physicalPanel.add((Component)this.minPhysicalTextField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.JLabel17.setText("Maximum:");
        this.physicalPanel.add((Component)this.JLabel17, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.maxPhysicalTextField.setColumns(20);
        this.physicalPanel.add((Component)this.maxPhysicalTextField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.originLabel.setText("Y Origin:");
        this.physicalPanel.add((Component)this.originLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.originTextField.setColumns(20);
        this.physicalPanel.add((Component)this.originTextField, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.ticsStylePanel.setLayout(new GridBagLayout());
        this.TabbedPane.add((Component)this.ticsStylePanel, "ticsStylePanel");
        this.ticsStylePanel.setBounds(2, 27, 452, 275);
        this.ticsStylePanel.setVisible(false);
        this.ticsPanel.setBorder(this.ticsBorder);
        this.ticsPanel.setLayout(new GridBagLayout());
        this.ticsStylePanel.add((Component)this.ticsPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 10, 10));
        this.JLabel18.setText("Large Tic Height:");
        this.ticsPanel.add((Component)this.JLabel18, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.largeTicTextField.setColumns(15);
        this.ticsPanel.add((Component)this.largeTicTextField, new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.JLabel19.setText("Small Tic Height:");
        this.ticsPanel.add((Component)this.JLabel19, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.smallTicTextField.setColumns(15);
        this.ticsPanel.add((Component)this.smallTicTextField, new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.JLabel20.setText("Number of Small Tics:");
        this.ticsPanel.add((Component)this.JLabel20, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.numSmallTicsTextField.setColumns(5);
        this.ticsPanel.add((Component)this.numSmallTicsTextField, new GridBagConstraints(1, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.JLabel21.setText("Tic Position:");
        this.ticsPanel.add((Component)this.JLabel21, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.ticPositionComboBox.setModel(this.ticPositionCBModel);
        this.ticsPanel.add((Component)this.ticPositionComboBox, new GridBagConstraints(1, 3, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.ticsPanel.add((Component)this.jLabel1, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.ticsPanel.add((Component)this.lineColorPanel, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.stylePanel.setBorder(this.styleBorder);
        this.stylePanel.setLayout(new GridBagLayout());
        this.ticsStylePanel.add((Component)this.stylePanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 0), 10, 10));
        this.JLabel22.setHorizontalAlignment(4);
        this.JLabel22.setText("Time Axis Style:");
        this.stylePanel.add((Component)this.JLabel22, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 34, 0));
        this.axisStyleComboBox.setModel(this.styleCBModel);
        this.axisStyleComboBox.setEnabled(false);
        this.stylePanel.add((Component)this.axisStyleComboBox, new GridBagConstraints(1, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.JLabel7.setText("Visible:");
        this.stylePanel.add((Component)this.JLabel7, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.axislVisibleCheckBox.setSelected(true);
        this.stylePanel.add((Component)this.axislVisibleCheckBox, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.JLabel6.setText("Selectable:");
        this.stylePanel.add((Component)this.JLabel6, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.axisSelectableCheckBox.setSelected(true);
        this.stylePanel.add((Component)this.axisSelectableCheckBox, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.attachPanel.setLayout(new GridBagLayout());
        this.TabbedPane.add((Component)this.attachPanel, "attachPanel");
        this.attachPanel.setBounds(2, 27, 452, 275);
        this.attachPanel.setVisible(false);
        this.JLabel23.setText("Attach Transform to Axis:");
        this.attachPanel.add((Component)this.JLabel23, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.attachPanel.add((Component)this.transformCheckBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.axisLabel.setText("Attach X Axis to Axis:");
        this.attachPanel.add((Component)this.axisLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.attachPanel.add((Component)this.axisCheckBox, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.TabbedPane.setTitleAt(0, "Label");
        this.TabbedPane.setTitleAt(1, "Range");
        this.TabbedPane.setTitleAt(2, "Tics/Style");
        this.TabbedPane.setTitleAt(3, "Attach");
        String[] horizString = new String[]{"LEFT", "CENTER", "RIGHT"};
        for (i = 0; i < horizString.length; ++i) {
            this.horizCBModel.addElement(horizString[i]);
        }
        String[] tempString = new String[]{"TOP", "MIDDLE", "BOTTOM"};
        for (i = 0; i < tempString.length; ++i) {
            this.vertCBModel.addElement(tempString[i]);
        }
        tempString = new String[]{"POSITIVE_SIDE", "NEGATIVE_SIDE", "NO_LABEL"};
        for (i = 0; i < tempString.length; ++i) {
            this.positionCBModel.addElement(tempString[i]);
        }
        tempString = new String[]{"POSITIVE_SIDE", "NEGATIVE_SIDE", "BOTH_SIDES"};
        for (i = 0; i < tempString.length; ++i) {
            this.ticPositionCBModel.addElement(tempString[i]);
        }
        tempString = new String[]{"Auto", "Year/Decade", "Month/Year", "Day/Month", "Hour/Day", "Minute/Hour"};
        for (i = 0; i < tempString.length; ++i) {
            this.styleCBModel.addElement(tempString[i]);
        }
        this.setTitle("TimeAxis");
        SymWindow aSymWindow = new SymWindow();
        this.addWindowListener(aSymWindow);
        SymAction lSymAction = new SymAction();
        this.cancelButton.addActionListener(lSymAction);
        this.okButton.addActionListener(lSymAction);
        this.fontEditor.addActionListener(lSymAction);
        this.applyButton.addActionListener(lSymAction);
        this.minDateEditor.addActionListener(lSymAction);
        this.maxDateEditor.addActionListener(lSymAction);
        this.minUserTextField.addActionListener(lSymAction);
        this.maxUserTextField.addActionListener(lSymAction);
    }

    @Override
    public void addNotify() {
        Dimension d = this.getSize();
        super.addNotify();
        if (this.fComponentsAdjusted) {
            return;
        }
        Insets ins = this.getInsets();
        this.setSize(ins.left + ins.right + d.width, ins.top + ins.bottom + d.height);
        Component[] components = this.getContentPane().getComponents();
        for (int i = 0; i < components.length; ++i) {
            Point p = components[i].getLocation();
            p.translate(ins.left, ins.top);
            components[i].setLocation(p);
        }
        this.fComponentsAdjusted = true;
    }

    public TimeAxisDialog(String title) {
        this();
        this.setTitle(title);
    }

    public TimeAxisDialog() {
        this((Frame)null);
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.setLocation(50, 50);
        }
        super.setVisible(b);
    }

    void FontDialog_WindowClosing(WindowEvent event) {
        this.dispose();
    }

    void cancelButton_actionPerformed(ActionEvent event) {
        this.setVisible(false);
    }

    void okButton_actionPerformed(ActionEvent event) {
        this.updateTimeAxis();
        this.setVisible(false);
    }

    void applyButton_actionPerformed(ActionEvent event) {
        this.updateTimeAxis();
    }

    public static void main(String[] args) {
        TimeAxisDialog la = new TimeAxisDialog();
        la.setFont(null);
        la.setTitle("Test TimeAxis Dialog");
        la.setVisible(true);
    }

    public void setTimeAxis(TimeAxis ta, JPane pane) {
        this.setJPane(pane);
        this.setTimeAxis(ta);
    }

    public void setTimeAxis(TimeAxis ta) {
        this.ta_ = ta;
        this.setTimeAxis();
    }

    public TimeAxis getTimeAxis() {
        return this.ta_;
    }

    public void setJPane(JPane pane) {
        this.pane_ = pane;
    }

    public JPane getJPane() {
        return this.pane_;
    }

    private void setTimeAxis() {
        this.setTitle("TimeAxis - " + this.ta_.getId());
        this.majorFormatTextField.setText(this.ta_.getMajorLabelFormat());
        this.majorIntervalTextField.setText(Integer.toString(this.ta_.getMajorLabelInterval()));
        this.minorFormatTextField.setText(this.ta_.getMinorLabelFormat());
        this.minorIntervalTextField.setText(Integer.toString(this.ta_.getMinorLabelInterval()));
        Color col = this.ta_.getLabelColor();
        if (col == null) {
            col = this.pane_.getComponent().getForeground();
        }
        this.textColorPanel.setColor(col);
        this.labelFont_ = this.ta_.getLabelFont();
        if (this.labelFont_ == null) {
            this.labelFont_ = this.pane_.getComponent().getFont();
        }
        this.fontLabel.setText(this.fontString(this.labelFont_));
        this.heightTextField.setText(String.valueOf(this.ta_.getLabelHeightP()));
        this.positionComboBox.setSelectedIndex(this.ta_.getLabelPosition());
        TimeRange trange = this.ta_.getTimeRangeU();
        this.startDate_ = trange.start;
        this.endDate_ = trange.end;
        this.minUserTextField.setText(this.startDate_.toString());
        this.maxUserTextField.setText(this.endDate_.toString());
        Range2D range = this.ta_.getRangeP();
        this.minPhysicalTextField.setText(String.valueOf(range.start));
        this.maxPhysicalTextField.setText(String.valueOf(range.end));
        TimePoint pt = this.ta_.getLocationU();
        if (this.ta_.getOrientation() == 0) {
            this.originLabel.setText("Y Origin:");
            this.originTextField.setText(String.valueOf(pt.x));
        } else {
            this.originLabel.setText("X Origin:");
            this.originTextField.setText(String.valueOf(pt.x));
        }
        this.largeTicTextField.setText(String.valueOf(this.ta_.getLargeTicHeightP()));
        this.smallTicTextField.setText(String.valueOf(this.ta_.getSmallTicHeightP()));
        this.numSmallTicsTextField.setText(String.valueOf(this.ta_.getNumberSmallTics()));
        this.ticPositionComboBox.setSelectedIndex(this.ta_.getTicPosition());
        col = this.ta_.getLineColor();
        if (col == null) {
            col = this.pane_.getComponent().getForeground();
        }
        this.lineColorPanel.setColor(col);
        this.axisStyleComboBox.setSelectedIndex(this.ta_.getStyle());
        this.axislVisibleCheckBox.setSelected(this.ta_.isVisible());
        this.axisSelectableCheckBox.setSelected(this.ta_.isSelectable());
        boolean test = this.ta_.getNumberRegisteredTransforms() > 0;
        this.transformCheckBox.setSelected(test);
        if (this.ta_.getOrientation() == 0) {
            test = this.ta_.getGraph().getNumberXAxis() >= 2;
            this.axisLabel.setEnabled(test);
            this.axisCheckBox.setEnabled(test);
            this.axisLabel.setText("Attach X Axis to Axis:");
            test = this.ta_.getNumberRegisteredAxes() > 0;
            this.axisCheckBox.setSelected(test);
        } else {
            test = this.ta_.getGraph().getNumberYAxis() >= 2;
            this.axisLabel.setEnabled(test);
            this.axisCheckBox.setEnabled(test);
            this.axisLabel.setText("Attach Y Axis to Axis:");
            test = this.ta_.getNumberRegisteredAxes() > 0;
            this.axisCheckBox.setSelected(test);
        }
    }

    private void updateTimeAxis() {
        this.pane_.setBatch(true, "TimeAxisDialog");
        this.ta_.setMajorLabelFormat(this.majorFormatTextField.getText());
        this.ta_.setMajorLabelInterval(Integer.parseInt(this.majorIntervalTextField.getText()));
        this.ta_.setMinorLabelFormat(this.minorFormatTextField.getText());
        this.ta_.setMinorLabelInterval(Integer.parseInt(this.minorIntervalTextField.getText()));
        this.ta_.setLabelColor(this.textColorPanel.getColor());
        if (this.labelFont_ != null) {
            this.ta_.setLabelFont(this.labelFont_);
        }
        this.ta_.setLabelHeightP(Double.valueOf(this.heightTextField.getText()));
        this.ta_.setLabelPosition(this.positionComboBox.getSelectedIndex());
        this.ta_.setRangeU(new TimeRange(this.startDate_, this.endDate_));
        double min = Double.valueOf(this.minPhysicalTextField.getText());
        double max = Double.valueOf(this.maxPhysicalTextField.getText());
        this.ta_.setRangeP(new Range2D(min, max));
        TimePoint pt = this.ta_.getLocationU();
        pt.x = Double.valueOf(this.originTextField.getText());
        this.ta_.setLocationU(pt);
        this.ta_.setLargeTicHeightP(Double.valueOf(this.largeTicTextField.getText()));
        this.ta_.setSmallTicHeightP(Double.valueOf(this.smallTicTextField.getText()));
        this.ta_.setNumberSmallTics(Integer.parseInt(this.numSmallTicsTextField.getText()));
        this.ta_.setTicPosition(this.ticPositionComboBox.getSelectedIndex());
        this.ta_.setLineColor(this.lineColorPanel.getColor());
        this.ta_.setVisible(this.axislVisibleCheckBox.isSelected());
        this.ta_.setSelectable(this.axisSelectableCheckBox.isSelected());
        if (this.transformCheckBox.isSelected() && this.ta_.getNumberRegisteredTransforms() < 1) {
            if (this.ta_.getOrientation() == 0) {
                this.ta_.register(this.ta_.getGraph().getXTransform());
            } else {
                this.ta_.register(this.ta_.getGraph().getYTransform());
            }
        } else if (this.ta_.getNumberRegisteredTransforms() > 0) {
            this.ta_.clearAllRegisteredTransforms();
        }
        if (this.ta_.getOrientation() == 0) {
            boolean test;
            boolean bl = test = this.ta_.getGraph().getNumberXAxis() >= 2 && this.ta_.getNumberRegisteredAxes() < 1;
            if (this.axisCheckBox.isSelected() && test) {
                Enumeration it = this.ta_.getGraph().xAxisElements();
                while (it.hasMoreElements()) {
                    Axis ax = (Axis)it.nextElement();
                    if (ax.getId() == this.ta_.getId()) continue;
                    this.ta_.register(ax);
                }
            } else if (this.ta_.getNumberRegisteredAxes() > 0) {
                this.ta_.clearAllRegisteredAxes();
            }
        } else {
            boolean test;
            boolean bl = test = this.ta_.getGraph().getNumberYAxis() >= 2 && this.ta_.getNumberRegisteredAxes() < 1;
            if (this.axisCheckBox.isSelected() && test) {
                Enumeration it = this.ta_.getGraph().yAxisElements();
                while (it.hasMoreElements()) {
                    Axis ax = (Axis)it.nextElement();
                    if (ax.getId() == this.ta_.getId()) continue;
                    this.ta_.register(ax);
                }
            } else if (this.ta_.getNumberRegisteredAxes() > 0) {
                this.ta_.clearAllRegisteredAxes();
            }
        }
        this.pane_.setBatch(false, "TimeAxisDialog");
    }

    void fontEditor_actionPerformed(ActionEvent event) {
        FontDialog fd = new FontDialog();
        int result = fd.showDialog(this.labelFont_);
        if (result == FontDialog.OK_RESPONSE) {
            this.labelFont_ = fd.getFont();
            this.fontLabel.setText(this.fontString(this.labelFont_));
            this.fontLabel.setFont(this.labelFont_);
        }
    }

    String fontString(Font font) {
        int style = (font.isBold() ? 1 : 0) + (font.isItalic() ? 2 : 0);
        return font.getName() + " " + this.styleNames_[style];
    }

    void minDateEditor_actionPerformed(ActionEvent event) {
        GeoDateDialog gd = new GeoDateDialog();
        Point loc = this.minDateEditor.getLocationOnScreen();
        int result = gd.showDialog(this.startDate_, loc.x, loc.y);
        if (result == GeoDateDialog.OK_RESPONSE) {
            this.startDate_ = gd.getGeoDate();
            this.minUserTextField.setText(this.startDate_.toString());
        }
    }

    void maxDateEditor_actionPerformed(ActionEvent event) {
        GeoDateDialog gd = new GeoDateDialog();
        Point loc = this.maxDateEditor.getLocationOnScreen();
        int result = gd.showDialog(this.endDate_, loc.x, loc.y);
        if (result == GeoDateDialog.OK_RESPONSE) {
            this.endDate_ = gd.getGeoDate();
            this.maxUserTextField.setText(this.endDate_.toString());
        }
    }

    void minUserTextField_actionPerformed(ActionEvent event) {
        try {
            this.startDate_ = new GeoDate(this.minUserTextField.getText(), this.dateFormat_);
        }
        catch (IllegalTimeValue e) {
            this.minUserTextField.setText(this.startDate_.toString());
        }
    }

    void maxUserTextField_actionPerformed(ActionEvent event) {
        try {
            this.endDate_ = new GeoDate(this.maxUserTextField.getText(), this.dateFormat_);
        }
        catch (IllegalTimeValue e) {
            this.maxUserTextField.setText(this.endDate_.toString());
        }
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        @Override
        public void windowClosing(WindowEvent event) {
            Object object = event.getSource();
            if (object == TimeAxisDialog.this) {
                TimeAxisDialog.this.FontDialog_WindowClosing(event);
            }
        }
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == TimeAxisDialog.this.cancelButton) {
                TimeAxisDialog.this.cancelButton_actionPerformed(event);
            } else if (object == TimeAxisDialog.this.okButton) {
                TimeAxisDialog.this.okButton_actionPerformed(event);
            } else if (object == TimeAxisDialog.this.fontEditor) {
                TimeAxisDialog.this.fontEditor_actionPerformed(event);
            } else if (object == TimeAxisDialog.this.applyButton) {
                TimeAxisDialog.this.applyButton_actionPerformed(event);
            } else if (object == TimeAxisDialog.this.minDateEditor) {
                TimeAxisDialog.this.minDateEditor_actionPerformed(event);
            } else if (object == TimeAxisDialog.this.maxDateEditor) {
                TimeAxisDialog.this.maxDateEditor_actionPerformed(event);
            } else if (object == TimeAxisDialog.this.minUserTextField) {
                TimeAxisDialog.this.minUserTextField_actionPerformed(event);
            } else if (object == TimeAxisDialog.this.maxUserTextField) {
                TimeAxisDialog.this.maxUserTextField_actionPerformed(event);
            }
        }
    }
}

