/*
 * Decompiled with CFR 0.152.
 */
package sgtplot.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.ImageObserver;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.net.URL;
import javax.swing.ImageIcon;
import org.freehep.graphics2d.VectorGraphics;
import sgtplot.AbstractPane;
import sgtplot.CartesianGraph;
import sgtplot.Layer;
import sgtplot.LayerChild;
import sgtplot.swing.Draggable;
import sgtplot.util.Point2D;
import sgtplot.util.SoTPoint;

public class UserIcon
extends ImageIcon
implements LayerChild,
Draggable {
    private boolean selected_ = false;
    private boolean selectable_ = true;
    protected boolean moved_ = false;
    protected Layer layer_ = null;
    private String id_ = null;
    private boolean visible_ = true;
    protected Rectangle bounds_ = new Rectangle();
    protected Point2D.Double loc_ = new Point2D.Double();
    protected SoTPoint uLoc_ = new SoTPoint(0.0, 0.0);
    private Font font_ = new Font("Dialog", 0, 10);
    private Color textColor_ = Color.black;
    protected PropertyChangeSupport changes_ = new PropertyChangeSupport(this);
    protected VetoableChangeSupport vetos_ = new VetoableChangeSupport(this);

    public UserIcon(String filename, String description) {
        super(filename, description);
    }

    public UserIcon(URL location, String description) {
        super(location, description);
    }

    public UserIcon(Image image, String description) {
        super(image, description);
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        this.computeBounds(g);
        this.bounds_.x = x;
        this.bounds_.y = y;
        if (this.visible_) {
            VectorGraphics g2 = VectorGraphics.create((Graphics)g);
            g2.drawImage(this.getImage(), this.bounds_.x, this.bounds_.y, (ImageObserver)this.layer_.getPane().getComponent());
            int xl = this.bounds_.x + super.getIconWidth();
            int yl = this.bounds_.y + super.getIconHeight();
            g2.setFont(this.font_);
            g2.setColor(this.textColor_);
            g2.drawString(this.getDescription(), xl, yl);
        }
    }

    public void setFont(Font font) {
        this.font_ = font;
    }

    public Font getFont() {
        return this.font_;
    }

    @Override
    public int getIconWidth() {
        return this.bounds_.width;
    }

    @Override
    public int getIconHeight() {
        return this.bounds_.height;
    }

    private void computeBounds(Graphics g) {
        int wid = super.getIconWidth();
        int hgt = super.getIconHeight();
        g.setFont(this.font_);
        FontMetrics fmet = g.getFontMetrics();
        this.bounds_.width = wid + fmet.stringWidth(this.getDescription());
        this.bounds_.height = hgt;
    }

    @Override
    public LayerChild copy() {
        return null;
    }

    @Override
    public void setVisible(boolean vis) {
        if (this.visible_ != vis) {
            this.visible_ = vis;
        }
    }

    @Override
    public boolean isVisible() {
        return this.visible_;
    }

    @Override
    public void draw(VectorGraphics g) {
        int x = ((CartesianGraph)this.layer_.getGraph()).getXUtoD(this.uLoc_.getX());
        int y = ((CartesianGraph)this.layer_.getGraph()).getYUtoD(this.uLoc_.getY());
        this.paintIcon(this.layer_.getPane().getComponent(), (Graphics)g, x, y);
    }

    @Override
    public String getId() {
        return this.id_;
    }

    @Override
    public Layer getLayer() {
        return this.layer_;
    }

    @Override
    public AbstractPane getPane() {
        return this.layer_.getPane();
    }

    @Override
    public void modified(String mess) {
        if (this.layer_ != null) {
            this.layer_.modified(mess);
        }
    }

    @Override
    public void setId(String id) {
        this.id_ = id;
    }

    @Override
    public void setLayer(Layer l) {
        this.layer_ = l;
    }

    @Override
    public String toString() {
        return "UserIcon: " + this.id_;
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds_;
    }

    @Override
    public boolean isSelected() {
        return this.selected_;
    }

    @Override
    public void setSelected(boolean sel) {
        this.selected_ = sel;
    }

    @Override
    public boolean isSelectable() {
        return this.selectable_;
    }

    @Override
    public void setSelectable(boolean select) {
        this.selectable_ = select;
    }

    public Point2D.Double getLocationP() {
        return this.loc_;
    }

    public void setLocationP(Point2D.Double loc) {
        this.loc_ = loc;
        this.bounds_.x = this.layer_.getXPtoD(this.loc_.x);
        this.bounds_.y = this.layer_.getYPtoD(this.loc_.y);
        SoTPoint pt = ((CartesianGraph)this.layer_.getGraph()).getPtoU(this.loc_);
        if (!pt.equals(this.uLoc_) || this.moved_) {
            this.changes_.firePropertyChange("location", this.uLoc_, pt);
            this.uLoc_ = pt;
            this.moved_ = false;
        }
    }

    public SoTPoint getLocationU() {
        return this.uLoc_;
    }

    public void setLocationUNoVeto(SoTPoint loc) {
        this.moved_ = this.moved_ || !loc.equals(this.uLoc_);
        this.uLoc_ = loc;
        this.loc_.x = ((CartesianGraph)this.layer_.getGraph()).getXUtoP(this.uLoc_.getX());
        this.loc_.y = ((CartesianGraph)this.layer_.getGraph()).getYUtoP(this.uLoc_.getY());
        this.bounds_.x = this.layer_.getXPtoD(this.loc_.x);
        this.bounds_.y = this.layer_.getYPtoD(this.loc_.y);
    }

    public void setLocationU(SoTPoint loc) throws PropertyVetoException {
        if (!loc.equals(this.uLoc_) || this.moved_) {
            this.vetos_.fireVetoableChange("location", this.uLoc_, loc);
            this.changes_.firePropertyChange("location", this.uLoc_, loc);
            this.uLoc_ = loc;
            this.moved_ = false;
            this.loc_.x = ((CartesianGraph)this.layer_.getGraph()).getXUtoP(this.uLoc_.getX());
            this.loc_.y = ((CartesianGraph)this.layer_.getGraph()).getYUtoP(this.uLoc_.getY());
            this.bounds_.x = this.layer_.getXPtoD(this.loc_.x);
            this.bounds_.y = this.layer_.getYPtoD(this.loc_.y);
        }
    }

    @Override
    public void setLocationNoVeto(int x, int y) {
        this.bounds_.x = x;
        this.bounds_.y = y;
        this.loc_.x = this.layer_.getXDtoP(x);
        this.loc_.y = this.layer_.getYDtoP(y);
        SoTPoint pt = ((CartesianGraph)this.layer_.getGraph()).getPtoU(this.loc_);
        this.moved_ = this.moved_ || !pt.equals(this.uLoc_);
        this.uLoc_ = pt;
    }

    @Override
    public void setLocation(Point loc) {
        this.setLocation(loc, true);
    }

    @Override
    public void setLocation(Point loc, boolean fireEvent) {
        this.setBounds(loc.x, loc.y, 0, 0, fireEvent);
    }

    public void setBounds(int x, int y, int width, int height) {
        this.setBounds(x, y, width, height, true);
    }

    protected void setBounds(int x, int y, int width, int height, boolean fireEvent) {
        this.bounds_.x = x;
        this.bounds_.y = y;
        this.loc_.x = this.layer_.getXDtoP(x);
        this.loc_.y = this.layer_.getYDtoP(y);
        SoTPoint pt = ((CartesianGraph)this.layer_.getGraph()).getPtoU(this.loc_);
        boolean bl = this.moved_ = this.moved_ || !pt.equals(this.uLoc_);
        if (this.moved_) {
            SoTPoint temp = new SoTPoint(pt);
            if (fireEvent) {
                this.changes_.firePropertyChange("location", this.uLoc_, temp);
                this.moved_ = false;
            }
            this.uLoc_ = temp;
        }
    }

    public void setBounds(Rectangle bounds) {
        this.setBounds(bounds.x, bounds.y, bounds.width, bounds.height);
    }

    public void addVetoableChangeListener(VetoableChangeListener l) {
        this.vetos_.addVetoableChangeListener(l);
    }

    public void removeVetoableChangeListener(VetoableChangeListener l) {
        this.vetos_.removeVetoableChangeListener(l);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.changes_.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.changes_.removePropertyChangeListener(l);
    }
}

