/*
 * Decompiled with CFR 0.152.
 */
package sgtplot.contour;

import java.awt.Color;
import java.util.Enumeration;
import java.util.Vector;
import org.freehep.graphics2d.VectorGraphics;
import sgtplot.CartesianGraph;
import sgtplot.ContourLineAttribute;
import sgtplot.DefaultContourLineAttribute;
import sgtplot.JPane;
import sgtplot.LayerNotFoundException;
import sgtplot.SGLabel;
import sgtplot.StrokeDrawer;
import sgtplot.contour.ContourLabel;
import sgtplot.util.GeoDate;
import sgtplot.util.Point2D;

public class ContourLine
extends Vector {
    private StrokeDrawer stroke_ = null;
    private boolean closed_ = false;
    private double level_;
    private GeoDate timeRef_ = null;
    private boolean xTime_ = false;
    private boolean yTime_ = false;
    private int kmax_;
    private ContourLineAttribute attr_ = null;
    private DefaultContourLineAttribute defaultAttr_ = null;
    private Vector conLabels_ = new Vector();
    private ContourLabel lnkContourLabel;
    private CartesianGraph cg_;

    public ContourLine() {
        this.stroke_ = JPane.getStrokeDrawer();
    }

    public ContourLine(int size, int extend) {
        super(size, extend);
        this.stroke_ = JPane.getStrokeDrawer();
    }

    public ContourLine(int size) {
        super(size);
        this.stroke_ = JPane.getStrokeDrawer();
    }

    public void setCartesianGraph(CartesianGraph cg) {
        this.cg_ = cg;
    }

    public void setAttributes(DefaultContourLineAttribute def, ContourLineAttribute attr) {
        this.defaultAttr_ = def;
        this.attr_ = attr;
    }

    public void setContourLineAttribute(ContourLineAttribute attr) {
        this.attr_ = attr;
    }

    public ContourLineAttribute getContourLineAttribute() {
        return this.attr_;
    }

    public void setDefaultContourLineAttribute(DefaultContourLineAttribute def) {
        this.defaultAttr_ = def;
    }

    public DefaultContourLineAttribute getDefaultContourLineAttribute() {
        return this.defaultAttr_;
    }

    void setClosed(boolean closed) {
        this.closed_ = closed;
    }

    public boolean isClosed() {
        return this.closed_;
    }

    public double getLevel() {
        return this.level_;
    }

    void setLevel(double level) {
        this.level_ = level;
    }

    void addPoint(double x, double y) {
        this.addElement(new Point2D.Double(x, y));
    }

    void addPoint(Point2D.Double point) {
        this.addElement(point);
    }

    void setKmax(int kmax) {
        this.kmax_ = kmax;
    }

    public int getKmax() {
        return this.kmax_;
    }

    void setTime(GeoDate tref, boolean xtime, boolean ytime) {
        this.timeRef_ = tref;
        this.xTime_ = xtime;
        this.yTime_ = ytime;
    }

    void setReferenceTime(GeoDate tref) {
        this.timeRef_ = tref;
    }

    public GeoDate getReferenceTime() {
        return this.timeRef_;
    }

    void setXTime(boolean time) {
        this.xTime_ = time;
    }

    public boolean isXTime() {
        return this.xTime_;
    }

    void setYTime(boolean time) {
        this.yTime_ = time;
    }

    public boolean isYTime() {
        return this.yTime_;
    }

    void reverseElements(int k) {
        int kh = 1 + k / 2;
        for (int kk = 1; kk < kh; ++kk) {
            int kkr = k + 1 - kk;
            Point2D.Double point = (Point2D.Double)this.elementAt(kk);
            this.setElementAt(this.elementAt(kkr), kk);
            this.setElementAt(point, kkr);
        }
    }

    public void addLabel(int point, SGLabel lab, double hgt, double wid) {
        ContourLabel clab = new ContourLabel(point, lab, hgt, wid);
        this.conLabels_.addElement(clab);
    }

    public void removeAllLabels() {
        this.conLabels_.removeAllElements();
    }

    public void draw(VectorGraphics g) {
        double[] x = new double[this.kmax_ + 1];
        double[] y = new double[this.kmax_ + 1];
        this.defaultAttr_.setContourLineAttribute(this.attr_);
        Color lineColor = this.defaultAttr_.getColor();
        x = this.getXArrayP();
        y = this.getYArrayP();
        int k = 1;
        Enumeration cenum = this.conLabels_.elements();
        while (cenum.hasMoreElements()) {
            double ylab;
            double xlab;
            int kp1;
            double dyy;
            double dxx;
            double space;
            int kk;
            ContourLabel clab = (ContourLabel)cenum.nextElement();
            int loc = clab.getIndex();
            double width = clab.getWidth();
            double hhgt = clab.getHeight() * 0.5;
            SGLabel label = clab.getLabel();
            g.setColor(lineColor);
            this.drawLine(g, x, y, k, loc);
            k = loc;
            for (kk = kp1 = k + 1; kk <= this.kmax_ && !((space = Math.sqrt((dxx = x[kk] - x[k]) * dxx + (dyy = y[kk] - y[k]) * dyy)) >= width); ++kk) {
            }
            double xa = x[kk - 1] - x[k];
            double xb = x[kk] - x[kk - 1];
            double ya = y[kk - 1] - y[k];
            double yb = y[kk] - y[kk - 1];
            double aa = xb * xb + yb * yb;
            double bb = xa * xb + ya * yb;
            double cc = xa * xa + ya * ya - width * width;
            double zxy = (-bb + Math.sqrt(bb * bb - aa * cc)) / aa;
            dxx = xa + xb * zxy;
            dyy = ya + yb * zxy;
            double xendl = x[k] + dxx;
            double yendl = y[k] + dyy;
            double angle = 90.0;
            if (dyy < 0.0) {
                angle = -90.0;
            }
            if (dxx != 0.0) {
                angle = Math.atan(dyy / dxx) * 180.0 / Math.PI;
            }
            if (dxx >= 0.0) {
                xlab = x[k] + hhgt * (0.5 * dxx + dyy) / width;
                ylab = y[k] + hhgt * (0.5 * dyy - dxx) / width;
            } else {
                xlab = xendl - hhgt * (0.5 * dxx + dyy) / width;
                ylab = yendl - hhgt * (0.5 * dyy - dxx) / width;
            }
            label.setAngle(angle);
            label.setLocationP(new Point2D.Double(xlab, ylab));
            try {
                label.draw(g);
            }
            catch (LayerNotFoundException e) {
                System.out.println(e);
            }
            g.setColor(lineColor);
            this.drawLineSegment(g, xendl, yendl, x[kk], y[kk]);
            k = kk;
        }
        if (k < this.kmax_) {
            g.setColor(lineColor);
            this.drawLine(g, x, y, k, this.kmax_);
        }
    }

    private void drawLine(VectorGraphics g, double[] x, double[] y, int kstart, int kend) {
        int size = kend - kstart + 1;
        int[] xp = new int[size];
        int[] yp = new int[size];
        int i = 0;
        int k = kstart;
        while (k <= kend) {
            xp[i] = this.cg_.getLayer().getXPtoD(x[k]);
            yp[i] = this.cg_.getLayer().getYPtoD(y[k]);
            ++k;
            ++i;
        }
        switch (this.defaultAttr_.getStyle()) {
            case 3: {
                this.stroke_.drawHighlight(g, xp, yp, size, this.defaultAttr_);
                break;
            }
            case 2: {
                this.stroke_.drawHeavy(g, xp, yp, size, this.defaultAttr_);
                break;
            }
            case 1: {
                this.stroke_.drawDashed(g, xp, yp, size, this.defaultAttr_);
                break;
            }
            case 6: {
                this.stroke_.drawStroke(g, xp, yp, size, this.defaultAttr_);
                break;
            }
            default: {
                g.drawPolyline(xp, yp, size);
            }
        }
    }

    private void drawLineSegment(VectorGraphics g, double x0, double y0, double x1, double y1) {
        int size = 2;
        int[] xp = new int[2];
        int[] yp = new int[2];
        xp[0] = this.cg_.getLayer().getXPtoD(x0);
        yp[0] = this.cg_.getLayer().getYPtoD(y0);
        xp[1] = this.cg_.getLayer().getXPtoD(x1);
        yp[1] = this.cg_.getLayer().getYPtoD(y1);
        switch (this.defaultAttr_.getStyle()) {
            case 3: {
                this.stroke_.drawHighlight(g, xp, yp, size, this.defaultAttr_);
                break;
            }
            case 2: {
                this.stroke_.drawHeavy(g, xp, yp, size, this.defaultAttr_);
                break;
            }
            case 1: {
                this.stroke_.drawDashed(g, xp, yp, size, this.defaultAttr_);
                break;
            }
            case 6: {
                this.stroke_.drawStroke(g, xp, yp, size, this.defaultAttr_);
                break;
            }
            default: {
                g.drawPolyline(xp, yp, size);
            }
        }
    }

    public double[] getXArrayP() {
        double[] xp = null;
        if (this.cg_ != null) {
            xp = new double[this.kmax_ + 1];
            for (int k = 0; k <= this.kmax_; ++k) {
                Point2D.Double pt = (Point2D.Double)this.elementAt(k);
                if (this.isXTime()) {
                    GeoDate time = new GeoDate(this.timeRef_).increment(pt.x, 1);
                    xp[k] = this.cg_.getXUtoP(time);
                    continue;
                }
                xp[k] = this.cg_.getXUtoP(pt.x);
            }
        }
        return xp;
    }

    public double[] getYArrayP() {
        double[] yp = null;
        if (this.cg_ != null) {
            yp = new double[this.kmax_ + 1];
            for (int k = 0; k <= this.kmax_; ++k) {
                Point2D.Double pt = (Point2D.Double)this.elementAt(k);
                if (this.isYTime()) {
                    GeoDate time = new GeoDate(this.timeRef_).increment(pt.x, 1);
                    yp[k] = this.cg_.getYUtoP(time);
                    continue;
                }
                yp[k] = this.cg_.getYUtoP(pt.y);
            }
        }
        return yp;
    }
}

