/*
 * Decompiled with CFR 0.152.
 */
package sgtplot.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InvalidObjectException;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import sgtplot.beans.PanelModel;
import sgtplot.beans.PanelModelCustomizer;
import sgtplot.util.SimpleFileFilter;

public class PanelModelEditor
extends JFrame {
    private PanelModel panelModel_ = null;
    private static boolean isApp_ = false;
    private boolean throwClosing = true;
    private String openPath_ = null;
    private static String title_ = "Panel Model Editor";
    private JFileChooser fileChooser_ = null;
    private JPanel pmcPanel = new JPanel();
    private JPanel buttonPanel = new JPanel();
    private JMenuBar menuBar = new JMenuBar();
    private JButton okButton = new JButton();
    private PanelModelCustomizer pmc = new PanelModelCustomizer();
    private BorderLayout borderLayout1 = new BorderLayout();
    private JMenu fileMenu = new JMenu();
    private JMenuItem openFileMI = new JMenuItem();
    private JMenuItem saveFileMI = new JMenuItem();
    private JMenuItem exitFileMI = new JMenuItem();
    private JMenuItem saveAsFileMI = new JMenuItem();
    private JMenuItem newFileMI = new JMenuItem();

    public PanelModelEditor(PanelModel pModel) {
        this();
        this.setPanelModel(pModel);
    }

    public PanelModelEditor() {
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        isApp_ = true;
        PanelModelEditor pme = new PanelModelEditor(new PanelModel());
        pme.setTitle(title_);
        pme.setVisible(true);
    }

    private void jbInit() throws Exception {
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelModelEditor.this.okButton_actionPerformed(e);
            }
        });
        this.pmcPanel.setLayout(this.borderLayout1);
        this.fileMenu.setText("File");
        this.openFileMI.setActionCommand("Open");
        this.openFileMI.setText("Open...");
        this.openFileMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelModelEditor.this.openFileMI_actionPerformed(e);
            }
        });
        this.saveFileMI.setActionCommand("Save");
        this.saveFileMI.setText("Save");
        this.saveFileMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelModelEditor.this.saveFileMI_actionPerformed(e);
            }
        });
        this.exitFileMI.setText("Exit");
        this.exitFileMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelModelEditor.this.exitFileMI_actionPerformed(e);
            }
        });
        this.saveAsFileMI.setActionCommand("SaveAs");
        this.saveAsFileMI.setText("Save As...");
        this.saveAsFileMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelModelEditor.this.saveAsFileMI_actionPerformed(e);
            }
        });
        if (isApp_) {
            this.setJMenuBar(this.menuBar);
        }
        this.newFileMI.setText("New");
        this.newFileMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelModelEditor.this.newFileMI_actionPerformed(e);
            }
        });
        this.getContentPane().add((Component)this.pmcPanel, "Center");
        if (!isApp_) {
            this.getContentPane().add((Component)this.buttonPanel, "South");
        }
        this.buttonPanel.add((Component)this.okButton, null);
        this.pmcPanel.add((Component)this.pmc, "Center");
        this.menuBar.add(this.fileMenu);
        this.fileMenu.add(this.newFileMI);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.openFileMI);
        this.fileMenu.add(this.saveFileMI);
        this.fileMenu.add(this.saveAsFileMI);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.exitFileMI);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (PanelModelEditor.this.throwClosing) {
                    PanelModelEditor.this.pmf_windowClosing(e);
                }
            }
        });
        Dimension dim = this.pmc.getPreferredSize();
        this.setSize(new Dimension(473, 354));
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        this.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
    }

    void pmf_windowClosing(WindowEvent e) {
        this.throwClosing = false;
        this.setVisible(false);
        if (this.panelModel_ != null) {
            this.panelModel_.setBatch(false);
        }
        this.dispose();
        if (isApp_) {
            System.exit(0);
        }
    }

    void okButton_actionPerformed(ActionEvent e) {
        this.throwClosing = false;
        this.pmf_windowClosing(null);
    }

    public PanelModel getPanelModel() {
        return this.panelModel_;
    }

    public void setPanelModel(PanelModel panelModel) {
        this.panelModel_ = panelModel;
        if (this.panelModel_ != null) {
            this.panelModel_.setBatch(true);
            this.pmc.setObject(this.panelModel_);
        }
    }

    void openFileMI_actionPerformed(ActionEvent e) {
        PanelModel pModel = null;
        String[] xmlFile = new String[]{".xml"};
        SimpleFileFilter xmlFilt = new SimpleFileFilter(xmlFile, "XML Serialized Bean");
        if (this.fileChooser_ == null) {
            this.fileChooser_ = new JFileChooser();
        }
        this.fileChooser_.setFileFilter(this.fileChooser_.getAcceptAllFileFilter());
        this.fileChooser_.resetChoosableFileFilters();
        this.fileChooser_.addChoosableFileFilter(xmlFilt);
        this.fileChooser_.setFileFilter(xmlFilt);
        int result = this.fileChooser_.showOpenDialog(this);
        if (result == 0) {
            File file = this.fileChooser_.getSelectedFile();
            this.openPath_ = file.getPath();
            this.setTitle(title_ + ": " + this.openPath_);
            try {
                pModel = PanelModel.loadFromXML(new BufferedInputStream(new FileInputStream(this.openPath_)));
                this.setPanelModel(pModel);
            }
            catch (FileNotFoundException fnfe) {
                JOptionPane.showMessageDialog(this, "Error openning file", "File Open Error", 0);
            }
            catch (InvalidObjectException ioe) {
                JOptionPane.showMessageDialog(this, "File does not contain a PanelModel", "PanelModel Not Found", 0);
            }
        }
    }

    void saveAsFileMI_actionPerformed(ActionEvent e) {
        String[] xmlFile = new String[]{".xml"};
        SimpleFileFilter xmlFilt = new SimpleFileFilter(xmlFile, "XML Serialized Bean");
        if (this.fileChooser_ == null) {
            this.fileChooser_ = new JFileChooser();
        }
        this.fileChooser_.setFileFilter(this.fileChooser_.getAcceptAllFileFilter());
        this.fileChooser_.resetChoosableFileFilters();
        this.fileChooser_.addChoosableFileFilter(xmlFilt);
        this.fileChooser_.setFileFilter(xmlFilt);
        int result = this.fileChooser_.showSaveDialog(this);
        if (result == 0) {
            File file = this.fileChooser_.getSelectedFile();
            FileFilter filt = this.fileChooser_.getFileFilter();
            String outpath = file.getPath();
            if (filt instanceof SimpleFileFilter) {
                String ext = ((SimpleFileFilter)filt).getExtension();
                String name = file.getName().toLowerCase();
                if (!name.endsWith(ext)) {
                    outpath = outpath + ext;
                }
            }
            if (new File(outpath).exists()) {
                JOptionPane.showMessageDialog(this, "File already exists, rename and try again", "File Save Error", 0);
                return;
            }
            try {
                this.panelModel_.saveToXML(new BufferedOutputStream(new FileOutputStream(outpath, false)));
            }
            catch (FileNotFoundException fnfe) {
                JOptionPane.showMessageDialog(this, "Error creating file, rename and try again", "File Save Error", 0);
                return;
            }
        }
    }

    void saveFileMI_actionPerformed(ActionEvent e) {
        if (this.openPath_ == null) {
            return;
        }
        try {
            this.panelModel_.saveToXML(new BufferedOutputStream(new FileOutputStream(this.openPath_, false)));
        }
        catch (FileNotFoundException fnfe) {
            JOptionPane.showMessageDialog(this, "Error creating file, rename and try again", "File Save Error", 0);
            return;
        }
    }

    void exitFileMI_actionPerformed(ActionEvent e) {
        this.throwClosing = false;
        this.pmf_windowClosing(null);
    }

    void newFileMI_actionPerformed(ActionEvent e) {
        this.setPanelModel(new PanelModel());
    }
}

