/*
 * Decompiled with CFR 0.152.
 */
package sgtplot.beans;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.freehep.graphics2d.VectorGraphics;
import sgtplot.Attribute;
import sgtplot.Axis;
import sgtplot.AxisNotFoundException;
import sgtplot.AxisTransform;
import sgtplot.CartesianGraph;
import sgtplot.CartesianRenderer;
import sgtplot.ColorMap;
import sgtplot.ContourLevels;
import sgtplot.ContourLevelsAccess;
import sgtplot.DataKey;
import sgtplot.Graph;
import sgtplot.GridAttribute;
import sgtplot.Layer;
import sgtplot.LinearTransform;
import sgtplot.LogAxis;
import sgtplot.LogTransform;
import sgtplot.PaneNotFoundException;
import sgtplot.PlainAxis;
import sgtplot.SGLabel;
import sgtplot.TimeAxis;
import sgtplot.TransformAccess;
import sgtplot.beans.AxisHolder;
import sgtplot.beans.DataGroup;
import sgtplot.beans.DataTargetMismatchException;
import sgtplot.beans.Legend;
import sgtplot.beans.Margin;
import sgtplot.beans.Panel;
import sgtplot.beans.PanelHolder;
import sgtplot.dm.SGTData;
import sgtplot.dm.SGTGrid;
import sgtplot.util.Dimension2D;
import sgtplot.util.Point2D;
import sgtplot.util.Range2D;
import sgtplot.util.SoTDomain;
import sgtplot.util.SoTPoint;
import sgtplot.util.SoTRange;
import sgtplot.util.SoTValue;

public class DataGroupLayer
extends Layer {
    private List dataLayers_ = new Vector();
    private DataGroup dg_ = null;
    private PanelHolder pHolder_ = null;
    private Panel panel_ = null;
    private SoTRange xRange_ = null;
    private SoTRange yRange_ = null;
    private boolean clipping_ = false;
    private SoTDomain clipDomain_ = null;
    private SoTRange xZoomRange_ = null;
    private SoTRange yZoomRange_ = null;
    private boolean inZoom_ = false;
    private SGLabel xLabel_ = null;
    private SGLabel yLabel_ = null;

    public DataGroupLayer() {
        this((Panel)null, (DataGroup)null);
    }

    public DataGroupLayer(Panel panel, DataGroup dg) {
        this.panel_ = panel;
        this.setPane(panel.getPane());
        this.pHolder_ = dg.getPanelHolder();
        this.setGraph(new CartesianGraph("Graph"));
        this.dg_ = dg;
        this.setId(this.dg_.getId());
        this.update();
    }

    public Panel getPanel() {
        return this.panel_;
    }

    public DataGroup getDataGroup() {
        return this.dg_;
    }

    public Iterator getLayerIterator() {
        return this.dataLayers_.iterator();
    }

    public List getLayerList() {
        return this.dataLayers_;
    }

    private String getNextLayerId() {
        int count = this.dataLayers_.size() + 1;
        return this.getId() + "_" + count;
    }

    public void addData(SGTData data, Attribute attr, DataKey key) throws DataTargetMismatchException {
        Serializable label;
        CartesianGraph graph = (CartesianGraph)this.getGraph();
        if (graph.getXTransform().isTime() != data.isXTime() || graph.getYTransform().isTime() != data.isYTime()) {
            JOptionPane.showMessageDialog(this, "Added data does not have the\nsame axis types as the DataGroup\n\nTime or Space axis does not match.", "DataGroup Error", 0);
            throw new DataTargetMismatchException("Data - Axis Mismatch");
        }
        CartesianRenderer rend = graph.getRenderer();
        if (rend == null) {
            this.xRange_ = data.getXRange();
            this.yRange_ = data.getYRange();
            graph.setData(data, attr);
            this.dataLayers_.add(this);
            label = new StringBuffer(data.getXMetaData().getName());
            String units = data.getXMetaData().getUnits();
            if (units != null && units.length() > 0) {
                label.append(" (").append(units).append(")");
            }
            this.xLabel_ = new SGLabel("X Axis Label", label.toString(), new Point2D.Double(0.0, 0.0));
            label = new StringBuffer(data.getYMetaData().getName());
            units = data.getYMetaData().getUnits();
            if (units != null && units.length() > 0) {
                label.append(" (").append(units).append(")");
            }
            this.yLabel_ = new SGLabel("Y Axis Label", label.toString(), new Point2D.Double(0.0, 0.0));
        } else {
            this.xRange_.add(data.getXRange());
            this.yRange_.add(data.getYRange());
            Layer ly = new Layer(this.getNextLayerId());
            CartesianGraph cg = new CartesianGraph("Graph_" + ly.getId(), graph.getXTransform(), graph.getYTransform());
            ly.setPane(this.getPane());
            ly.setSizeP(this.getSizeP());
            ly.setBounds(this.getBounds());
            ly.setGraph(cg);
            cg.setData(data, attr);
            this.dataLayers_.add(ly);
            if (this.clipping_) {
                cg.setClip(this.clipDomain_.getXRange(), this.clipDomain_.getYRange());
            }
            graph = cg;
        }
        if (this.dg_.isZAutoScale() && attr != null && attr instanceof GridAttribute) {
            Range2D zRange = ((SGTGrid)data).getZRange();
            ColorMap cmap = ((GridAttribute)attr).getColorMap();
            if (cmap instanceof TransformAccess) {
                ((TransformAccess)((Object)cmap)).setRange(zRange);
            } else if (cmap instanceof ContourLevelsAccess) {
                ContourLevels cl = ((ContourLevelsAccess)((Object)cmap)).getContourLevels();
                int levels = this.dg_.getNumberAutoContourLevels();
                Range2D newRange = Graph.computeRange(zRange, levels);
                ((ContourLevelsAccess)((Object)cmap)).setContourLevels(ContourLevels.getDefault(newRange));
            }
        }
        if (key != null) {
            rend = graph.getRenderer();
            label = this.getLabel(data, key);
            key.addGraph(rend, (SGLabel)label);
        }
        this.update();
    }

    private SGLabel getLabel(SGTData data, DataKey key) {
        SGLabel lineTitle = data.getKeyTitle();
        if (lineTitle == null) {
            lineTitle = this.xLabel_;
        }
        Legend lg = this.pHolder_.findLegend(key.getId());
        lineTitle.setHeightP(lg.getKeyLabelHeightP());
        return lineTitle;
    }

    public void update() {
        SoTRange range;
        Rectangle bnds = this.pHolder_.getBounds();
        double dpi = this.pHolder_.getPanelModel().getDpi();
        double width = (double)bnds.width / dpi;
        double height = (double)bnds.height / dpi;
        SoTRange xRange = null;
        SoTRange yRange = null;
        SoTPoint xOrig = null;
        SoTPoint yOrig = null;
        boolean batch = this.getPane().isBatch();
        this.getPane().setBatch(true);
        AxisHolder xAxHolder = this.dg_.getXAxisHolder();
        AxisHolder yAxHolder = this.dg_.getYAxisHolder();
        CartesianGraph gr = (CartesianGraph)this.getGraph();
        this.setSizeP(new Dimension2D(width, height));
        if (this.inZoom_) {
            xRange = this.xZoomRange_;
            yRange = this.yZoomRange_;
        } else {
            xRange = !xAxHolder.isAutoRange() || this.xRange_ == null ? xAxHolder.getUserRange() : this.xRange_;
            yRange = !yAxHolder.isAutoRange() || this.yRange_ == null ? yAxHolder.getUserRange() : this.yRange_;
        }
        this.updateTransform(0, xRange);
        this.updateTransform(1, yRange);
        Margin marg = this.dg_.getMargin();
        if (xAxHolder.getAxisPosition() == 4) {
            xOrig = new SoTPoint(gr.getXPtoSoT(xAxHolder.getAxisOriginP().x), gr.getYPtoSoT(xAxHolder.getAxisOriginP().y));
        } else {
            SoTValue yloc = null;
            range = null;
            range = yAxHolder.getAxisPosition() == 4 ? (gr.getYTransform().isTime() ? new SoTRange.Time(gr.getYPtoLongTime(marg.bottom), gr.getYPtoLongTime(marg.top)) : new SoTRange.Double(gr.getYPtoU(marg.bottom), gr.getYPtoU(marg.top))) : yRange;
            switch (xAxHolder.getAxisPosition()) {
                case 1: {
                    yloc = range.getStart();
                    break;
                }
                case 0: {
                    yloc = range.getEnd();
                }
            }
            xOrig = new SoTPoint(xRange.getStart(), yloc);
        }
        if (yAxHolder.getAxisPosition() == 4) {
            yOrig = new SoTPoint(gr.getXPtoSoT(yAxHolder.getAxisOriginP().x), gr.getYPtoSoT(yAxHolder.getAxisOriginP().y));
        } else {
            SoTValue xloc = null;
            range = null;
            range = xAxHolder.getAxisPosition() == 4 ? (gr.getXTransform().isTime() ? new SoTRange.Time(gr.getXPtoLongTime(marg.left), gr.getXPtoLongTime(marg.right)) : new SoTRange.Double(gr.getXPtoU(marg.left), gr.getXPtoU(marg.right))) : xRange;
            switch (yAxHolder.getAxisPosition()) {
                case 2: {
                    xloc = range.getStart();
                    break;
                }
                case 3: {
                    xloc = range.getEnd();
                }
            }
            yOrig = new SoTPoint(xloc, yRange.getStart());
        }
        this.updateAxis(0, xRange, xOrig, this.xLabel_);
        this.updateAxis(1, yRange, yOrig, this.yLabel_);
        this.getPane().setBatch(batch);
    }

    private void updateTransform(int dir, SoTRange range) {
        AxisTransform at;
        AxisHolder ah;
        CartesianGraph gr = (CartesianGraph)this.getGraph();
        if (dir == 0) {
            ah = this.dg_.getXAxisHolder();
            at = gr.getXTransform();
        } else {
            ah = this.dg_.getYAxisHolder();
            at = gr.getYTransform();
        }
        switch (ah.getTransformType()) {
            case 0: {
                if (at instanceof LinearTransform) {
                    at.setRangeU(range);
                    at.setRangeP(ah.getRangeP());
                    break;
                }
                at = new LinearTransform(ah.getRangeP(), range);
                gr.setXTransform(at);
                break;
            }
            case 1: {
                if (at instanceof LogTransform) {
                    at.setRangeU(range);
                    at.setRangeP(ah.getRangeP());
                    break;
                }
                at = new LogTransform(ah.getRangeP(), range);
                gr.setXTransform(at);
                break;
            }
            case 2: {
                at = this.getReferenceTransform(0, ah.getTransformGroup());
                gr.setXTransform(at);
            }
        }
    }

    private void updateAxis(int dir, SoTRange range, SoTPoint origin, SGLabel title) {
        AxisTransform at;
        AxisHolder ah;
        String axis;
        Axis ax = null;
        boolean newAxis = true;
        CartesianGraph gr = (CartesianGraph)this.getGraph();
        if (dir == 0) {
            axis = "X Axis";
            ah = this.dg_.getXAxisHolder();
            at = gr.getXTransform();
        } else {
            axis = "Y Axis";
            ah = this.dg_.getYAxisHolder();
            at = gr.getYTransform();
        }
        try {
            ax = gr.getXAxis(axis);
        }
        catch (AxisNotFoundException anfe) {
            ax = null;
        }
        newAxis = false;
        switch (ah.getAxisType()) {
            case 4: {
                PlainAxis pax = null;
                if (ax != null) {
                    if (ax instanceof PlainAxis) {
                        pax = (PlainAxis)ax;
                    } else {
                        pax = new PlainAxis(axis);
                        newAxis = true;
                    }
                } else {
                    pax = new PlainAxis(axis);
                    newAxis = true;
                }
                ax = pax;
                pax.setRangeP(ah.getRangeP());
                pax.setRangeU(range);
                pax.setLabelFormat(ah.getLabelFormat());
                pax.setLabelInterval(ah.getLabelInterval());
                pax.setSignificantDigits(ah.getLabelSignificantDigits());
                break;
            }
            case 3: {
                TimeAxis tax = null;
                if (ax != null) {
                    if (ax instanceof TimeAxis) {
                        tax = (TimeAxis)ax;
                    } else {
                        tax = new TimeAxis(axis, ah.getTimeAxisStyle());
                        newAxis = true;
                    }
                } else {
                    tax = new TimeAxis(axis, ah.getTimeAxisStyle());
                    newAxis = true;
                }
                ax = tax;
                tax.setRangeP(ah.getRangeP());
                tax.setRangeU(range);
                if (ah.getTimeAxisStyle() == 0) break;
                tax.setLabelFormat(ah.getMinorFormat(), ah.getMajorFormat());
                tax.setLabelInterval(ah.getMinorInterval(), ah.getMajorInterval());
                break;
            }
            case 1: {
                LogAxis lax = null;
                if (ax != null) {
                    if (ax instanceof LogAxis) {
                        lax = (LogAxis)ax;
                    } else {
                        lax = new LogAxis(axis);
                        newAxis = true;
                    }
                } else {
                    lax = new LogAxis(axis);
                    newAxis = true;
                }
                ax = lax;
                lax.setRangeP(ah.getRangeP());
                lax.setRangeU(range);
                lax.setLabelFormat(ah.getLabelFormat());
                lax.setLabelInterval(ah.getLabelInterval());
                lax.setSignificantDigits(ah.getLabelSignificantDigits());
            }
        }
        if (dir == 0) {
            ax.setOrientation(0);
        } else {
            ax.setOrientation(1);
        }
        ax.setLocationU(origin);
        ax.setLineColor(ah.getAxisColor());
        ax.setTicPosition(ah.getTicPosition());
        ax.setLabelColor(ah.getLabelColor());
        ax.setLabelFont(ah.getLabelFont());
        ax.setLabelHeightP(ah.getLabelHeightP());
        ax.setLargeTicHeightP(ah.getLargeTicHeightP());
        ax.setNumberSmallTics(ah.getNumSmallTics());
        ax.setSmallTicHeightP(ah.getSmallTicHeightP());
        ax.setThickTicWidthP(ah.getThickTicWidth());
        ax.setLabelPosition(ah.getLabelPosition());
        ax.setVisible(ah.isVisible());
        if (title != null && ah.isTitleAuto()) {
            SGLabel def = ah.getTitle();
            title.setColor(def.getColor());
            title.setFont(def.getFont());
            title.setHeightP(def.getHeightP());
            title.setVisible(def.isVisible());
            ax.setTitle(title);
        } else {
            ax.setTitle(ah.getTitle());
        }
        ax.register(at);
        if (dir == 0) {
            if (gr.getNumberXAxis() > 0 && newAxis) {
                gr.removeAllXAxes();
            }
            if (newAxis) {
                gr.addXAxis(ax);
            }
        } else {
            if (gr.getNumberYAxis() > 0 && newAxis) {
                gr.removeAllYAxes();
            }
            if (newAxis) {
                gr.addYAxis(ax);
            }
        }
    }

    @Override
    public void draw(VectorGraphics g) throws PaneNotFoundException {
        super.draw(g);
        for (int i = 1; i < this.dataLayers_.size(); ++i) {
            ((Layer)this.dataLayers_.get(i)).draw(g);
        }
    }

    @Override
    public void drawDraggableItems(VectorGraphics g) throws PaneNotFoundException {
        super.drawDraggableItems(g);
        for (int i = 1; i < this.dataLayers_.size(); ++i) {
            ((Layer)this.dataLayers_.get(i)).drawDraggableItems(g);
        }
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        for (int i = 1; i < this.dataLayers_.size(); ++i) {
            ((Layer)this.dataLayers_.get(i)).setBounds(x, y, w, h);
        }
    }

    @Override
    public void setBounds(Rectangle rect) {
        super.setBounds(rect);
        for (int i = 1; i < this.dataLayers_.size(); ++i) {
            ((Layer)this.dataLayers_.get(i)).setBounds(rect);
        }
    }

    @Override
    public void setLocation(int x, int y) {
        super.setLocation(x, y);
        for (int i = 1; i < this.dataLayers_.size(); ++i) {
            ((Layer)this.dataLayers_.get(i)).setLocation(x, y);
        }
    }

    @Override
    public void setLocation(Point pt) {
        super.setLocation(pt);
        for (int i = 1; i < this.dataLayers_.size(); ++i) {
            ((Layer)this.dataLayers_.get(i)).setLocation(pt);
        }
    }

    @Override
    public void setSize(Dimension size) {
        super.setSize(size);
        for (int i = 1; i < this.dataLayers_.size(); ++i) {
            ((Layer)this.dataLayers_.get(i)).setSize(size);
        }
    }

    @Override
    public void setSize(int w, int h) {
        super.setSize(w, h);
        for (int i = 1; i < this.dataLayers_.size(); ++i) {
            ((Layer)this.dataLayers_.get(i)).setSize(w, h);
        }
    }

    @Override
    public void setSizeP(Dimension2D size) {
        super.setSizeP(size);
        for (int i = 1; i < this.dataLayers_.size(); ++i) {
            ((Layer)this.dataLayers_.get(i)).setSizeP(size);
        }
    }

    private AxisTransform getReferenceTransform(int dir, String datagroup) {
        String dgLast = datagroup;
        boolean stillLooking = true;
        int tType = -1;
        String newDG = null;
        while (stillLooking) {
            DataGroup dg = this.pHolder_.findDataGroup(dgLast);
            tType = dir == 0 ? dg.getXAxisHolder().getTransformType() : dg.getYAxisHolder().getTransformType();
            if (tType != 2) {
                CartesianGraph graph = null;
                DataGroupLayer dgl = null;
                if (dir == 0) {
                    dgl = this.panel_.findDataGroupLayer(dg.getXAxisHolder().getTransformGroup());
                    graph = (CartesianGraph)dgl.getGraph();
                    if (graph == null) {
                        return null;
                    }
                    return graph.getXTransform();
                }
                dgl = this.panel_.findDataGroupLayer(dg.getYAxisHolder().getTransformGroup());
                graph = (CartesianGraph)dgl.getGraph();
                if (graph == null) {
                    return null;
                }
                return graph.getYTransform();
            }
            newDG = dir == 0 ? dg.getXAxisHolder().getTransformGroup() : dg.getYAxisHolder().getTransformGroup();
            dgLast = newDG;
        }
        return null;
    }

    public void setClipping(boolean clip) {
        if (!this.dg_.isZoomable()) {
            return;
        }
        this.clipping_ = clip;
        this.setAllClipping(this.clipping_);
    }

    void zoomTo(Point start, Rectangle rect) {
        if (!this.dg_.isZoomable()) {
            return;
        }
        CartesianGraph graph = (CartesianGraph)this.getGraph();
        Rectangle gbnds = this.getGraphBounds();
        Rectangle bnds = this.getPanelBounds();
        if (!gbnds.contains(start)) {
            return;
        }
        this.setClipping(true);
        double xStartP = this.getXDtoP(rect.x);
        double yStartP = this.getYDtoP(rect.y + rect.height);
        double xEndP = this.getXDtoP(rect.x + rect.width);
        double yEndP = this.getYDtoP(rect.y);
        SoTRange xRangeU = null;
        SoTRange yRangeU = null;
        xRangeU = graph.getXTransform().isTime() ? new SoTRange.Time(graph.getXPtoLongTime(xStartP), graph.getXPtoLongTime(xEndP)) : new SoTRange.Double(graph.getXPtoU(xStartP), graph.getXPtoU(xEndP));
        yRangeU = graph.getYTransform().isTime() ? new SoTRange.Time(graph.getYPtoLongTime(yStartP), graph.getYPtoLongTime(yEndP)) : new SoTRange.Double(graph.getYPtoU(yStartP), graph.getYPtoU(yEndP));
        this.inZoom_ = true;
        this.setDomain(new SoTDomain(xRangeU, yRangeU));
    }

    void resetZoom(int x, int y) {
        if (!this.dg_.isZoomable()) {
            return;
        }
        Rectangle bnds = this.getGraphBounds();
        if (!bnds.contains(x, y)) {
            return;
        }
        this.inZoom_ = false;
        this.xZoomRange_ = null;
        this.yZoomRange_ = null;
        this.setClipping(false);
        this.update();
    }

    public void resetZoom() {
        this.inZoom_ = false;
        this.xZoomRange_ = null;
        this.yZoomRange_ = null;
        this.setClipping(false);
        this.update();
    }

    public void setDomain(SoTDomain domain) {
        this.setXRange(domain.getXRange(), domain.isXReversed());
        this.setYRange(domain.getYRange(), domain.isYReversed());
        if (this.clipping_) {
            this.clipDomain_ = domain;
            this.setAllClip(domain);
        } else {
            this.clipDomain_ = null;
            this.setAllClipping(false);
        }
        this.update();
    }

    private void setXRange(SoTRange range, boolean reversed) {
        this.xZoomRange_ = range.copy();
    }

    private void setYRange(SoTRange range, boolean reversed) {
        this.yZoomRange_ = range.copy();
    }

    private void setAllClip(SoTDomain domain) {
        for (Object obj : this.dataLayers_) {
            if (!(obj instanceof Layer)) continue;
            Layer ly = (Layer)obj;
            ((CartesianGraph)ly.getGraph()).setClip(domain.getXRange(), domain.getYRange());
        }
    }

    private void setAllClipping(boolean clip) {
        for (Object obj : this.dataLayers_) {
            if (!(obj instanceof Layer)) continue;
            Layer ly = (Layer)obj;
            ((CartesianGraph)ly.getGraph()).setClipping(clip);
        }
    }

    private Rectangle getPanelBounds() {
        return this.pHolder_.getBounds();
    }

    private Rectangle getGraphBounds() {
        CartesianGraph graph = (CartesianGraph)this.getGraph();
        AxisTransform xTrans = graph.getXTransform();
        AxisTransform yTrans = graph.getYTransform();
        Range2D xRange = xTrans.getRangeP();
        Range2D yRange = yTrans.getRangeP();
        int x = this.getXPtoD(xRange.start);
        int y = this.getYPtoD(yRange.end);
        int width = this.getXPtoD(xRange.end) - x;
        int height = this.getYPtoD(yRange.start) - y;
        return new Rectangle(x, y, width, height);
    }
}

