/*
 * Decompiled with CFR 0.152.
 */
package sgtplot;

import sgtplot.TimeAxisStyle;
import sgtplot.util.GeoDate;
import sgtplot.util.IllegalTimeValue;
import sgtplot.util.TimeRange;

class YearDecadeAxis
implements TimeAxisStyle {
    static final int DECADE_TEST__ = 1000;
    static final String defaultMinorLabelFormat__ = "yy";
    static final String defaultMajorLabelFormat__ = "decade";
    int defaultMinorLabelInterval_ = 2;
    int defaultMajorLabelInterval_ = 1;
    static final int defaultNumSmallTics__ = 0;
    static final double incrementValue__ = 1.0;
    static final int incrementUnits__ = 4;

    @Override
    public void computeDefaults(GeoDate delta) {
        this.defaultMinorLabelInterval_ = delta.getTime() / 86400000L > 2500L ? 2 : 1;
    }

    @Override
    public double computeLocation(double prev, double now) {
        return (prev + now) * 0.5;
    }

    @Override
    public int getMinorValue(GeoDate time) {
        return time.getGMTYear() - time.getGMTYear() / 10 * 10 + 1;
    }

    @Override
    public int getMajorValue(GeoDate time) {
        return time.getGMTYear() / 10 * 10;
    }

    @Override
    public boolean isRoomForMajorLabel(GeoDate delta) {
        return delta.getTime() / 86400000L > 1000L;
    }

    @Override
    public boolean isStartOfMinor(GeoDate time) {
        return time.getGMTYear() % 10 == 0;
    }

    @Override
    public String getDefaultMinorLabelFormat() {
        return defaultMinorLabelFormat__;
    }

    @Override
    public String getDefaultMajorLabelFormat() {
        return defaultMajorLabelFormat__;
    }

    @Override
    public int getDefaultNumSmallTics() {
        return 0;
    }

    @Override
    public int getDefaultMajorLabelInterval() {
        return this.defaultMajorLabelInterval_;
    }

    @Override
    public int getDefaultMinorLabelInterval() {
        return this.defaultMinorLabelInterval_;
    }

    @Override
    public GeoDate getStartTime(TimeRange tRange) {
        GeoDate time = null;
        boolean time_increasing = tRange.end.after(tRange.start);
        try {
            if (time_increasing) {
                time = new GeoDate(1, 1, tRange.start.getGMTYear(), 0, 0, 0, 0);
                if (!time.equals(tRange.start)) {
                    time.increment(1.0, 4);
                }
            } else {
                time = new GeoDate(1, 1, tRange.end.getGMTYear(), 0, 0, 0, 0);
                if (!time.equals(tRange.end)) {
                    time.increment(1.0, 4);
                }
            }
        }
        catch (IllegalTimeValue illegalTimeValue) {
            // empty catch block
        }
        return time;
    }

    @Override
    public double getIncrementValue() {
        return 1.0;
    }

    @Override
    public int getIncrementUnits() {
        return 4;
    }

    @Override
    public String toString() {
        return "YearDecadeAxis";
    }
}

