/*
 * Decompiled with CFR 0.152.
 */
package sgtplot;

import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import org.freehep.graphics2d.VectorGraphics;
import sgtplot.AbstractPane;
import sgtplot.LabelDrawer;
import sgtplot.LabelDrawer2D;
import sgtplot.Layer;
import sgtplot.LayerChild;
import sgtplot.LayerNotFoundException;
import sgtplot.Moveable;
import sgtplot.PaneProxy;
import sgtplot.util.Point2D;
import sgtplot.util.Rectangle2D;

public class SGLabel
implements Cloneable,
LayerChild,
Moveable,
Serializable {
    private String ident_;
    private LabelDrawer proxy_;
    private boolean selected_;
    private boolean selectable_;
    private boolean moveable_;
    private transient PropertyChangeSupport changes_ = new PropertyChangeSupport(this);
    public static final int TOP = 0;
    public static final int MIDDLE = 1;
    public static final int BOTTOM = 2;
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final int ANGLE = 2;

    public SGLabel(String id, String lbl, Point2D.Double loc) {
        this(id, lbl, 0.12, loc, 2, 0);
    }

    public SGLabel(String id, String lbl, double hgt, Point2D.Double loc, int valign, int halign) {
        if (PaneProxy.Java2D) {
            this.proxy_ = new LabelDrawer2D(lbl, hgt, loc, valign, halign);
        }
        this.ident_ = id;
        this.proxy_.setOrientation(0);
        this.proxy_.setAngle(0.0);
        this.proxy_.setColor(null);
        this.proxy_.setFont(new Font("Arial", 1, 14));
        this.selected_ = false;
        this.selectable_ = true;
        this.proxy_.setVisible(true);
        this.moveable_ = true;
    }

    @Override
    public LayerChild copy() {
        SGLabel newLabel;
        try {
            newLabel = (SGLabel)this.clone();
        }
        catch (CloneNotSupportedException e) {
            newLabel = new SGLabel(this.ident_, this.proxy_.getText(), this.proxy_.getHeightP(), this.proxy_.getLocationP(), this.proxy_.getVAlign(), this.proxy_.getHAlign());
            newLabel.setColor(this.proxy_.getColor());
            newLabel.setFont(this.proxy_.getFont());
            if (this.proxy_.getOrientation() == 2) {
                newLabel.setAngle(this.proxy_.getAngle());
            }
            newLabel.setOrientation(this.proxy_.getOrientation());
        }
        return newLabel;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof SGLabel)) {
            return false;
        }
        SGLabel sg = (SGLabel)obj;
        if (!this.ident_.equals(sg.getId()) || !this.proxy_.getText().equals(sg.getText()) || this.proxy_.getHeightP() != sg.getHeightP() || !this.proxy_.getLocationP().equals(sg.getLocationP()) || this.proxy_.getVAlign() != sg.getVAlign() || this.proxy_.getHAlign() != sg.getHAlign() || this.proxy_.getColor() != null && !this.proxy_.getColor().equals(sg.getColor()) || this.proxy_.getFont() != null && !this.proxy_.getFont().equals(sg.getFont()) || this.proxy_.getOrientation() != sg.getOrientation()) {
            return false;
        }
        return this.proxy_.getOrientation() != 2 || this.proxy_.getAngle() == sg.getAngle();
    }

    @Override
    public void draw(VectorGraphics g) throws LayerNotFoundException {
        this.proxy_.draw(g);
    }

    @Override
    public void setSelected(boolean sel) {
        this.selected_ = sel;
    }

    @Override
    public boolean isSelected() {
        return this.selected_;
    }

    @Override
    public void setSelectable(boolean select) {
        this.selectable_ = select;
    }

    @Override
    public boolean isSelectable() {
        return this.selectable_;
    }

    public void setColor(Color color) {
        Color clr = this.proxy_.getColor();
        if (clr == null || !clr.equals(color)) {
            this.proxy_.setColor(color);
            this.modified("SGLabel: setColor()");
        }
    }

    public Color getColor() {
        return this.proxy_.getColor();
    }

    public void setFont(Font fnt) {
        Font font = this.proxy_.getFont();
        if (font == null || !font.equals(fnt)) {
            this.proxy_.setFont(fnt);
            this.modified("SGLabel: setFont()");
        }
    }

    public Font getFont() {
        return this.proxy_.getFont();
    }

    public void setHeightP(double hgt) {
        double height = this.proxy_.getHeightP();
        if (height != hgt) {
            this.proxy_.setHeightP(hgt);
            this.modified("SGLabel: setHeightP()");
        }
    }

    public double getHeightP() {
        return this.proxy_.getHeightP();
    }

    public void setAlign(int vert, int horz) {
        int valign = this.proxy_.getVAlign();
        int halign = this.proxy_.getHAlign();
        if (valign != vert || halign != horz) {
            this.proxy_.setVAlign(vert);
            this.proxy_.setHAlign(horz);
            this.modified("SGLabel: setAlign()");
        }
    }

    public void setHAlign(int horz) {
        int halign = this.proxy_.getHAlign();
        if (halign != horz) {
            this.proxy_.setHAlign(horz);
            this.modified("SGLabeo: setHAlign()");
        }
    }

    public int getHAlign() {
        return this.proxy_.getHAlign();
    }

    public void setVAlign(int vert) {
        int valign = this.proxy_.getVAlign();
        if (valign != vert) {
            this.proxy_.setVAlign(vert);
            this.modified("SGLabel: setVAlign()");
        }
    }

    public int getVAlign() {
        return this.proxy_.getVAlign();
    }

    public void setLocationP(Point2D.Double loc) {
        Point2D.Double porigin = this.proxy_.getLocationP();
        if (porigin == null || !porigin.equals(loc)) {
            Point2D.Double temp = porigin;
            porigin = loc;
            this.proxy_.setLocationP(loc);
            if (this.changes_ == null) {
                this.changes_ = new PropertyChangeSupport(this);
            }
            this.changes_.firePropertyChange("location", temp, porigin);
            this.modified("SGLabel: setLocationP()");
        }
    }

    public Point2D.Double getLocationP() {
        return this.proxy_.getLocationP();
    }

    public void setOrientation(int orient) {
        int or = this.proxy_.getOrientation();
        if (or != orient) {
            this.proxy_.setOrientation(orient);
            this.modified("SGLabel: setOrientation()");
        }
    }

    public int getOrientation() {
        return this.proxy_.getOrientation();
    }

    public void setAngle(double angle) {
        this.proxy_.setAngle(angle);
    }

    public double getAngle() {
        return this.proxy_.getAngle();
    }

    @Override
    public void setLayer(Layer l) {
        this.proxy_.setLayer(l);
    }

    @Override
    public Layer getLayer() {
        return this.proxy_.getLayer();
    }

    @Override
    public AbstractPane getPane() {
        return this.proxy_.getLayer().getPane();
    }

    @Override
    public void modified(String text) {
        Layer layer = this.proxy_.getLayer();
        if (layer != null) {
            layer.modified(text);
        }
    }

    public String getText() {
        return this.proxy_.getText();
    }

    public void setText(String lbl) {
        String label = this.proxy_.getText();
        if (label == null || !label.equals(lbl)) {
            this.proxy_.setText(lbl);
            this.modified("SGLabel: setText()");
        }
    }

    @Override
    public String getId() {
        return this.ident_;
    }

    @Override
    public void setId(String id) {
        this.ident_ = id;
    }

    public int getHeight() {
        return 0;
    }

    @Override
    public Point getLocation() {
        return this.proxy_.getLocation();
    }

    @Override
    public void setLocation(Point loc) {
        Point dloc = this.proxy_.getLocation();
        if (dloc.x != loc.x || dloc.y != loc.y) {
            Point temp = new Point(dloc.x, dloc.y);
            this.proxy_.setLocation(loc);
            if (this.changes_ == null) {
                this.changes_ = new PropertyChangeSupport(this);
            }
            this.changes_.firePropertyChange("location", temp, loc);
        }
    }

    public Rectangle2D.Double getBoundsP() {
        return this.proxy_.getBoundsP();
    }

    @Override
    public Rectangle getBounds() {
        return this.proxy_.getBounds();
    }

    public void setBounds(Rectangle r) {
        this.setBounds(r.x, r.y, r.width, r.height);
    }

    public void setBounds(int x, int y, int width, int height) {
        this.proxy_.setBounds(x, y, width, height);
    }

    @Override
    public String toString() {
        String name = this.getClass().getName();
        return name.substring(name.lastIndexOf(".") + 1) + ": " + this.ident_;
    }

    @Override
    public boolean isVisible() {
        return this.proxy_.isVisible();
    }

    @Override
    public void setVisible(boolean visible) {
        boolean vis = this.proxy_.isVisible();
        if (vis != visible) {
            this.proxy_.setVisible(visible);
            this.modified("SGLabel: setVisible()");
        }
    }

    @Override
    public boolean isMoveable() {
        return this.moveable_;
    }

    @Override
    public void setMoveable(boolean moveable) {
        if (this.moveable_ != moveable) {
            this.moveable_ = moveable;
            this.modified("SGLabel: setMoveable()");
        }
    }

    public float getStringWidth(VectorGraphics g) {
        return this.proxy_.getStringWidth(g);
    }

    public float getStringHeight(VectorGraphics g) {
        return this.proxy_.getStringHeight(g);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        if (this.changes_ == null) {
            this.changes_ = new PropertyChangeSupport(this);
        }
        this.changes_.addPropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.changes_.removePropertyChangeListener(l);
    }

    static {
        try {
            BeanInfo info = Introspector.getBeanInfo(SGLabel.class);
            PropertyDescriptor[] descriptors = info.getPropertyDescriptors();
            for (int i = 0; i < descriptors.length; ++i) {
                PropertyDescriptor pd = descriptors[i];
                if (!pd.getName().equals("layer")) continue;
                pd.setValue("transient", Boolean.TRUE);
            }
        }
        catch (IntrospectionException ie) {
            ie.printStackTrace();
        }
    }
}

