/*
 * Decompiled with CFR 0.152.
 */
package sgtplot;

import java.awt.Color;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import sgtplot.Attribute;
import sgtplot.AttributeChangeEvent;

public class LineAttribute
implements Attribute,
Cloneable {
    protected transient PropertyChangeSupport changes_ = new PropertyChangeSupport(this);
    private boolean batch_ = false;
    private boolean local_ = true;
    private boolean modified_ = false;
    private String id_ = null;
    private Color color_ = Color.black;
    private int style_;
    private int mark_ = 1;
    private double markHeightP_ = 0.2;
    private float width_ = 2.0f;
    private float[] dashes_ = new float[]{12.0f, 12.0f};
    private float dashPhase_ = 0.0f;
    private int cap_style_ = 2;
    private int miter_style_ = 0;
    private float miter_limit_ = 10.0f;
    private static float HEAVY_WIDTH = 2.0f;
    public static final int SOLID = 0;
    public static final int DASHED = 1;
    public static final int HEAVY = 2;
    public static final int HIGHLIGHT = 3;
    public static final int MARK = 4;
    public static final int MARK_LINE = 5;
    public static final int STROKE = 6;
    public static final int CAP_BUTT = 0;
    public static final int CAP_ROUND = 1;
    public static final int CAP_SQUARE = 2;
    public static final int JOIN_MITER = 0;
    public static final int JOIN_ROUND = 1;
    public static final int JOIN_BEVEL = 2;

    public LineAttribute() {
        this(0, Color.red);
    }

    public LineAttribute(int style) {
        this.style_ = style;
        if (this.style_ == 2) {
            this.width_ = HEAVY_WIDTH;
        }
    }

    public LineAttribute(int style, Color color) {
        this(style, 1, color);
    }

    public LineAttribute(int style, int mark, Color color) {
        this.style_ = style;
        this.mark_ = mark;
        this.color_ = color;
    }

    public Object copy() {
        LineAttribute newLine;
        try {
            newLine = (LineAttribute)this.clone();
        }
        catch (CloneNotSupportedException e) {
            newLine = new LineAttribute();
        }
        return newLine;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof LineAttribute)) {
            return false;
        }
        LineAttribute attr = (LineAttribute)obj;
        if (this.id_ != attr.getId() || !this.color_.equals(attr.getColor()) || this.style_ != attr.getStyle()) {
            return false;
        }
        if (!(this.style_ != 4 && this.style_ != 5 || this.mark_ == attr.getMark() && this.markHeightP_ == attr.getMarkHeightP())) {
            return false;
        }
        if (this.style_ == 2 && this.width_ != attr.getWidth()) {
            return false;
        }
        if (this.style_ == 6) {
            if (this.width_ != attr.getWidth()) {
                return false;
            }
            if (this.dashes_.length != attr.getDashArray().length) {
                return false;
            }
            float[] dar = attr.getDashArray();
            for (int i = 0; i < this.dashes_.length; ++i) {
                if (this.dashes_[i] == dar[i]) continue;
                return false;
            }
            if (this.dashPhase_ != attr.getDashPhase() || this.cap_style_ != attr.getCapStyle() || this.miter_style_ != attr.getMiterStyle() || this.miter_limit_ != attr.getMiterLimit()) {
                return false;
            }
        }
        return true;
    }

    public void setMarkHeightP(double markh) {
        if (this.markHeightP_ != markh) {
            Double tempOld = new Double(this.markHeightP_);
            this.markHeightP_ = markh;
            this.firePropertyChange("markHeightP", tempOld, new Double(this.markHeightP_));
        }
    }

    public double getMarkHeightP() {
        return this.markHeightP_;
    }

    public void setStyle(int st) {
        if (this.style_ != st) {
            Integer tempOld = new Integer(this.style_);
            this.style_ = st;
            this.firePropertyChange("style", tempOld, new Integer(this.style_));
        }
    }

    public void setColor(Color c) {
        if (!this.color_.equals(c)) {
            Color tempOld = this.color_;
            this.color_ = c;
            this.firePropertyChange("color", tempOld, this.color_);
        }
    }

    public void setWidth(float t) {
        if (this.width_ != t) {
            Float tempOld = new Float(this.width_);
            this.width_ = t;
            this.firePropertyChange("width", tempOld, new Float(this.width_));
        }
    }

    public void setDashArray(float[] dashes) {
        if (dashes == null) {
            return;
        }
        boolean changed = false;
        if (this.dashes_.length != dashes.length) {
            changed = true;
        } else {
            for (int i = 0; i < this.dashes_.length; ++i) {
                if (this.dashes_[i] == dashes[i]) continue;
                changed = true;
                break;
            }
        }
        if (changed) {
            float[] tempOld = this.dashes_;
            this.dashes_ = dashes;
            this.firePropertyChange("dashArray", tempOld, this.dashes_);
        }
    }

    public float[] getDashArray() {
        return this.dashes_;
    }

    public void setDashPhase(float phase) {
        if (this.dashPhase_ != phase) {
            Float tempOld = new Float(this.dashPhase_);
            this.dashPhase_ = phase;
            this.firePropertyChange("dashPhase", tempOld, new Float(this.dashPhase_));
        }
    }

    public float getDashPhase() {
        return this.dashPhase_;
    }

    public int getStyle() {
        return this.style_;
    }

    public Color getColor() {
        return this.color_;
    }

    public float getWidth() {
        return this.width_;
    }

    public void setMark(int mark) {
        if (this.mark_ != mark) {
            Integer tempOld = new Integer(this.mark_);
            if (mark <= 0) {
                mark = 1;
            }
            if (mark > 51) {
                mark = 51;
            }
            this.mark_ = mark;
            this.firePropertyChange("mark", tempOld, new Integer(this.mark_));
        }
    }

    public int getMark() {
        return this.mark_;
    }

    public void setCapStyle(int style) {
        if (this.cap_style_ != style) {
            Integer tempOld = new Integer(this.cap_style_);
            this.cap_style_ = style;
            this.firePropertyChange("capStyle", tempOld, new Integer(this.cap_style_));
        }
    }

    public int getCapStyle() {
        return this.cap_style_;
    }

    public void setMiterStyle(int style) {
        if (this.miter_style_ != style) {
            Integer tempOld = new Integer(this.miter_style_);
            this.miter_style_ = style;
            this.firePropertyChange("miterStyle", tempOld, new Integer(this.miter_style_));
        }
    }

    public int getMiterStyle() {
        return this.miter_style_;
    }

    public void setMiterLimit(float limit) {
        if (this.miter_limit_ != limit) {
            Float tempOld = new Float(this.miter_limit_);
            this.miter_limit_ = limit;
            this.firePropertyChange("miterLimit", tempOld, new Float(this.miter_limit_));
        }
    }

    public float getMiterLimit() {
        return this.miter_limit_;
    }

    @Override
    public String toString() {
        String name = this.getClass().getName();
        return name.substring(name.lastIndexOf(".") + 1);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.changes_ == null) {
            this.changes_ = new PropertyChangeSupport(this);
        }
        this.changes_.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changes_.removePropertyChangeListener(listener);
    }

    @Override
    public void setId(String id) {
        this.id_ = id;
    }

    @Override
    public String getId() {
        return this.id_;
    }

    protected void firePropertyChange(String name, Object oldValue, Object newValue) {
        if (this.batch_) {
            this.modified_ = true;
            return;
        }
        AttributeChangeEvent ace = new AttributeChangeEvent(this, name, oldValue, newValue, this.local_);
        this.changes_.firePropertyChange(ace);
        this.modified_ = false;
    }

    @Override
    public void setBatch(boolean batch) {
        this.setBatch(batch, true);
    }

    @Override
    public void setBatch(boolean batch, boolean local) {
        this.local_ = local;
        this.batch_ = batch;
        if (!batch && this.modified_) {
            this.firePropertyChange("batch", Boolean.TRUE, Boolean.FALSE);
        }
    }

    @Override
    public boolean isBatch() {
        return this.batch_;
    }
}

