/*
 * Decompiled with CFR 0.152.
 */
package sgtplot;

import java.awt.Point;
import java.beans.PropertyChangeListener;
import org.freehep.graphics2d.VectorGraphics;
import sgtplot.AbstractPane;
import sgtplot.Layer;
import sgtplot.dm.SGTData;
import sgtplot.util.Range2D;
import sgtplot.util.SoTRange;

public abstract class Graph
implements PropertyChangeListener {
    private String ident_;
    protected Layer layer_;

    public Graph() {
        this("");
    }

    public Graph(String id) {
        this.ident_ = id;
    }

    public abstract Graph copy();

    public String getId() {
        return this.ident_;
    }

    abstract void draw(VectorGraphics var1);

    void setLayer(Layer l) {
        this.layer_ = l;
    }

    public Layer getLayer() {
        return this.layer_;
    }

    public AbstractPane getPane() {
        return this.layer_.getPane();
    }

    public void modified(String mess) {
        if (this.layer_ != null) {
            this.layer_.modified(mess);
        }
    }

    public static Range2D computeRange(Range2D range, int num) {
        return Graph.computeRange(range.start, range.end, num);
    }

    public static SoTRange computeRange(SoTRange range, int num) {
        if (!range.isTime()) {
            SoTRange.Double drange = (SoTRange.Double)range;
            return new SoTRange.Double(Graph.computeRange(drange.start, drange.end, num));
        }
        return null;
    }

    public static Range2D computeRange(double min, double max, int num) {
        double pow;
        double temp;
        int interval = Math.abs(num);
        boolean reversed = false;
        if (min == max) {
            if (min == 0.0) {
                min = -1.0;
                max = 1.0;
            } else {
                min = 0.9 * max;
                max = 1.1 * max;
            }
        }
        if (min > max) {
            temp = min;
            min = max;
            max = temp;
            reversed = true;
        }
        if (interval == 0) {
            interval = 1;
        }
        if ((temp = (max - min) / (double)interval) == 0.0) {
            temp = max;
        }
        if (temp == 0.0) {
            min = -1.0;
            max = 1.0;
            temp = 2.0 / (double)interval;
        }
        int nt = (int)Graph.log10(temp);
        if (temp < 1.0) {
            --nt;
        }
        double delta = (temp /= (pow = Math.pow(10.0, nt))) < 1.414213562 ? pow : (temp < 3.16227766 ? 2.0 * pow : (temp < 7.071067812 ? 5.0 * pow : 10.0 * pow));
        temp = min / delta;
        nt = (int)temp;
        if (temp < 0.0) {
            --nt;
        }
        min = delta * (double)nt;
        temp = max / delta;
        nt = (int)temp;
        if (temp > 0.0) {
            ++nt;
        }
        max = delta * (double)nt;
        if (reversed) {
            temp = min;
            min = max;
            max = temp;
            delta = -delta;
        }
        return new Range2D(min, max, delta);
    }

    static final double log10(double x) {
        return 0.4342944819 * Math.log(x);
    }

    abstract Object getObjectAt(Point var1);

    public String toString() {
        String name = this.getClass().getName();
        return name.substring(name.lastIndexOf(".") + 1) + ": " + this.ident_;
    }

    public abstract SGTData getDataAt(Point var1);
}

