/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.plot.demo;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import ptolemy.plot.Plot;

public class TwoPlotExample
extends JFrame {
    TwoPlotExample() {
        Plot leftPlot = new Plot();
        Plot rightPlot = new Plot();
        this.setSize(800, 300);
        leftPlot.setSize(350, 300);
        leftPlot.setButtons(true);
        leftPlot.setTitle("Left Plot");
        leftPlot.setYRange(-4.0, 4.0);
        leftPlot.setXRange(0.0, 100.0);
        leftPlot.setXLabel("time");
        leftPlot.setYLabel("value");
        leftPlot.addYTick("-PI", -Math.PI);
        leftPlot.addYTick("-PI/2", -1.5707963267948966);
        leftPlot.addYTick("0", 0.0);
        leftPlot.addYTick("PI/2", 1.5707963267948966);
        leftPlot.addYTick("PI", Math.PI);
        leftPlot.setMarksStyle("none");
        leftPlot.setImpulses(true);
        leftPlot.setConnected(false, 1);
        boolean first = true;
        for (int i = 0; i <= 100; ++i) {
            leftPlot.addPoint(0, i, 5.0 * Math.cos(Math.PI * (double)i / 20.0), !first);
            leftPlot.addPoint(1, i, 4.5 * Math.cos(Math.PI * (double)i / 25.0), !first);
            leftPlot.addPoint(2, i, 4.0 * Math.cos(Math.PI * (double)i / 30.0), !first);
            leftPlot.addPoint(3, i, 3.5 * Math.cos(Math.PI * (double)i / 35.0), !first);
            leftPlot.addPoint(4, i, 3.0 * Math.cos(Math.PI * (double)i / 40.0), !first);
            leftPlot.addPoint(5, i, 2.5 * Math.cos(Math.PI * (double)i / 45.0), !first);
            leftPlot.addPoint(6, i, 2.0 * Math.cos(Math.PI * (double)i / 50.0), !first);
            leftPlot.addPoint(7, i, 1.5 * Math.cos(Math.PI * (double)i / 55.0), !first);
            leftPlot.addPoint(8, i, 1.0 * Math.cos(Math.PI * (double)i / 60.0), !first);
            leftPlot.addPoint(9, i, 0.5 * Math.cos(Math.PI * (double)i / 65.0), !first);
            first = false;
        }
        rightPlot.setButtons(true);
        leftPlot.setSize(350, 300);
        File file = new File(".", "data.plt");
        try {
            rightPlot.clear(true);
            rightPlot.read(new FileInputStream(file));
        }
        catch (FileNotFoundException ex) {
            System.err.println("File not found: " + file + " : " + ex);
        }
        catch (IOException ex) {
            System.err.println("Error reading input: " + file + " : " + ex);
        }
        rightPlot.setTitle("Right Plot");
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.getContentPane().setLayout(gridbag);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        gridbag.setConstraints(leftPlot, c);
        this.getContentPane().add(leftPlot);
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 1;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        gridbag.setConstraints(rightPlot, c);
        this.getContentPane().add(rightPlot);
        this.setVisible(true);
    }

    public static void main(String[] args) {
        Runnable doAction = new Runnable(){

            @Override
            public void run() {
                new TwoPlotExample();
            }
        };
        SwingUtilities.invokeLater(doAction);
    }
}

