/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.misc.test;

import java.util.Map;
import org.clapper.util.cmdline.CommandLineException;
import org.clapper.util.cmdline.CommandLineUsageException;
import org.clapper.util.cmdline.CommandLineUtility;
import org.clapper.util.misc.PropertiesMap;
import org.clapper.util.text.XStringBuffer;

public class TestPropertiesMap
extends CommandLineUtility {
    public boolean useEnvironment = false;

    public static void main(String[] args) {
        TestPropertiesMap tester = new TestPropertiesMap();
        try {
            tester.execute(args);
        }
        catch (CommandLineUsageException ex) {
            System.exit(1);
        }
        catch (CommandLineException ex) {
            System.err.println(ex.getMessage());
            ex.printStackTrace();
            System.exit(1);
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            System.exit(1);
        }
    }

    private TestPropertiesMap() {
    }

    @Override
    protected void runCommand() throws CommandLineException {
        try {
            this.runTest();
        }
        catch (Exception ex) {
            throw new CommandLineException(ex);
        }
    }

    private void runTest() {
        PropertiesMap map = new PropertiesMap(System.getProperties());
        XStringBuffer buf = new XStringBuffer();
        System.out.println("------------------------------------------------------------------------------");
        System.out.println("*** Looping over properties by key set.");
        System.out.println("------------------------------------------------------------------------------");
        for (String string : map.keySet()) {
            buf.clear();
            buf.append(map.get(string));
            buf.encodeMetacharacters();
            System.out.println(string + "=" + buf.toString());
        }
        System.out.println("------------------------------------------------------------------------------");
        System.out.println("*** Looping over properties by entry set.");
        System.out.println("------------------------------------------------------------------------------");
        for (Map.Entry entry : map.entrySet()) {
            buf.clear();
            buf.append((String)entry.getValue());
            buf.encodeMetacharacters();
            System.out.println((String)entry.getKey() + "=" + buf.toString());
        }
    }
}

