/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.misc.test;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.clapper.util.cmdline.CommandLineException;
import org.clapper.util.cmdline.CommandLineUsageException;
import org.clapper.util.cmdline.CommandLineUtility;
import org.clapper.util.cmdline.UsageInfo;
import org.clapper.util.misc.MIMETypeUtil;

public class TestMIMEType
extends CommandLineUtility {
    private Collection<String> arguments = new ArrayList<String>();

    public static void main(String[] args) {
        TestMIMEType tester = new TestMIMEType();
        try {
            tester.execute(args);
        }
        catch (CommandLineUsageException ex) {
            System.exit(1);
        }
        catch (CommandLineException ex) {
            System.err.println(ex.getMessage());
            ex.printStackTrace();
            System.exit(1);
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            System.exit(1);
        }
    }

    private TestMIMEType() {
    }

    @Override
    protected void runCommand() throws CommandLineException {
        for (String arg : this.arguments) {
            String ext;
            String fileName;
            String mimeType;
            File f = new File(arg);
            System.out.println();
            if (f.exists()) {
                System.out.println("File name:                " + arg);
                mimeType = MIMETypeUtil.MIMETypeForFileName(arg);
                fileName = arg;
                ext = MIMETypeUtil.fileExtensionForMIMEType(mimeType);
            } else {
                mimeType = arg;
                ext = MIMETypeUtil.fileExtensionForMIMEType(mimeType);
                fileName = "test." + ext;
            }
            String mimeType2 = MIMETypeUtil.MIMETypeForFileName(fileName);
            System.out.println("MIME type:                " + mimeType);
            System.out.println("Extension:                " + ext);
            System.out.println("Mapped back to MIME type: " + mimeType2);
        }
    }

    @Override
    protected void parseCustomOption(char shortOption, String longOption, Iterator<String> it) throws CommandLineUsageException, NoSuchElementException {
        throw new CommandLineUsageException("Unrecognized option");
    }

    @Override
    protected void processPostOptionCommandLine(Iterator<String> it) throws CommandLineUsageException, NoSuchElementException {
        do {
            this.arguments.add(it.next());
        } while (it.hasNext());
    }

    @Override
    protected void getCustomUsageInfo(UsageInfo info) {
        info.addParameter("mimeType|filename ...", "A MIME or file name type to test. May be specified multiple times.", true);
    }
}

