/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.misc;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.net.FileNameMap;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.clapper.util.io.FileUtil;
import org.clapper.util.logging.Logger;
import org.clapper.util.text.TextUtil;

public class MIMETypeUtil {
    public static final String DEFAULT_MIME_TYPE = "application/octet-stream";
    private static final String MIME_MAPPINGS_BUNDLE = "org.clapper.util.misc.MIMETypes";
    private static Map<String, String> mimeTypeToExtensionMap = null;
    private static Map<String, String> extensionToMIMETypeMap = null;
    private static final Logger log = new Logger(MIMETypeUtil.class);

    private MIMETypeUtil() {
    }

    public static String fileExtensionForMIMEType(String mimeType) {
        MIMETypeUtil.loadMappings();
        String ext = mimeTypeToExtensionMap.get(mimeType);
        if (ext == null) {
            ext = "dat";
        }
        return ext;
    }

    public static String MIMETypeForFileExtension(String extension) {
        return MIMETypeUtil.MIMETypeForFileExtension(extension, DEFAULT_MIME_TYPE);
    }

    public static String MIMETypeForFileExtension(String extension, String defaultMIMEType) {
        return MIMETypeUtil.MIMETypeForFileName("test." + extension, defaultMIMEType);
    }

    public static String MIMETypeForFile(File file) {
        return MIMETypeUtil.MIMETypeForFileName(file.getName(), DEFAULT_MIME_TYPE);
    }

    public static String MIMETypeForFile(File file, String defaultMIMEType) {
        return MIMETypeUtil.MIMETypeForFileName(file.getName(), defaultMIMEType);
    }

    public static String MIMETypeForFileName(String fileName) {
        return MIMETypeUtil.MIMETypeForFileName(fileName, DEFAULT_MIME_TYPE);
    }

    public static String MIMETypeForFileName(String fileName, String defaultMIMEType) {
        String mimeType = null;
        FileNameMap fileNameMap = URLConnection.getFileNameMap();
        MIMETypeUtil.loadMappings();
        String extension = FileUtil.getFileNameExtension(fileName);
        mimeType = extensionToMIMETypeMap.get(extension);
        if (mimeType == null) {
            mimeType = fileNameMap.getContentTypeFor(fileName);
        }
        if (mimeType != null) {
            if (mimeType.equals(DEFAULT_MIME_TYPE) && defaultMIMEType != null) {
                mimeType = defaultMIMEType;
            }
        } else {
            mimeType = defaultMIMEType == null ? DEFAULT_MIME_TYPE : defaultMIMEType;
        }
        return mimeType;
    }

    public static void parseContentTypeHeader(String contentTypeHeader, StringBuffer mimeType, Map<String, String> parameters) {
        if (!(mimeType == null && parameters == null || TextUtil.stringIsEmpty(contentTypeHeader))) {
            if (mimeType == null) {
                mimeType = new StringBuffer();
            }
            if (parameters == null) {
                parameters = new HashMap<String, String>();
            }
            String[] tokens = TextUtil.split(contentTypeHeader, " ;");
            mimeType.setLength(0);
            mimeType.append(tokens[0]);
            parameters.clear();
            for (int i = 1; i < tokens.length; ++i) {
                String[] nv = TextUtil.split(tokens[i], "=");
                parameters.put(nv[0], nv.length == 1 ? "" : nv[1]);
            }
        }
    }

    private static synchronized void loadMappings() {
        int i;
        if (mimeTypeToExtensionMap != null) {
            return;
        }
        mimeTypeToExtensionMap = new HashMap<String, String>();
        extensionToMIMETypeMap = new HashMap<String, String>();
        String fileSep = System.getProperty("file.separator");
        StringBuffer buf = new StringBuffer();
        buf.append(System.getProperty("user.home"));
        buf.append(fileSep);
        buf.append(".mime.types");
        MIMETypeUtil.loadMIMETypesFile(buf.toString());
        String pathSep = System.getProperty("path.separator");
        String classPath = System.getProperty("java.class.path");
        String[] pathComponents = TextUtil.split(classPath, pathSep);
        for (i = 0; i < pathComponents.length; ++i) {
            buf.setLength(0);
            buf.append(pathComponents[i]);
            buf.append(fileSep);
            buf.append("mime.types");
            MIMETypeUtil.loadMIMETypesFile(buf.toString());
        }
        ResourceBundle bundle = ResourceBundle.getBundle(MIME_MAPPINGS_BUNDLE);
        Enumeration<String> e = bundle.getKeys();
        while (e.hasMoreElements()) {
            String type = e.nextElement();
            try {
                String[] extensions = TextUtil.split(bundle.getString(type));
                if (mimeTypeToExtensionMap.get(type) == null) {
                    log.debug("Internal: " + type + " -> \"" + extensions[0] + "\"");
                    mimeTypeToExtensionMap.put(type, extensions[0]);
                }
                for (i = 0; i < extensions.length; ++i) {
                    if (extensionToMIMETypeMap.get(extensions[i]) != null) continue;
                    log.debug("Internal: \"" + extensions[i] + "\" -> " + type);
                    extensionToMIMETypeMap.put(extensions[i], type);
                }
            }
            catch (MissingResourceException ex) {
                log.error("While reading internal bundle \"org.clapper.util.misc.MIMETypes\", got unexpected error on key \"" + type + "\"", ex);
            }
        }
    }

    private static void loadMIMETypesFile(String path) {
        try {
            File f = new File(path);
            log.debug("Attempting to load MIME types file \"" + path + "\"");
            if (!f.exists() || !f.isFile()) {
                log.debug("Regular file \"" + path + "\" does not exist.");
            } else {
                String line;
                LineNumberReader r = new LineNumberReader(new FileReader(f));
                while ((line = r.readLine()) != null) {
                    String mimeType;
                    String[] fields;
                    if ((line = line.trim()).length() == 0 || line.startsWith("#") || (fields = TextUtil.split(line)).length < 2) continue;
                    ArrayList<String> extensions = new ArrayList<String>();
                    for (int i = 1; i < fields.length; ++i) {
                        if (fields[i].indexOf(61) != -1 || fields[i].indexOf(34) != -1) continue;
                        if (fields[i].startsWith(".")) {
                            if (fields[i].length() == 1) continue;
                            fields[i] = fields[i].substring(1);
                        }
                        extensions.add(fields[i]);
                    }
                    if (extensions.size() == 0 || (mimeType = fields[0]).indexOf(47) == -1) continue;
                    if (mimeTypeToExtensionMap.get(mimeType) == null) {
                        String extension = (String)extensions.get(0);
                        log.debug("File \"" + path + "\": " + mimeType + " -> \"" + extension + "\"");
                        mimeTypeToExtensionMap.put(mimeType, extension);
                    }
                    for (String extension : extensions) {
                        if (extensionToMIMETypeMap.get(extension) != null) continue;
                        log.debug("File \"" + path + "\": \"" + extension + "\" -> " + mimeType);
                        extensionToMIMETypeMap.put(extension, mimeType);
                    }
                }
                r.close();
            }
        }
        catch (IOException ex) {
            log.debug("Error reading \"" + path + "\"", ex);
        }
    }
}

