/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.config;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.clapper.util.config.ConfigurationException;
import org.clapper.util.config.EnvSection;
import org.clapper.util.config.NoSuchSectionException;
import org.clapper.util.config.NoSuchVariableException;
import org.clapper.util.config.ProgramSection;
import org.clapper.util.config.Section;
import org.clapper.util.config.SectionExistsException;
import org.clapper.util.config.SystemSection;
import org.clapper.util.config.ValueSegment;
import org.clapper.util.config.Variable;
import org.clapper.util.io.FileUtil;
import org.clapper.util.logging.Logger;
import org.clapper.util.text.TextUtil;
import org.clapper.util.text.UnixShellVariableSubstituter;
import org.clapper.util.text.VariableDereferencer;
import org.clapper.util.text.VariableNameChecker;
import org.clapper.util.text.VariableSubstituter;
import org.clapper.util.text.VariableSubstitutionException;
import org.clapper.util.text.XStringBuffer;

public class Configuration
implements VariableDereferencer,
VariableNameChecker {
    private static final String COMMENT_CHARS = "#!";
    private static final char SECTION_START = '[';
    private static final char SECTION_END = ']';
    private static final String INCLUDE = "%include";
    private static final int MAX_INCLUDE_NESTING_LEVEL = 50;
    private static final String SYSTEM_SECTION_NAME = "system";
    private static final String PROGRAM_SECTION_NAME = "program";
    private static final String ENV_SECTION_NAME = "env";
    private static final int SYSTEM_SECTION_ID = 0;
    private static final int PROGRAM_SECTION_ID = 1;
    private static final int ENV_SECTION_ID = 2;
    private static final int FIRST_CONFIG_SECTION_ID = 3;
    private URL configURL = null;
    private List<Section> sectionsInOrder = new ArrayList<Section>();
    private Map<String, Section> sectionsByName = new HashMap<String, Section>();
    private static Section systemSection;
    private Section programSection;
    private Section envSection;
    private int nextSectionIDValue = 3;
    private static final Logger log;
    private boolean abortOnUndefinedVariable = true;
    private UnixShellVariableSubstituter varSubstituter = new UnixShellVariableSubstituter();

    public void addSection(String sectionName) throws SectionExistsException {
        if (this.sectionsByName.get(sectionName) != null) {
            throw new SectionExistsException(sectionName);
        }
        this.makeNewSection(sectionName);
    }

    public void clear() {
        this.sectionsInOrder.clear();
        this.sectionsByName.clear();
        this.configURL = null;
    }

    public final boolean containsSection(String sectionName) {
        return this.sectionsByName.get(sectionName) != null;
    }

    public URL getConfigurationFileURL() {
        return this.configURL;
    }

    public Collection<String> getSectionNames(Collection<String> collection) {
        for (Section section : this.sectionsInOrder) {
            collection.add(section.getName());
        }
        return collection;
    }

    public Collection<String> getSectionNames() {
        return this.getSectionNames(new ArrayList<String>());
    }

    public Collection<String> getVariableNames(String sectionName, Collection<String> collection) throws NoSuchSectionException {
        Section section = this.sectionsByName.get(sectionName);
        if (section == null) {
            throw new NoSuchSectionException(sectionName);
        }
        collection.addAll(section.getVariableNames());
        return collection;
    }

    public Collection<String> getVariableNames(String sectionName) throws NoSuchSectionException {
        return this.getVariableNames(sectionName, new ArrayList<String>());
    }

    public String getConfigurationValue(String sectionName, String variableName) throws NoSuchSectionException, NoSuchVariableException {
        Section section = this.sectionsByName.get(sectionName);
        if (section == null) {
            throw new NoSuchSectionException(sectionName);
        }
        Variable variable = null;
        try {
            variable = section.getVariable(variableName);
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
        if (variable == null) {
            throw new NoSuchVariableException(sectionName, variableName);
        }
        return variable.getCookedValue();
    }

    public String getRawValue(String sectionName, String variableName) throws NoSuchSectionException, NoSuchVariableException {
        Section section = this.sectionsByName.get(sectionName);
        if (section == null) {
            throw new NoSuchSectionException(sectionName);
        }
        Variable variable = null;
        try {
            variable = section.getVariable(variableName);
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
        if (variable == null) {
            throw new NoSuchVariableException(sectionName, variableName);
        }
        return variable.getRawValue();
    }

    public String[] getConfigurationTokens(String sectionName, String variableName) throws ConfigurationException {
        Section section = this.sectionsByName.get(sectionName);
        if (section == null) {
            throw new NoSuchSectionException(sectionName);
        }
        Variable variable = null;
        try {
            variable = section.getVariable(variableName);
        }
        catch (ConfigurationException ex) {
            log.error("Can't get value for variable \"" + variableName + "\" in section \"" + sectionName + "\"", ex);
        }
        if (variable == null) {
            throw new NoSuchVariableException(sectionName, variableName);
        }
        ValueSegment[] cookedSegments = variable.getCookedSegments();
        ArrayList<String> result = new ArrayList<String>();
        if (cookedSegments != null) {
            for (ValueSegment segment : cookedSegments) {
                String[] tokens;
                String cookedToken = segment.toString();
                if (segment.isLiteral || segment.isWhiteSpaceEscaped) {
                    result.add(cookedToken);
                    continue;
                }
                for (String token : tokens = TextUtil.split(cookedToken)) {
                    result.add(token);
                }
            }
        }
        return result.toArray(new String[result.size()]);
    }

    public int getOptionalIntegerValue(String sectionName, String variableName, int defaultValue) throws ConfigurationException {
        int result = defaultValue;
        try {
            result = this.getRequiredIntegerValue(sectionName, variableName);
        }
        catch (NoSuchVariableException noSuchVariableException) {
            // empty catch block
        }
        return result;
    }

    public int getRequiredIntegerValue(String sectionName, String variableName) throws ConfigurationException {
        String sNum = this.getConfigurationValue(sectionName, variableName);
        try {
            return Integer.parseInt(sNum);
        }
        catch (NumberFormatException ex) {
            throw new ConfigurationException("org.clapper.util.config.Bundle", "Configuration.badNumericValue", "Bad numeric value \"{0}\" for variable \"{1}\" in section \"{2}\"", new Object[]{sNum, variableName, sectionName});
        }
    }

    public int getOptionalCardinalValue(String sectionName, String variableName, int defaultValue) throws ConfigurationException {
        assert (defaultValue >= 0);
        int result = defaultValue;
        try {
            result = this.getRequiredCardinalValue(sectionName, variableName);
        }
        catch (NoSuchVariableException noSuchVariableException) {
            // empty catch block
        }
        return result;
    }

    public int getRequiredCardinalValue(String sectionName, String variableName) throws ConfigurationException {
        String sNum = this.getConfigurationValue(sectionName, variableName);
        int i = this.getRequiredIntegerValue(sectionName, variableName);
        if (i < 0) {
            throw new ConfigurationException("org.clapper.util.config.Bundle", "Configuration.negativeCardinalValue", "Bad negative numeric value \"{0}\" for variable \"{1}\" in section \"{2}\"", new Object[]{sNum, variableName, sectionName});
        }
        return i;
    }

    public double getOptionalDoubleValue(String sectionName, String variableName, double defaultValue) throws ConfigurationException {
        double result = defaultValue;
        try {
            result = this.getRequiredDoubleValue(sectionName, variableName);
        }
        catch (NoSuchVariableException noSuchVariableException) {
            // empty catch block
        }
        return result;
    }

    public double getRequiredDoubleValue(String sectionName, String variableName) throws ConfigurationException {
        String sNum = this.getConfigurationValue(sectionName, variableName);
        try {
            return Double.parseDouble(sNum);
        }
        catch (NumberFormatException ex) {
            throw new ConfigurationException("org.clapper.util.config.Bundle", "Configuration.badFloatValue", "Bad floating point value \"{0}\" for variable \"{1}\" in section \"{2}\"", new Object[]{sNum, variableName, sectionName});
        }
    }

    public boolean getOptionalBooleanValue(String sectionName, String variableName, boolean defaultValue) throws ConfigurationException {
        boolean result;
        try {
            String s = this.getConfigurationValue(sectionName, variableName);
            result = TextUtil.stringIsEmpty(s) ? defaultValue : TextUtil.booleanFromString(s);
        }
        catch (NoSuchVariableException ex) {
            result = defaultValue;
        }
        catch (IllegalArgumentException ex) {
            throw new ConfigurationException(ex.getMessage());
        }
        return result;
    }

    public boolean getRequiredBooleanValue(String sectionName, String variableName) throws ConfigurationException {
        String val = this.getConfigurationValue(sectionName, variableName);
        try {
            return TextUtil.booleanFromString(val);
        }
        catch (IllegalArgumentException ex) {
            throw new ConfigurationException("org.clapper.util.config.Bundle", "Configuration.badBooleanValue", "Bad boolean value \"{0}\" for variable \"{1}\" in section \"{2}\".\n", new Object[]{val, variableName, sectionName});
        }
    }

    public String getOptionalStringValue(String sectionName, String variableName, String defaultValue) throws ConfigurationException {
        String result;
        try {
            result = this.getConfigurationValue(sectionName, variableName);
            if (TextUtil.stringIsEmpty(result)) {
                result = defaultValue;
            }
        }
        catch (NoSuchVariableException ex) {
            result = defaultValue;
        }
        return result;
    }

    @Override
    public String getVariableValue(String varName, Object context) throws VariableSubstitutionException {
        String sectionName;
        Section section;
        String value = null;
        SubstitutionContext substContext = (SubstitutionContext)context;
        try {
            this.checkVariableName(varName);
        }
        catch (ConfigurationException ex) {
            throw new VariableSubstitutionException(ex);
        }
        Variable currentVariable = substContext.currentVariable;
        if (currentVariable.getName().equals(varName)) {
            throw new VariableSubstitutionException("org.clapper.util.config.Bundle", "Configuration.recursiveSubst", "Attempt to substitute value for variable \"{0}\" within itself.", new Object[]{varName});
        }
        Section variableParentSection = substContext.currentVariable.getSection();
        int i = varName.indexOf(58);
        if (i == -1) {
            section = variableParentSection;
            sectionName = section.getName();
        } else {
            sectionName = varName.substring(0, i);
            varName = varName.substring(i + 1);
            section = sectionName.equals(SYSTEM_SECTION_NAME) ? systemSection : (sectionName.equals(PROGRAM_SECTION_NAME) ? this.programSection : (sectionName.equals(ENV_SECTION_NAME) ? this.envSection : this.sectionsByName.get(sectionName)));
        }
        if (section == null) {
            if (this.abortOnUndefinedVariable) {
                throw new VariableSubstitutionException("org.clapper.util.config.Bundle", "Configuration.nonExistentSection", "Reference to variable \"{0}\" in nonexistent section \"{1}\".", new Object[]{varName, sectionName});
            }
        } else {
            Variable varToSubst;
            if (variableParentSection.getID() < section.getID()) {
                String parentSectionName = variableParentSection.getName();
                String thisSectionName = section.getName();
                throw new VariableSubstitutionException("org.clapper.util.config.Bundle", "Configuration.badSectionRef", "Variable \"{0}\" in section \"{1}\" cannot substitute the value of variable \"{2}\" from section \"{3}\", because section \"{3}\" appears after section \"{1}\" in the configuration file.", new Object[]{substContext.currentVariable.getName(), parentSectionName, varName, thisSectionName, thisSectionName, parentSectionName});
            }
            try {
                varToSubst = section.getVariable(varName);
            }
            catch (ConfigurationException ex) {
                throw new VariableSubstitutionException(ex.getMessage());
            }
            if (varToSubst != null) {
                value = varToSubst.getCookedValue();
            }
        }
        ++substContext.totalSubstitutions;
        return value;
    }

    @Override
    public boolean legalVariableCharacter(char c) {
        return !UnixShellVariableSubstituter.isVariableMetacharacter(c);
    }

    public void load(File file) throws IOException, ConfigurationException {
        this.load(file, null);
    }

    public void load(File file, String encoding) throws IOException, ConfigurationException {
        this.clear();
        URL url = file.toURI().toURL();
        this.parse(new FileInputStream(file), encoding, url);
        this.configURL = url;
    }

    public void load(String path) throws IOException, ConfigurationException {
        this.load(path, null);
    }

    public void load(String path, String encoding) throws IOException, ConfigurationException {
        this.clear();
        URL url = new File(path).toURI().toURL();
        this.parse(new FileInputStream(path), encoding, url);
        this.configURL = url;
    }

    public void load(URL url) throws IOException, ConfigurationException {
        this.load(url, null);
    }

    public void load(URL url, String encoding) throws IOException, ConfigurationException {
        this.clear();
        this.parse(url.openStream(), encoding, url);
        this.configURL = url;
    }

    public void load(InputStream iStream) throws IOException, ConfigurationException {
        this.load(iStream, null);
    }

    public void load(InputStream iStream, String encoding) throws IOException, ConfigurationException {
        this.clear();
        this.parse(iStream, encoding, null);
    }

    public void setVariable(String sectionName, String variableName, String value, boolean expand) throws NoSuchSectionException, VariableSubstitutionException {
        Variable variable;
        Section section = this.sectionsByName.get(sectionName);
        if (section == null) {
            throw new NoSuchSectionException(sectionName);
        }
        try {
            variable = section.getVariable(variableName);
            if (variable != null) {
                variable.setValue(value);
            } else {
                variable = section.addVariable(variableName, value);
            }
        }
        catch (ConfigurationException ex) {
            throw new VariableSubstitutionException(ex.getMessage());
        }
        if (expand) {
            try {
                this.substituteVariables(variable, this.varSubstituter, true);
            }
            catch (ConfigurationException ex) {
                throw new VariableSubstitutionException(ex.getMessage());
            }
        }
    }

    public boolean getAbortOnUndefinedVariable() {
        return this.abortOnUndefinedVariable;
    }

    public void setAbortOnUndefinedVariable(boolean enable) {
        this.abortOnUndefinedVariable = enable;
        this.varSubstituter.setAbortOnUndefinedVariable(enable);
    }

    public void write(PrintWriter out) throws ConfigurationException {
        XStringBuffer value = new XStringBuffer();
        boolean firstSection = true;
        out.print(COMMENT_CHARS.charAt(0));
        out.print(" Written by ");
        out.println(this.getClass().getName());
        out.print(COMMENT_CHARS.charAt(0));
        out.print(" on ");
        out.println(new Date().toString());
        out.println();
        for (Section section : this.sectionsInOrder) {
            if (!firstSection) {
                out.println();
            }
            out.println('[' + section.getName() + ']');
            firstSection = false;
            for (String varName : section.getVariableNames()) {
                Variable var = section.getVariable(varName);
                value.setLength(0);
                value.append(var.getRawValue());
                out.println(varName + ": " + value.toString());
            }
        }
    }

    public void write(PrintStream out) throws ConfigurationException {
        PrintWriter w = new PrintWriter(out);
        this.write(w);
        w.flush();
    }

    private synchronized void parse(InputStream in, String encoding, URL url) throws ConfigurationException, UnsupportedEncodingException {
        this.loadConfiguration(in, encoding, url, new ParseContext());
    }

    private void loadConfiguration(InputStream in, String encoding, URL url, ParseContext parseContext) throws ConfigurationException, UnsupportedEncodingException {
        Line line = new Line();
        String sURL = url.toExternalForm();
        this.programSection = new ProgramSection(PROGRAM_SECTION_NAME, 1);
        systemSection = new SystemSection(SYSTEM_SECTION_NAME, 0);
        this.envSection = new EnvSection(ENV_SECTION_NAME, 2);
        if (parseContext.openURLs.contains(sURL)) {
            throw new ConfigurationException("org.clapper.util.config.Bundle", "Configuration.recursiveInclude", "{0}, line {1}: Attempt to include \"{2}\" from itself, either directly or indirectly.", new Object[]{url.toExternalForm(), String.valueOf(line.number), sURL});
        }
        parseContext.openURLs.add(sURL);
        InputStreamReader ir = encoding == null ? new InputStreamReader(in) : new InputStreamReader(in, encoding);
        BufferedReader r = new BufferedReader(ir);
        block8: while (this.readLogicalLine(r, line)) {
            try {
                switch (line.type) {
                    case COMMENT: 
                    case BLANK: {
                        continue block8;
                    }
                    case INCLUDE: {
                        this.handleInclude(line, url, encoding, parseContext);
                        continue block8;
                    }
                    case SECTION: {
                        parseContext.currentSection = this.handleNewSection(line, url);
                        continue block8;
                    }
                    case VARIABLE: {
                        if (parseContext.currentSection == null) {
                            throw new ConfigurationException("org.clapper.util.config.Bundle", "Configuration.varBeforeSection", "{0}, line {1}: Variable assignment before first section.", new Object[]{url.toExternalForm(), String.valueOf(line.number)});
                        }
                        this.handleVariable(line, url, parseContext);
                        continue block8;
                    }
                }
                throw new IllegalStateException("Bug: line.type=" + (Object)((Object)line.type));
            }
            catch (IOException ex) {
                throw new ConfigurationException(this.getExceptionPrefix(line, url) + ex.toString());
            }
        }
        parseContext.openURLs.remove(sURL);
    }

    private Section handleNewSection(Line line, URL url) throws ConfigurationException {
        String s = line.buffer.toString().trim();
        if (s.charAt(0) != '[') {
            throw new ConfigurationException("org.clapper.util.config.Bundle", "Configuration.badSectionBegin", "{0}, line {1}: Section does not begin with \"{2}\"", new Object[]{url.toExternalForm(), String.valueOf(line.number), String.valueOf('[')});
        }
        if (s.charAt(s.length() - 1) != ']') {
            throw new ConfigurationException("org.clapper.util.config.Bundle", "Configuration.badSectionEnd", "{0}, line {1}: Section does not end with \"{2}\"", new Object[]{url.toExternalForm(), String.valueOf(line.number), String.valueOf(']')});
        }
        return this.makeNewSection(s.substring(1, s.length() - 1));
    }

    private void handleVariable(Line line, URL url, ParseContext parseContext) throws ConfigurationException {
        int iSep;
        char[] s = line.buffer.toString().toCharArray();
        for (iSep = 0; iSep < s.length && s[iSep] != ':' && s[iSep] != '='; ++iSep) {
        }
        if (iSep == s.length) {
            throw new ConfigurationException("org.clapper.util.config.Bundle", "Configuration.missingAssignOp", "{0}, line {1}: Missing \"=\" or \":\" for variable definition.", new Object[]{url.toExternalForm(), String.valueOf(line.number)});
        }
        if (iSep == 0) {
            throw new ConfigurationException("org.clapper.util.config.Bundle", "Configuration.noVariablName", "{0}, line {1}: Missing variable name for variable definition.", new Object[]{url.toExternalForm(), String.valueOf(line.number)});
        }
        int i = 0;
        int j = iSep - 1;
        while (Character.isWhitespace(s[i])) {
            ++i;
        }
        while (Character.isWhitespace(s[j])) {
            --j;
        }
        if (i > j) {
            throw new ConfigurationException("org.clapper.util.config.Bundle", "Configuration.noVariablName", "{0}, line {1}: Missing variable name for variable definition.", new Object[]{url.toExternalForm(), String.valueOf(line.number)});
        }
        String varName = new String(s, i, j - i + 1);
        if (varName.length() == 0) {
            throw new ConfigurationException("org.clapper.util.config.Bundle", "Configuration.noVariablName", "{0}, line {1}: Missing variable name for variable definition.", new Object[]{url.toExternalForm(), String.valueOf(line.number)});
        }
        this.checkVariableName(varName);
        i = this.skipWhitespace(s, iSep + 1);
        j = s.length - i;
        Section currentSection = parseContext.currentSection;
        String value = new String(s, i, j);
        Variable existing = currentSection.getVariable(varName);
        if (existing != null) {
            throw new ConfigurationException("org.clapper.util.config.Bundle", "Configuration.duplicateVar", "{0}, line {1}: Section \"{2}\" has a duplicate definition for variable \"{3}\". The first instance was defined on line {4}.", new Object[]{url.toExternalForm(), String.valueOf(line.number), currentSection.getName(), varName, String.valueOf(existing.getLineWhereDefined())});
        }
        Variable newVar = currentSection.addVariable(varName, value, line.number);
        try {
            newVar.segmentValue();
            this.decodeMetacharacters(newVar);
            this.substituteVariables(newVar, this.varSubstituter, false);
            newVar.reassembleCookedValueFromSegments();
        }
        catch (VariableSubstitutionException ex) {
            throw new ConfigurationException(ex.getMessage());
        }
    }

    private void checkVariableName(String varName) throws ConfigurationException {
        for (char c : varName.toCharArray()) {
            if (this.legalVariableCharacter(c)) continue;
            throw new ConfigurationException("org.clapper.util.config.Bundle", "Configuration.badVariableName", "\"{0}\" is an illegal variable name", new Object[]{varName});
        }
    }

    private void handleInclude(Line line, URL url, String encoding, ParseContext parseContext) throws IOException, ConfigurationException {
        if (parseContext.includeFileNestingLevel >= 50) {
            throw new ConfigurationException("org.clapper.util.config.Bundle", "Configuration.maxNestedIncludeExceeded", "{0}, line {1}: Exceeded maximum nested include level of {2}.", new Object[]{url.toExternalForm(), String.valueOf(line.number), String.valueOf(50)});
        }
        ++parseContext.includeFileNestingLevel;
        String s = line.buffer.toString();
        String includeTarget = s.substring(INCLUDE.length() + 1).trim();
        int len = includeTarget.length();
        if (len < 2 || !includeTarget.startsWith("\"") || !includeTarget.endsWith("\"")) {
            throw new ConfigurationException("org.clapper.util.config.Bundle", "Configuration.malformedDirective", "{0}, line {1}: Malformed \"{2}\" directive", new Object[]{url.toExternalForm(), String.valueOf(line.number), INCLUDE});
        }
        if ((includeTarget = includeTarget.substring(1, len - 1)).length() == 0) {
            throw new ConfigurationException("org.clapper.util.config.Bundle", "Configuration.includeMissingFile", "{0}, line {1}: Missing file name or URL in \"{2}\" directive", new Object[]{url.toExternalForm(), String.valueOf(line.number), INCLUDE});
        }
        try {
            this.loadInclude(new URL(includeTarget), encoding, parseContext);
        }
        catch (MalformedURLException ex) {
            if (FileUtil.isAbsolutePath(includeTarget)) {
                this.loadInclude(new URL(url.getProtocol(), url.getHost(), url.getPort(), includeTarget), encoding, parseContext);
            }
            if (url == null) {
                this.loadInclude(new File(includeTarget).toURI().toURL(), encoding, parseContext);
            }
            String parent = new File(url.getFile()).getParent();
            if (parent == null) {
                parent = "";
            }
            this.loadInclude(new URL(url.getProtocol(), url.getHost(), url.getPort(), parent + "/" + includeTarget), encoding, parseContext);
        }
        --parseContext.includeFileNestingLevel;
    }

    private void loadInclude(URL url, String encoding, ParseContext parseContext) throws IOException, ConfigurationException {
        this.loadConfiguration(url.openStream(), encoding, url, parseContext);
    }

    private boolean readLogicalLine(BufferedReader r, Line line) throws ConfigurationException {
        boolean gotSomething;
        block4: {
            String s;
            boolean continued = false;
            gotSomething = false;
            line.newLine();
            while (true) {
                try {
                    s = r.readLine();
                }
                catch (IOException ex) {
                    throw new ConfigurationException(ex.toString());
                }
                if (s == null) break block4;
                gotSomething = true;
                ++line.number;
                char[] chars = s.toCharArray();
                int i = this.skipWhitespace(chars, 0);
                s = i < chars.length ? s.substring(i) : "";
                if (!continued) {
                    line.type = s.length() == 0 ? LineType.BLANK : (COMMENT_CHARS.indexOf(s.charAt(0)) != -1 ? LineType.COMMENT : (s.charAt(0) == '[' ? LineType.SECTION : (new StringTokenizer(s).nextToken().equals(INCLUDE) ? LineType.INCLUDE : LineType.VARIABLE)));
                }
                if (line.type != LineType.VARIABLE || !this.hasContinuationMark(s)) break;
                continued = true;
                line.buffer.append(s.substring(0, s.length() - 1));
            }
            line.buffer.append(s);
        }
        return gotSomething;
    }

    private boolean hasContinuationMark(String s) {
        char[] chars;
        boolean has = false;
        if (s.length() > 0 && (chars = s.toCharArray())[chars.length - 1] == '\\') {
            int total = 0;
            for (int i = chars.length - 1; i >= 0 && chars[i] == '\\'; --i) {
                ++total;
            }
            has = total % 2 == 1;
        }
        return has;
    }

    private String getExceptionPrefix(Line line, URL url) {
        StringBuffer buf = new StringBuffer();
        if (url != null) {
            buf.append(url.toExternalForm());
            buf.append(", line ");
        } else {
            buf.append("Line ");
        }
        buf.append(line.number);
        buf.append(": ");
        return buf.toString();
    }

    private void decodeMetacharacters(Variable var) throws VariableSubstitutionException, ConfigurationException {
        ValueSegment[] segments;
        for (ValueSegment segment : segments = var.getCookedSegments()) {
            if (segment.isLiteral) continue;
            segment.segmentBuf.decodeMetacharacters();
        }
    }

    private void substituteVariables(Variable var, VariableSubstituter substituter, boolean concatSegments) throws VariableSubstitutionException, ConfigurationException {
        ValueSegment[] segments = var.getCookedSegments();
        SubstitutionContext context = new SubstitutionContext(var);
        for (ValueSegment segment : segments) {
            if (segment.isLiteral) continue;
            String s = segment.segmentBuf.toString();
            do {
                context.totalSubstitutions = 0;
                s = substituter.substitute(s, this, this, context);
            } while (context.totalSubstitutions > 0);
            segment.segmentBuf.setLength(0);
            segment.segmentBuf.append(s);
        }
        if (concatSegments) {
            var.reassembleCookedValueFromSegments();
        }
    }

    private int skipWhitespace(char[] chars, int start) {
        while (start < chars.length && Character.isWhitespace(chars[start])) {
            ++start;
        }
        return start;
    }

    private Section makeNewSection(String sectionName) {
        int id = this.nextSectionID();
        Section section = new Section(sectionName, id);
        this.sectionsInOrder.add(section);
        this.sectionsByName.put(sectionName, section);
        return section;
    }

    private synchronized int nextSectionID() {
        return ++this.nextSectionIDValue;
    }

    static {
        log = new Logger(Configuration.class);
    }

    private class SubstitutionContext {
        Variable currentVariable;
        int totalSubstitutions = 0;

        SubstitutionContext(Variable v) {
            this.currentVariable = v;
        }
    }

    private class ParseContext {
        Section currentSection = null;
        Variable currentVariable = null;
        int includeFileNestingLevel = 0;
        Set<String> openURLs = new HashSet<String>();

        ParseContext() {
        }
    }

    private static class Line {
        int number = 0;
        LineType type = LineType.COMMENT;
        XStringBuffer buffer = new XStringBuffer();

        Line() {
        }

        void newLine() {
            this.buffer.setLength(0);
        }
    }

    private static enum LineType {
        COMMENT,
        INCLUDE,
        SECTION,
        VARIABLE,
        BLANK;

    }
}

