/*
 * Decompiled with CFR 0.152.
 */
package jhplot.utils;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jhplot.utils.Util;

public class HelpDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JButton closeButton;
    private JPanel panel1;
    private Component win;
    private String html_file;

    public HelpDialog(Component win, String html_file) {
        this.win = win;
        this.html_file = html_file;
        this.setDefaultCloseOperation(2);
        this.setTitle("About");
        this.setModal(true);
        this.setResizable(true);
        Dimension res = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension size = new Dimension(Math.min(400, res.width), Math.min(500, res.height));
        this.setSize(size);
        JPanel topPanel = new JPanel();
        JPanel lowerPanel = new JPanel();
        lowerPanel.setPreferredSize(new Dimension(400, 35));
        this.closeButton = new JButton();
        this.closeButton.setText("Exit");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HelpDialog.this.setVisible(false);
                HelpDialog.this.dispose();
            }
        });
        lowerPanel.add((Component)this.closeButton, null);
        topPanel.setLayout(new BorderLayout());
        this.getContentPane().add((Component)topPanel, "Center");
        this.getContentPane().add((Component)lowerPanel, "South");
        this.createPage1();
        topPanel.add((Component)this.panel1, "Center");
        Util.centreWithin(win, this);
        this.setVisible(true);
    }

    public void createPage1() {
        this.panel1 = new JPanel();
        this.panel1.setLayout(new BorderLayout());
        JEditorPane epane = new JEditorPane();
        epane.setOpaque(false);
        epane.setContentType("text/html;charset=ISO-8859-1");
        epane.setAutoscrolls(true);
        epane.setEditable(false);
        try {
            epane.setPage(this.getHTMLUrl(this.html_file));
        }
        catch (Exception e) {
            System.err.println("Couldn't create URL");
            epane.setContentType("text/plain");
        }
        JScrollPane jsp = new JScrollPane(epane);
        this.panel1.add(jsp);
    }

    public URL getHTMLUrl(String name) {
        URL url = null;
        try {
            url = this.getClass().getResource("/html/" + name);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return url;
    }
}

