/*
 * Decompiled with CFR 0.152.
 */
package com.flaptor.hist4j;

import com.flaptor.hist4j.AdaptiveHistogram;
import com.flaptor.hist4j.Cell;
import com.flaptor.hist4j.HistogramNode;
import java.util.ArrayList;

public class HistogramForkNode
extends HistogramNode {
    private static final long serialVersionUID = -1L;
    private float splitValue;
    private HistogramNode left = null;
    private HistogramNode right = null;

    public HistogramForkNode(float splitValue, HistogramNode left, HistogramNode right) {
        this.splitValue = splitValue;
        this.left = left;
        this.right = right;
    }

    @Override
    public void reset() {
        if (null != this.left) {
            this.left.reset();
            this.left = null;
        }
        if (null != this.right) {
            this.right.reset();
            this.right = null;
        }
        this.splitValue = 0.0f;
    }

    @Override
    public HistogramNode addValue(AdaptiveHistogram root, float value) {
        if (value > this.splitValue) {
            this.right = this.right.addValue(root, value);
        } else {
            this.left = this.left.addValue(root, value);
        }
        return this;
    }

    @Override
    public long getCount(float value) {
        long count = 0L;
        count = value > this.splitValue ? this.right.getCount(value) : this.left.getCount(value);
        return count;
    }

    @Override
    public long getAccumCount(float value) {
        long count = this.left.getAccumCount(value);
        if (value > this.splitValue) {
            count += this.right.getAccumCount(value);
        }
        return count;
    }

    @Override
    public Float getValueForAccumCount(long[] accumCount) {
        Float val = this.left.getValueForAccumCount(accumCount);
        if (null == val) {
            val = this.right.getValueForAccumCount(accumCount);
        }
        return val;
    }

    @Override
    public void apply(AdaptiveHistogram.ValueConversion valueConversion) {
        this.left.apply(valueConversion);
        this.right.apply(valueConversion);
        this.splitValue = valueConversion.convertValue(this.splitValue);
    }

    @Override
    public void show(int level) {
        this.left.show(level + 1);
        this.margin(level);
        System.out.println("Fork at: " + this.splitValue);
        this.right.show(level + 1);
    }

    @Override
    public void toTable(ArrayList<Cell> table) {
        this.left.toTable(table);
        this.right.toTable(table);
    }
}

