/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sort;

public class Sort {
    public static void insertionSort(int[] a) {
        for (int j = 1; j < a.length; ++j) {
            int key = a[j];
            for (int i = j - 1; i >= 0 && a[i] > key; --i) {
                a[i + 1] = a[i];
            }
            a[i + 1] = key;
        }
    }

    public static void mergeSort(int[] a) {
        Sort.mergeSort(a, 0, a.length - 1);
    }

    private static void mergeSort(int[] a, int p, int r) {
        if (p < r) {
            int q = p + r >> 1;
            Sort.mergeSort(a, p, q);
            Sort.mergeSort(a, q + 1, r);
            Sort.merge(a, p, q, r);
        }
    }

    private static void merge(int[] a, int p, int q, int r) {
        int i;
        int n1 = q - p + 1;
        int n2 = r - q;
        int[] tabL = new int[n1 + 1];
        int[] tabR = new int[n2 + 1];
        for (i = 0; i < n1; ++i) {
            tabL[i] = a[p + i];
        }
        for (int j = 0; j < n2; ++j) {
            tabR[j] = a[q + j + 1];
        }
        tabL[n1] = Integer.MAX_VALUE;
        tabR[n2] = Integer.MAX_VALUE;
        i = 0;
        int j = 0;
        for (int k = p; k < r + 1; ++k) {
            a[k] = tabL[i] <= tabR[j] ? tabL[i++] : tabR[j++];
        }
    }

    public static void bubbleSort(int[] a) {
        for (int i = 0; i < a.length; ++i) {
            for (int j = a.length - 1; j >= i + 1; --j) {
                if (a[j] >= a[j - 1]) continue;
                int temp = a[j];
                a[j] = a[j - 1];
                a[j - 1] = temp;
            }
        }
    }

    public static void quicksort(int[] a) {
        Sort.quicksort(a, 0, a.length - 1);
    }

    private static void quicksort(int[] a, int p, int r) {
        if (p < r) {
            int q = Sort.partition(a, p, r);
            Sort.quicksort(a, p, q - 1);
            Sort.quicksort(a, q + 1, r);
        }
    }

    static int partition(int[] a, int p, int r) {
        int x = a[r];
        int i = p - 1;
        for (int j = p; j <= r - 1; ++j) {
            if (a[j] > x) continue;
            Sort.swap(a, ++i, j);
        }
        Sort.swap(a, i + 1, r);
        return i + 1;
    }

    private static void swap(int[] array, int i, int j) {
        int valueI = array[i];
        array[i] = array[j];
        array[j] = valueI;
    }
}

