/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.spam;

import ca.pfv.spmf.algorithms.sequentialpatterns.spam.Bitmap;
import ca.pfv.spmf.algorithms.sequentialpatterns.spam.PatternVMSP;
import ca.pfv.spmf.algorithms.sequentialpatterns.spam.PrefixVMSP;
import ca.pfv.spmf.patterns.itemset_list_integers_without_support.Itemset;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public class AlgoVMSP {
    public long startTime;
    public long endTime;
    public int patternCount;
    private int minsup = 0;
    BufferedWriter writer = null;
    Map<Integer, Bitmap> verticalDB = new HashMap<Integer, Bitmap>();
    List<Integer> sequencesSize = null;
    int lastBitIndex = 0;
    private int maximumPatternLength = Integer.MAX_VALUE;
    Map<Integer, Map<Integer, Integer>> coocMapAfter = null;
    Map<Integer, Map<Integer, Integer>> coocMapEquals = null;
    Map<Integer, Short> lastItemPositionMap;
    boolean useCMAPPruning = true;
    boolean useLastPositionPruning = false;
    List<TreeSet<PatternVMSP>> maxPatterns = null;
    private boolean useStrategyForwardExtensionChecking = true;

    public List<TreeSet<PatternVMSP>> runAlgorithm(String input, String outputFilePath, double minsupRel) throws IOException {
        Bitmap.INTERSECTION_COUNT = 0L;
        this.writer = new BufferedWriter(new FileWriter(outputFilePath));
        this.patternCount = 0;
        MemoryLogger.getInstance().reset();
        this.startTime = System.currentTimeMillis();
        this.vmsp(input, minsupRel);
        this.endTime = System.currentTimeMillis();
        this.writeResultTofile(outputFilePath);
        this.writer.close();
        return this.maxPatterns;
    }

    /*
     * WARNING - void declaration
     */
    private void vmsp(String input, double minsupRel) throws IOException {
        String thisLine;
        BufferedReader reader;
        FileInputStream fin;
        this.maxPatterns = new ArrayList<TreeSet<PatternVMSP>>(20);
        this.maxPatterns.add(null);
        this.maxPatterns.add(new TreeSet());
        this.verticalDB = new HashMap<Integer, Bitmap>();
        ArrayList<int[]> inMemoryDB = new ArrayList<int[]>();
        this.sequencesSize = new ArrayList<Integer>();
        this.lastBitIndex = 0;
        try {
            void var8_9;
            fin = new FileInputStream(new File(input));
            reader = new BufferedReader(new InputStreamReader(fin));
            boolean bl = false;
            while ((thisLine = reader.readLine()) != null) {
                if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                this.sequencesSize.add((int)var8_9);
                String[] tokens = thisLine.split(" ");
                int[] transactionArray = new int[tokens.length];
                inMemoryDB.add(transactionArray);
                for (int i = 0; i < tokens.length; ++i) {
                    int item;
                    transactionArray[i] = item = Integer.parseInt(tokens[i]);
                    if (item != -1) continue;
                    ++var8_9;
                }
            }
            this.lastBitIndex = var8_9 - true;
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.minsup = (int)Math.ceil(minsupRel * (double)this.sequencesSize.size());
        if (this.minsup == 0) {
            this.minsup = 1;
        }
        try {
            fin = new FileInputStream(new File(input));
            reader = new BufferedReader(new InputStreamReader(fin));
            boolean bl = false;
            int tid = 0;
            while ((thisLine = reader.readLine()) != null) {
                for (String token : thisLine.split(" ")) {
                    void var8_11;
                    if (token.equals("-1")) {
                        ++tid;
                        continue;
                    }
                    if (token.equals("-2")) {
                        ++var8_11;
                        tid = 0;
                        continue;
                    }
                    Integer item = Integer.parseInt(token);
                    Bitmap bitmapItem = this.verticalDB.get(item);
                    if (bitmapItem == null) {
                        bitmapItem = new Bitmap(this.lastBitIndex);
                        this.verticalDB.put(item, bitmapItem);
                    }
                    bitmapItem.registerBit((int)var8_11, tid, this.sequencesSize);
                }
            }
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList<Integer> frequentItems = new ArrayList<Integer>();
        Iterator<Map.Entry<Integer, Bitmap>> iter = this.verticalDB.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Integer, Bitmap> entry = iter.next();
            if (entry.getValue().getSupport() < this.minsup) {
                iter.remove();
                continue;
            }
            frequentItems.add(entry.getKey());
        }
        Collections.sort(frequentItems, new Comparator<Integer>(){

            @Override
            public int compare(Integer arg0, Integer arg1) {
                return AlgoVMSP.this.verticalDB.get(arg0).getSupport() - AlgoVMSP.this.verticalDB.get(arg1).getSupport();
            }
        });
        this.coocMapEquals = new HashMap<Integer, Map<Integer, Integer>>(frequentItems.size());
        this.coocMapAfter = new HashMap<Integer, Map<Integer, Integer>>(frequentItems.size());
        if (this.useLastPositionPruning) {
            this.lastItemPositionMap = new HashMap<Integer, Short>(frequentItems.size());
        }
        for (int[] nArray : inMemoryDB) {
            short itemsetCount = 0;
            HashSet<Integer> alreadyProcessed = new HashSet<Integer>();
            HashMap equalProcessed = new HashMap();
            block10: for (int i = 0; i < nArray.length; ++i) {
                Bitmap bitmapOfItem;
                Short last;
                Integer itemI = nArray[i];
                HashSet<Integer> equalSet = (HashSet<Integer>)equalProcessed.get(itemI);
                if (equalSet == null) {
                    equalSet = new HashSet<Integer>();
                    equalProcessed.put(itemI, equalSet);
                }
                if (itemI < 0) {
                    itemsetCount = (short)(itemsetCount + 1);
                    continue;
                }
                if (this.useLastPositionPruning && ((last = this.lastItemPositionMap.get(itemI)) == null || last < itemsetCount)) {
                    this.lastItemPositionMap.put(itemI, itemsetCount);
                }
                if ((bitmapOfItem = this.verticalDB.get(itemI)) == null || bitmapOfItem.getSupport() < this.minsup) continue;
                HashSet<Integer> alreadyProcessedB = new HashSet<Integer>();
                boolean sameItemset = true;
                for (int j = i + 1; j < nArray.length; ++j) {
                    Integer support;
                    Integer itemJ = nArray[j];
                    if (itemJ < 0) {
                        sameItemset = false;
                        continue;
                    }
                    Bitmap bitmapOfitemJ = this.verticalDB.get(itemJ);
                    if (bitmapOfitemJ == null || bitmapOfitemJ.getSupport() < this.minsup) continue;
                    Map<Integer, Integer> map = null;
                    if (sameItemset) {
                        if (equalSet.contains(itemJ)) continue;
                        map = this.coocMapEquals.get(itemI);
                        if (map == null) {
                            map = new HashMap<Integer, Integer>();
                            this.coocMapEquals.put(itemI, map);
                        }
                        if ((support = map.get(itemJ)) == null) {
                            map.put(itemJ, 1);
                        } else {
                            support = support + 1;
                            map.put(itemJ, support);
                        }
                        equalSet.add(itemJ);
                        continue;
                    }
                    if (alreadyProcessedB.contains(itemJ)) continue;
                    if (alreadyProcessed.contains(itemI)) continue block10;
                    map = this.coocMapAfter.get(itemI);
                    if (map == null) {
                        map = new HashMap<Integer, Integer>();
                        this.coocMapAfter.put(itemI, map);
                    }
                    if ((support = map.get(itemJ)) == null) {
                        map.put(itemJ, 1);
                    } else {
                        support = support + 1;
                        map.put(itemJ, support);
                    }
                    alreadyProcessedB.add(itemJ);
                }
                alreadyProcessed.add(itemI);
            }
        }
        if (this.maximumPatternLength == 1) {
            return;
        }
        for (Map.Entry entry : this.verticalDB.entrySet()) {
            boolean hasExtension;
            boolean itemIsEven;
            PrefixVMSP prefix = new PrefixVMSP();
            prefix.addItemset(new Itemset((Integer)entry.getKey()));
            boolean bl = itemIsEven = (Integer)entry.getKey() % 2 == 0;
            if (itemIsEven) {
                prefix.sumOfEvenItems = (Integer)entry.getKey();
                prefix.sumOfOddItems = 0;
            } else {
                prefix.sumOfEvenItems = 0;
                prefix.sumOfOddItems = (Integer)entry.getKey();
            }
            if (hasExtension = this.dfsPruning(prefix, (Bitmap)entry.getValue(), frequentItems, frequentItems, (Integer)entry.getKey(), 2, (Integer)entry.getKey())) continue;
            this.savePatternSingleItem((Integer)entry.getKey(), (Bitmap)entry.getValue(), itemIsEven);
        }
    }

    boolean dfsPruning(PrefixVMSP prefix, Bitmap prefixBitmap, List<Integer> sn, List<Integer> in, int hasToBeGreaterThanForIStep, int m, Integer lastAppendedItem) throws IOException {
        boolean atLeastOneFrequentExtension = false;
        ArrayList<Integer> sTemp = new ArrayList<Integer>();
        ArrayList<Bitmap> sTempBitmaps = new ArrayList<Bitmap>();
        Map<Integer, Integer> mapSupportItemsAfter = this.coocMapAfter.get(lastAppendedItem);
        for (Integer i : sn) {
            Integer support;
            if (this.useCMAPPruning && (mapSupportItemsAfter == null || (support = mapSupportItemsAfter.get(i)) == null || support < this.minsup)) continue;
            ++Bitmap.INTERSECTION_COUNT;
            Bitmap newBitmap = prefixBitmap.createNewBitmapSStep(this.verticalDB.get(i), this.sequencesSize, this.lastBitIndex);
            if (newBitmap.getSupport() < this.minsup) continue;
            sTemp.add(i);
            sTempBitmaps.add(newBitmap);
        }
        for (int k = 0; k < sTemp.size(); ++k) {
            atLeastOneFrequentExtension = true;
            int item = (Integer)sTemp.get(k);
            PrefixVMSP prefixSStep = prefix.cloneSequence();
            prefixSStep.addItemset(new Itemset(item));
            if (item % 2 == 0) {
                prefixSStep.sumOfEvenItems = item + prefix.sumOfEvenItems;
                prefixSStep.sumOfOddItems = prefix.sumOfOddItems;
            } else {
                prefixSStep.sumOfEvenItems = prefix.sumOfEvenItems;
                prefixSStep.sumOfOddItems = item + prefix.sumOfOddItems;
            }
            Bitmap newBitmap = (Bitmap)sTempBitmaps.get(k);
            boolean hasFrequentExtension = false;
            if (this.maximumPatternLength > m) {
                this.dfsPruning(prefixSStep, newBitmap, sTemp, sTemp, item, m + 1, item);
            }
            if (hasFrequentExtension) continue;
            this.savePatternMultipleItems(prefixSStep, newBitmap, m);
        }
        Map<Integer, Integer> mapSupportItemsEquals = this.coocMapEquals.get(lastAppendedItem);
        ArrayList<Integer> iTemp = new ArrayList<Integer>();
        ArrayList<Bitmap> iTempBitmaps = new ArrayList<Bitmap>();
        for (Integer i : in) {
            Integer support;
            if (i <= hasToBeGreaterThanForIStep || this.useCMAPPruning && (mapSupportItemsEquals == null || (support = mapSupportItemsEquals.get(i)) == null || support < this.minsup)) continue;
            ++Bitmap.INTERSECTION_COUNT;
            Bitmap newBitmap = prefixBitmap.createNewBitmapIStep(this.verticalDB.get(i), this.sequencesSize, this.lastBitIndex);
            if (newBitmap.getSupport() < this.minsup) continue;
            iTemp.add(i);
            iTempBitmaps.add(newBitmap);
        }
        for (int k = 0; k < iTemp.size(); ++k) {
            atLeastOneFrequentExtension = true;
            int item = (Integer)iTemp.get(k);
            PrefixVMSP prefixIStep = prefix.cloneSequence();
            ((Itemset)prefixIStep.getItemsets().get(prefixIStep.size() - 1)).addItem(item);
            if (item % 2 == 0) {
                prefixIStep.sumOfEvenItems = item + prefix.sumOfEvenItems;
                prefixIStep.sumOfOddItems = prefix.sumOfOddItems;
            } else {
                prefixIStep.sumOfEvenItems = prefix.sumOfEvenItems;
                prefixIStep.sumOfOddItems = item + prefix.sumOfOddItems;
            }
            Bitmap newBitmap = (Bitmap)iTempBitmaps.get(k);
            boolean hasFrequentExtension = false;
            if (this.maximumPatternLength > m) {
                hasFrequentExtension = this.dfsPruning(prefixIStep, newBitmap, sTemp, iTemp, item, m + 1, item);
            }
            if (hasFrequentExtension) continue;
            this.savePatternMultipleItems(prefixIStep, newBitmap, m);
        }
        MemoryLogger.getInstance().checkMemory();
        return atLeastOneFrequentExtension || !this.useStrategyForwardExtensionChecking;
    }

    private boolean savePatternSingleItem(Integer item, Bitmap bitmap, boolean itemIsEven) throws IOException {
        int i;
        if (itemIsEven) {
            block0: for (i = this.maxPatterns.size() - 1; i > 1; --i) {
                for (PatternVMSP pPrime : this.maxPatterns.get(i)) {
                    if (pPrime.prefix.sumOfOddItems + pPrime.prefix.sumOfEvenItems < item) continue block0;
                    if (pPrime.prefix.sumOfEvenItems <= item || bitmap.getSupport() < pPrime.support || !pPrime.prefix.containsItem(item)) continue;
                    return true;
                }
            }
        } else {
            block2: for (i = this.maxPatterns.size() - 1; i > 1; --i) {
                for (PatternVMSP pPrime : this.maxPatterns.get(i)) {
                    if (pPrime.prefix.sumOfOddItems + pPrime.prefix.sumOfEvenItems < item) continue block2;
                    if (pPrime.prefix.sumOfOddItems <= item || bitmap.getSupport() < pPrime.support || !pPrime.prefix.containsItem(item)) continue;
                    return true;
                }
            }
        }
        ++this.patternCount;
        PrefixVMSP prefix = new PrefixVMSP();
        prefix.addItemset(new Itemset(item));
        if (itemIsEven) {
            prefix.sumOfEvenItems = item;
            prefix.sumOfOddItems = 0;
        } else {
            prefix.sumOfEvenItems = 0;
            prefix.sumOfOddItems = item;
        }
        PatternVMSP newPat = new PatternVMSP(prefix, bitmap.getSupport());
        this.maxPatterns.get(1).add(newPat);
        return false;
    }

    private boolean savePatternMultipleItems(PrefixVMSP prefix, Bitmap bitmap, int length) throws IOException {
        int i;
        block0: for (i = this.maxPatterns.size() - 1; i > length; --i) {
            for (PatternVMSP pPrime : this.maxPatterns.get(i)) {
                if (pPrime.prefix.sumOfOddItems + pPrime.prefix.sumOfEvenItems < prefix.sumOfOddItems + prefix.sumOfEvenItems) continue block0;
                if (prefix.sumOfEvenItems > pPrime.prefix.sumOfEvenItems || prefix.sumOfOddItems > pPrime.prefix.sumOfOddItems || bitmap.getSupport() < pPrime.support || !this.strictlyContains(pPrime.prefix, prefix)) continue;
                return true;
            }
        }
        block2: for (i = 1; i < length && i < this.maxPatterns.size(); ++i) {
            Iterator<PatternVMSP> iter = this.maxPatterns.get(i).descendingIterator();
            while (iter.hasNext()) {
                PatternVMSP pPrime;
                pPrime = iter.next();
                if (pPrime.prefix.sumOfOddItems + pPrime.prefix.sumOfEvenItems >= prefix.sumOfOddItems + prefix.sumOfEvenItems) continue block2;
                if (prefix.sumOfEvenItems < pPrime.prefix.sumOfEvenItems || prefix.sumOfOddItems < pPrime.prefix.sumOfOddItems || bitmap.getSupport() > pPrime.support || !this.strictlyContains(prefix, pPrime.prefix)) continue;
                --this.patternCount;
                iter.remove();
            }
        }
        while (this.maxPatterns.size() - 1 < length) {
            this.maxPatterns.add(new TreeSet());
        }
        TreeSet<PatternVMSP> patternsOfSizeM = this.maxPatterns.get(length);
        ++this.patternCount;
        patternsOfSizeM.add(new PatternVMSP(prefix, bitmap.getSupport()));
        return false;
    }

    boolean strictlyContains(PrefixVMSP pattern1, PrefixVMSP pattern2) {
        int i = 0;
        int j = 0;
        do {
            if (pattern1.get(j).containsAll(pattern2.get(i)) && ++i == pattern2.size()) {
                return true;
            }
            if (++j < pattern1.size()) continue;
            return false;
        } while (pattern1.size() - j >= pattern2.size() - i);
        return false;
    }

    public void printStatistics() {
        StringBuilder r = new StringBuilder(200);
        r.append("=============  Algorithm VMSP - STATISTICS =============\n Total time ~ ");
        r.append(this.endTime - this.startTime);
        r.append(" ms\n");
        r.append(" Frequent sequences count : " + this.patternCount);
        r.append('\n');
        r.append(" Max memory (mb) : ");
        r.append(MemoryLogger.getInstance().getMaxMemory());
        r.append(this.patternCount);
        r.append('\n');
        r.append("minsup " + this.minsup);
        r.append('\n');
        r.append("Intersection count " + Bitmap.INTERSECTION_COUNT + " \n");
        r.append("===================================================\n");
        System.out.println(r.toString());
    }

    public int getMaximumPatternLength() {
        return this.maximumPatternLength;
    }

    public void setMaximumPatternLength(int maximumPatternLength) {
        this.maximumPatternLength = maximumPatternLength;
    }

    public void writeResultTofile(String path) throws IOException {
        for (TreeSet<PatternVMSP> tree : this.maxPatterns) {
            if (tree == null) continue;
            for (PatternVMSP pattern : tree) {
                StringBuffer r = new StringBuffer("");
                for (Itemset itemset : pattern.prefix.getItemsets()) {
                    for (Integer item : itemset.getItems()) {
                        String string = item.toString();
                        r.append(string);
                        r.append(' ');
                    }
                    r.append("-1 ");
                }
                r.append("SUP: ");
                r.append(pattern.support);
                this.writer.write(r.toString());
                this.writer.newLine();
            }
        }
    }
}

