/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.spam;

import ca.pfv.spmf.algorithms.sequentialpatterns.spam.Bitmap;
import ca.pfv.spmf.algorithms.sequentialpatterns.spam.Prefix;
import ca.pfv.spmf.patterns.itemset_list_integers_without_support.Itemset;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AlgoCMSPAM {
    public long startTime;
    public long endTime;
    public int patternCount;
    private int minsup = 0;
    BufferedWriter writer = null;
    Map<Integer, Bitmap> verticalDB = new HashMap<Integer, Bitmap>();
    List<Integer> sequencesSize = null;
    int lastBitIndex = 0;
    private int maximumPatternLength = Integer.MAX_VALUE;
    Map<Integer, Map<Integer, Integer>> coocMapAfter = null;
    Map<Integer, Map<Integer, Integer>> coocMapEquals = null;
    Map<Integer, Short> lastItemPositionMap;
    boolean useCMAPPruning = true;
    boolean useLastPositionPruning = false;

    public void runAlgorithm(String input, String outputFilePath, double minsupRel) throws IOException {
        Bitmap.INTERSECTION_COUNT = 0L;
        this.writer = new BufferedWriter(new FileWriter(outputFilePath));
        this.patternCount = 0;
        MemoryLogger.getInstance().reset();
        this.startTime = System.currentTimeMillis();
        this.spam(input, minsupRel);
        this.endTime = System.currentTimeMillis();
        this.writer.close();
    }

    /*
     * WARNING - void declaration
     */
    private void spam(String input, double minsupRel) throws IOException {
        String thisLine;
        BufferedReader reader;
        FileInputStream fin;
        this.verticalDB = new HashMap<Integer, Bitmap>();
        ArrayList<int[]> inMemoryDB = new ArrayList<int[]>();
        this.sequencesSize = new ArrayList<Integer>();
        this.lastBitIndex = 0;
        try {
            void var8_9;
            fin = new FileInputStream(new File(input));
            reader = new BufferedReader(new InputStreamReader(fin));
            boolean bl = false;
            while ((thisLine = reader.readLine()) != null) {
                if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                this.sequencesSize.add((int)var8_9);
                String[] tokens = thisLine.split(" ");
                int[] transactionArray = new int[tokens.length];
                inMemoryDB.add(transactionArray);
                for (int i = 0; i < tokens.length; ++i) {
                    int item;
                    transactionArray[i] = item = Integer.parseInt(tokens[i]);
                    if (item != -1) continue;
                    ++var8_9;
                }
            }
            this.lastBitIndex = var8_9 - true;
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.minsup = (int)Math.ceil(minsupRel * (double)this.sequencesSize.size());
        if (this.minsup == 0) {
            this.minsup = 1;
        }
        try {
            fin = new FileInputStream(new File(input));
            reader = new BufferedReader(new InputStreamReader(fin));
            boolean bl = false;
            int tid = 0;
            while ((thisLine = reader.readLine()) != null) {
                for (String token : thisLine.split(" ")) {
                    void var8_11;
                    if (token.equals("-1")) {
                        ++tid;
                        continue;
                    }
                    if (token.equals("-2")) {
                        ++var8_11;
                        tid = 0;
                        continue;
                    }
                    Integer item = Integer.parseInt(token);
                    Bitmap bitmapItem = this.verticalDB.get(item);
                    if (bitmapItem == null) {
                        bitmapItem = new Bitmap(this.lastBitIndex);
                        this.verticalDB.put(item, bitmapItem);
                    }
                    bitmapItem.registerBit((int)var8_11, tid, this.sequencesSize);
                }
            }
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList<Integer> frequentItems = new ArrayList<Integer>();
        Iterator<Map.Entry<Integer, Bitmap>> iter = this.verticalDB.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Integer, Bitmap> entry = iter.next();
            if (entry.getValue().getSupport() < this.minsup) {
                iter.remove();
                continue;
            }
            this.savePattern(entry.getKey(), entry.getValue());
            frequentItems.add(entry.getKey());
        }
        this.coocMapEquals = new HashMap<Integer, Map<Integer, Integer>>(frequentItems.size());
        this.coocMapAfter = new HashMap<Integer, Map<Integer, Integer>>(frequentItems.size());
        if (this.useLastPositionPruning) {
            this.lastItemPositionMap = new HashMap<Integer, Short>(frequentItems.size());
        }
        for (int[] nArray : inMemoryDB) {
            short itemsetCount = 0;
            HashSet<Integer> alreadyProcessed = new HashSet<Integer>();
            HashMap equalProcessed = new HashMap();
            block10: for (int i = 0; i < nArray.length; ++i) {
                Bitmap bitmapOfItem;
                Short last;
                Integer itemI = nArray[i];
                HashSet<Integer> equalSet = (HashSet<Integer>)equalProcessed.get(itemI);
                if (equalSet == null) {
                    equalSet = new HashSet<Integer>();
                    equalProcessed.put(itemI, equalSet);
                }
                if (itemI < 0) {
                    itemsetCount = (short)(itemsetCount + 1);
                    continue;
                }
                if (this.useLastPositionPruning && ((last = this.lastItemPositionMap.get(itemI)) == null || last < itemsetCount)) {
                    this.lastItemPositionMap.put(itemI, itemsetCount);
                }
                if ((bitmapOfItem = this.verticalDB.get(itemI)) == null || bitmapOfItem.getSupport() < this.minsup) continue;
                HashSet<Integer> alreadyProcessedB = new HashSet<Integer>();
                boolean sameItemset = true;
                for (int j = i + 1; j < nArray.length; ++j) {
                    Integer support;
                    Integer itemJ = nArray[j];
                    if (itemJ < 0) {
                        sameItemset = false;
                        continue;
                    }
                    Bitmap bitmapOfitemJ = this.verticalDB.get(itemJ);
                    if (bitmapOfitemJ == null || bitmapOfitemJ.getSupport() < this.minsup) continue;
                    Map<Integer, Integer> map = null;
                    if (sameItemset) {
                        if (equalSet.contains(itemJ)) continue;
                        map = this.coocMapEquals.get(itemI);
                        if (map == null) {
                            map = new HashMap<Integer, Integer>();
                            this.coocMapEquals.put(itemI, map);
                        }
                        if ((support = map.get(itemJ)) == null) {
                            map.put(itemJ, 1);
                        } else {
                            support = support + 1;
                            map.put(itemJ, support);
                        }
                        equalSet.add(itemJ);
                        continue;
                    }
                    if (alreadyProcessedB.contains(itemJ)) continue;
                    if (alreadyProcessed.contains(itemI)) continue block10;
                    map = this.coocMapAfter.get(itemI);
                    if (map == null) {
                        map = new HashMap<Integer, Integer>();
                        this.coocMapAfter.put(itemI, map);
                    }
                    if ((support = map.get(itemJ)) == null) {
                        map.put(itemJ, 1);
                    } else {
                        support = support + 1;
                        map.put(itemJ, support);
                    }
                    alreadyProcessedB.add(itemJ);
                }
                alreadyProcessed.add(itemI);
            }
        }
        if (this.maximumPatternLength == 1) {
            return;
        }
        for (Map.Entry entry : this.verticalDB.entrySet()) {
            Prefix prefix = new Prefix();
            prefix.addItemset(new Itemset((Integer)entry.getKey()));
            this.dfsPruning(prefix, (Bitmap)entry.getValue(), frequentItems, frequentItems, (Integer)entry.getKey(), 2, (Integer)entry.getKey());
        }
    }

    private void dfsPruning(Prefix prefix, Bitmap prefixBitmap, List<Integer> sn, List<Integer> in, int hasToBeGreaterThanForIStep, int m, Integer lastAppendedItem) throws IOException {
        ArrayList<Integer> sTemp = new ArrayList<Integer>();
        ArrayList<Bitmap> sTempBitmaps = new ArrayList<Bitmap>();
        Map<Integer, Integer> mapSupportItemsAfter = this.coocMapAfter.get(lastAppendedItem);
        for (Integer i : sn) {
            Integer support;
            if (this.useCMAPPruning && (mapSupportItemsAfter == null || (support = mapSupportItemsAfter.get(i)) == null || support < this.minsup)) continue;
            ++Bitmap.INTERSECTION_COUNT;
            Bitmap newBitmap = prefixBitmap.createNewBitmapSStep(this.verticalDB.get(i), this.sequencesSize, this.lastBitIndex);
            if (newBitmap.getSupport() < this.minsup) continue;
            sTemp.add(i);
            sTempBitmaps.add(newBitmap);
        }
        for (int k = 0; k < sTemp.size(); ++k) {
            int item = (Integer)sTemp.get(k);
            Prefix prefixSStep = prefix.cloneSequence();
            prefixSStep.addItemset(new Itemset(item));
            Bitmap newBitmap = (Bitmap)sTempBitmaps.get(k);
            this.savePattern(prefixSStep, newBitmap);
            if (this.maximumPatternLength <= m) continue;
            this.dfsPruning(prefixSStep, newBitmap, sTemp, sTemp, item, m + 1, item);
        }
        Map<Integer, Integer> mapSupportItemsEquals = this.coocMapEquals.get(lastAppendedItem);
        ArrayList<Integer> iTemp = new ArrayList<Integer>();
        ArrayList<Bitmap> iTempBitmaps = new ArrayList<Bitmap>();
        for (Integer i : in) {
            Integer support;
            if (i <= hasToBeGreaterThanForIStep || this.useCMAPPruning && (mapSupportItemsEquals == null || (support = mapSupportItemsEquals.get(i)) == null || support < this.minsup)) continue;
            ++Bitmap.INTERSECTION_COUNT;
            Bitmap newBitmap = prefixBitmap.createNewBitmapIStep(this.verticalDB.get(i), this.sequencesSize, this.lastBitIndex);
            if (newBitmap.getSupport() < this.minsup) continue;
            iTemp.add(i);
            iTempBitmaps.add(newBitmap);
        }
        for (int k = 0; k < iTemp.size(); ++k) {
            int item = (Integer)iTemp.get(k);
            Prefix prefixIStep = prefix.cloneSequence();
            prefixIStep.getItemsets().get(prefixIStep.size() - 1).addItem(item);
            Bitmap newBitmap = (Bitmap)iTempBitmaps.get(k);
            this.savePattern(prefixIStep, newBitmap);
            if (this.maximumPatternLength <= m) continue;
            this.dfsPruning(prefixIStep, newBitmap, sTemp, iTemp, item, m + 1, item);
        }
        MemoryLogger.getInstance().checkMemory();
    }

    private void savePattern(Integer item, Bitmap bitmap) throws IOException {
        ++this.patternCount;
        StringBuilder r = new StringBuilder("");
        r.append(item);
        r.append(" -1 ");
        r.append("SUP: ");
        r.append(bitmap.getSupport());
        this.writer.write(r.toString());
        this.writer.newLine();
    }

    private void savePattern(Prefix prefix, Bitmap bitmap) throws IOException {
        ++this.patternCount;
        StringBuilder r = new StringBuilder("");
        for (Itemset itemset : prefix.getItemsets()) {
            for (Integer item : itemset.getItems()) {
                String string = item.toString();
                r.append(string);
                r.append(' ');
            }
            r.append("-1 ");
        }
        r.append("SUP: ");
        r.append(bitmap.getSupport());
        this.writer.write(r.toString());
        this.writer.newLine();
    }

    public void printStatistics() {
        StringBuilder r = new StringBuilder(200);
        r.append("=============  Algorithm - STATISTICS =============\n Total time ~ ");
        r.append(this.endTime - this.startTime);
        r.append(" ms\n");
        r.append(" Frequent sequences count : " + this.patternCount);
        r.append('\n');
        r.append(" Max memory (mb) : ");
        r.append(MemoryLogger.getInstance().getMaxMemory());
        r.append(this.patternCount);
        r.append('\n');
        r.append("minsup " + this.minsup);
        r.append('\n');
        r.append("Intersection count " + Bitmap.INTERSECTION_COUNT + " \n");
        r.append("===================================================\n");
        System.out.println(r.toString());
    }

    public int getMaximumPatternLength() {
        return this.maximumPatternLength;
    }

    public void setMaximumPatternLength(int maximumPatternLength) {
        this.maximumPatternLength = maximumPatternLength;
    }
}

