/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.dataStructures;

import ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.dataStructures.patterns.Pattern;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Sequences {
    public List<List<Pattern>> levels = new ArrayList<List<Pattern>>();
    public int numberOfFrequentSequences = 0;
    private String name;

    public Sequences(String name) {
        this.levels.add(new ArrayList());
        this.name = name;
    }

    public String toString() {
        StringBuilder r = new StringBuilder(200);
        r.append(this.name);
        int levelCount = 0;
        for (List<Pattern> level : this.levels) {
            r.append("\n***Level ").append(levelCount).append("***\n\n");
            for (Pattern sequence : level) {
                r.append(sequence.toString());
                r.append('\n');
            }
            ++levelCount;
        }
        return r.toString();
    }

    public String toStringToFile() {
        StringBuilder r = new StringBuilder(200);
        int levelCount = 0;
        if (this.levels != null) {
            for (List<Pattern> level : this.levels) {
                r.append("\n***Level ").append(levelCount).append("***\n\n");
                for (Pattern sequence : level) {
                    r.append(sequence.toStringToFile());
                    r.append('\n');
                }
                ++levelCount;
            }
        }
        return r.toString();
    }

    public void addSequence(Pattern sequence, int k) {
        while (this.levels.size() <= k) {
            this.levels.add(new ArrayList());
        }
        this.levels.get(k).add(sequence);
        ++this.numberOfFrequentSequences;
    }

    public List<Pattern> getLevel(int index) {
        return this.levels.get(index);
    }

    public int getLevelCount() {
        return this.levels.size();
    }

    public List<List<Pattern>> getLevels() {
        return this.levels;
    }

    public int size() {
        int total = 0;
        for (List<Pattern> level : this.levels) {
            total += level.size();
        }
        return total;
    }

    public void sort() {
        for (List<Pattern> nivel : this.levels) {
            Collections.sort(nivel);
        }
    }

    public void clear() {
        for (List<Pattern> nivel : this.levels) {
            nivel.clear();
        }
        this.levels.clear();
        this.levels = null;
    }

    public void addSequences(List<Pattern> list) {
        for (Pattern p : list) {
            this.addSequence(p, p.size());
        }
    }
}

