/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.multidimensionalpatterns;

import ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.multidimensionalpatterns.MDPattern;
import java.util.ArrayList;
import java.util.List;

public class MDPatternsDatabase {
    private final List<MDPattern> patterns = new ArrayList<MDPattern>();
    private int[] valuesCountForDimension = null;

    public void addMDPattern(MDPattern pattern) {
        this.patterns.add(pattern);
        if (this.valuesCountForDimension == null) {
            this.valuesCountForDimension = new int[pattern.size()];
        } else {
            for (int i = 0; i < pattern.size(); ++i) {
                int value = pattern.get(i);
                if (value <= this.valuesCountForDimension[i] || value == 9999) continue;
                this.valuesCountForDimension[i] = value;
            }
        }
    }

    public void printDatabase() {
        System.out.println("============  MDPatterns Context ==========");
        System.out.println("Dimensions count : " + this.getDimensionCount());
        System.out.print("Number of value for each dimension  : ");
        for (int j : this.valuesCountForDimension) {
            System.out.print(" " + j + " ");
        }
        System.out.println();
        for (MDPattern pattern : this.patterns) {
            System.out.print(pattern.getId() + ":  ");
            pattern.print();
            System.out.println("");
        }
    }

    public int size() {
        return this.patterns.size();
    }

    public List<MDPattern> getMDPatterns() {
        return this.patterns;
    }

    public int getDimensionCount() {
        return this.valuesCountForDimension.length;
    }
}

