/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.clospan_AGP.items;

import ca.pfv.spmf.algorithms.sequentialpatterns.clospan_AGP.items.patterns.Pattern;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class Sequences {
    public List<List<Pattern>> levels = new ArrayList<List<Pattern>>();
    public int nbSequeencesFrequentes = 0;
    private final String name;

    public Sequences(String name) {
        this.name = name;
        this.levels.add(new ArrayList());
    }

    public String toString() {
        StringBuilder r = new StringBuilder(200);
        int levelCount = 0;
        if (this.levels != null) {
            for (List<Pattern> level : this.levels) {
                r.append("\n***Level ").append(levelCount).append("***\n\n");
                for (Pattern sequence : level) {
                    r.append(sequence.toString());
                    r.append('\n');
                }
                ++levelCount;
            }
        }
        return r.toString();
    }

    public String toStringToFile() {
        StringBuilder r = new StringBuilder(200);
        int levelCount = 0;
        if (this.levels != null) {
            for (List<Pattern> level : this.levels) {
                r.append("\n***Level ").append(levelCount).append("***\n\n");
                for (Pattern sequence : level) {
                    r.append(sequence.toStringToFile());
                    r.append('\n');
                }
                ++levelCount;
            }
        }
        return r.toString();
    }

    public void addSequence(Pattern sequence, int k) {
        while (this.levels.size() <= k) {
            this.levels.add(new ArrayList());
        }
        this.levels.get(k).add(sequence);
        ++this.nbSequeencesFrequentes;
    }

    public List<Pattern> getLevel(int index) {
        return this.levels.get(index);
    }

    public int getLevelCount() {
        return this.levels.size();
    }

    public List<List<Pattern>> getLevels() {
        return this.levels;
    }

    public int size() {
        int total = 0;
        for (List<Pattern> level : this.levels) {
            total += level.size();
        }
        return total;
    }

    public void sort() {
        for (List<Pattern> nivel : this.levels) {
            Collections.sort(nivel, new patternComparator());
        }
    }

    public void clear() {
        if (this.levels != null) {
            for (List<Pattern> level : this.levels) {
                level.clear();
            }
            this.levels.clear();
            this.levels = null;
        }
    }

    private static class patternComparator
    implements Comparator<Pattern> {
        @Override
        public int compare(Pattern p1, Pattern p2) {
            for (int i = 0; i < p1.size(); ++i) {
                int comparison = p1.getIthElement(i).compareTo(p2.getIthElement(i));
                if (comparison == 0) continue;
                return comparison;
            }
            return 0;
        }
    }
}

