/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.clospan_AGP.items;

import ca.pfv.spmf.algorithms.sequentialpatterns.clospan_AGP.items.Item;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public final class Itemset {
    private List<Item> items = new ArrayList<Item>();
    int beginning = 0;
    private long timestamp = 0L;

    public Itemset(Item item, long timestamp) {
        this.addItem(item);
        this.setTimestamp(timestamp);
    }

    public Itemset(Itemset itemset, int beginning) {
        this.setTimestamp(itemset.getTimestamp());
        this.items = new ArrayList<Item>(this.items);
        this.beginning = beginning;
    }

    public Itemset(Collection<Item> collection, long timestamp) {
        for (Item item : collection) {
            this.addItem(item);
        }
        this.setTimestamp(timestamp);
    }

    public Itemset(Item[] collection, long timestamp) {
        for (Item item : collection) {
            this.addItem(item);
        }
        this.setTimestamp(timestamp);
    }

    public Itemset() {
    }

    public void addItem(Item value) {
        this.items.add(value);
    }

    public void addItem(int i, Item value) {
        this.items.set(i, value);
    }

    public void removeItem(Item value) {
        this.items.remove(value);
    }

    public Item removeItem(int i) {
        return this.items.remove(i);
    }

    public List<Item> getItems() {
        return this.items;
    }

    public Item get(int index) {
        return this.items.get(index);
    }

    public String toString() {
        StringBuilder r = new StringBuilder();
        for (Item attribute : this.items) {
            r.append(attribute.toString());
            r.append(' ');
        }
        return r.toString();
    }

    public Itemset cloneItemSet() {
        Itemset itemset = new Itemset();
        itemset.timestamp = this.timestamp;
        itemset.getItems().addAll(this.items);
        return itemset;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public int size() {
        return this.items.size();
    }

    Itemset cloneItemSetMinusItems(Map<Item, BitSet> mapSequenceID, double relativeMinSup) {
        Itemset itemset = new Itemset();
        itemset.timestamp = this.timestamp;
        for (Item item : this.items) {
            if (mapSequenceID.get(item) == null) continue;
            itemset.addItem(item);
        }
        return itemset;
    }

    public boolean equals(Object o) {
        Itemset param = (Itemset)o;
        if (param.size() - param.beginning != this.size() - this.beginning) {
            return false;
        }
        for (int i = this.beginning; i < this.items.size(); ++i) {
            if (this.items.get(i).equals(param.items.get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = 5;
        hash = 79 * hash + (this.items != null ? this.items.hashCode() : 0);
        hash = 79 * hash + this.beginning;
        return hash;
    }

    public int getBeginning() {
        return this.beginning;
    }

    public void setBeginning(int inicio) {
        this.beginning = inicio;
    }
}

