/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.BIDE_and_prefixspan;

import ca.pfv.spmf.algorithms.sequentialpatterns.BIDE_and_prefixspan.Pair;
import ca.pfv.spmf.algorithms.sequentialpatterns.BIDE_and_prefixspan.PseudoSequence;
import ca.pfv.spmf.algorithms.sequentialpatterns.BIDE_and_prefixspan.SequentialPattern;
import ca.pfv.spmf.algorithms.sequentialpatterns.BIDE_and_prefixspan.SequentialPatterns;
import ca.pfv.spmf.input.sequence_database_list_integers.Sequence;
import ca.pfv.spmf.input.sequence_database_list_integers.SequenceDatabase;
import ca.pfv.spmf.patterns.itemset_list_integers_without_support.Itemset;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AlgoPrefixSpan {
    long startTime;
    long endTime;
    int patternCount;
    private int minsuppAbsolute;
    BufferedWriter writer = null;
    private SequentialPatterns patterns = null;
    private int maximumPatternLength = Integer.MAX_VALUE;

    public SequentialPatterns runAlgorithm(SequenceDatabase database, double minsupRelative, String outputFilePath) throws IOException {
        this.minsuppAbsolute = (int)Math.ceil(minsupRelative * (double)database.size());
        if (this.minsuppAbsolute == 0) {
            this.minsuppAbsolute = 1;
        }
        this.startTime = System.currentTimeMillis();
        this.prefixSpan(database, outputFilePath);
        this.endTime = System.currentTimeMillis();
        if (this.writer != null) {
            this.writer.close();
        }
        return this.patterns;
    }

    public SequentialPatterns runAlgorithm(SequenceDatabase database, String outputFilePath, int minsup) throws IOException {
        this.patternCount = 0;
        MemoryLogger.getInstance().reset();
        this.minsuppAbsolute = minsup;
        this.startTime = System.currentTimeMillis();
        this.prefixSpan(database, outputFilePath);
        this.endTime = System.currentTimeMillis();
        if (this.writer != null) {
            this.writer.close();
        }
        return this.patterns;
    }

    private void prefixSpan(SequenceDatabase database, String outputFilePath) throws IOException {
        if (outputFilePath == null) {
            this.writer = null;
            this.patterns = new SequentialPatterns("FREQUENT SEQUENTIAL PATTERNS");
        } else {
            this.patterns = null;
            this.writer = new BufferedWriter(new FileWriter(outputFilePath));
        }
        Map<Integer, Set<Integer>> mapSequenceID = this.findSequencesContainingItems(database);
        ArrayList<PseudoSequence> initialDatabase = new ArrayList<PseudoSequence>();
        for (Sequence sequence : database.getSequences()) {
            Sequence optimizedSequence = sequence.cloneSequenceMinusItems(mapSequenceID, this.minsuppAbsolute);
            if (optimizedSequence.size() == 0) continue;
            initialDatabase.add(new PseudoSequence(optimizedSequence, 0, 0));
        }
        for (Map.Entry entry : mapSequenceID.entrySet()) {
            if (((Set)entry.getValue()).size() < this.minsuppAbsolute) continue;
            Integer item = (Integer)entry.getKey();
            SequentialPattern prefix = new SequentialPattern();
            prefix.addItemset(new Itemset(item));
            prefix.setSequenceIDs((Set)entry.getValue());
            this.savePattern(prefix);
            List<PseudoSequence> projectedContext = this.buildProjectedDatabaseForSingleItem(item, initialDatabase, (Set)entry.getValue());
            if (this.maximumPatternLength <= 1) continue;
            this.recursion(prefix, projectedContext, 2);
        }
    }

    private void savePattern(SequentialPattern prefix) throws IOException {
        ++this.patternCount;
        if (this.writer != null) {
            StringBuffer r = new StringBuffer("");
            for (Itemset itemset : prefix.getItemsets()) {
                for (Integer item : itemset.getItems()) {
                    r.append(item.toString());
                    r.append(' ');
                }
                r.append("-1 ");
            }
            r.append("#SUP: ");
            r.append(prefix.getAbsoluteSupport());
            this.writer.write(r.toString());
            this.writer.newLine();
        } else {
            this.patterns.addSequence(prefix, prefix.size());
        }
    }

    private Map<Integer, Set<Integer>> findSequencesContainingItems(SequenceDatabase database) {
        HashMap<Integer, Set<Integer>> mapSequenceID = new HashMap<Integer, Set<Integer>>();
        for (Sequence sequence : database.getSequences()) {
            for (List<Integer> itemset : sequence.getItemsets()) {
                for (Integer item : itemset) {
                    HashSet<Integer> sequenceIDs = (HashSet<Integer>)mapSequenceID.get(item);
                    if (sequenceIDs == null) {
                        sequenceIDs = new HashSet<Integer>();
                        mapSequenceID.put(item, sequenceIDs);
                    }
                    sequenceIDs.add(sequence.getId());
                }
            }
        }
        return mapSequenceID;
    }

    private List<PseudoSequence> buildProjectedDatabaseForSingleItem(Integer item, List<PseudoSequence> initialDatabase, Set<Integer> sidSet) {
        ArrayList<PseudoSequence> sequenceDatabase = new ArrayList<PseudoSequence>();
        for (PseudoSequence sequence : initialDatabase) {
            if (!sidSet.contains(sequence.getId())) continue;
            for (int i = 0; i < sequence.size(); ++i) {
                int index = sequence.indexOfBis(i, item);
                if (index == -1) continue;
                if (index == sequence.getSizeOfItemsetAt(i) - 1) {
                    if (i == sequence.size() - 1) continue;
                    sequenceDatabase.add(new PseudoSequence(sequence, i + 1, 0));
                    continue;
                }
                sequenceDatabase.add(new PseudoSequence(sequence, i, index + 1));
            }
        }
        return sequenceDatabase;
    }

    private List<PseudoSequence> buildProjectedDatabase(Integer item, List<PseudoSequence> database, Set<Integer> sidset, boolean inPostFix) {
        ArrayList<PseudoSequence> sequenceDatabase = new ArrayList<PseudoSequence>();
        for (PseudoSequence sequence : database) {
            if (!sidset.contains(sequence.getId())) continue;
            for (int i = 0; i < sequence.size(); ++i) {
                int index;
                if (sequence.isPostfix(i) != inPostFix || (index = sequence.indexOfBis(i, item)) == -1) continue;
                if (index == sequence.getSizeOfItemsetAt(i) - 1) {
                    if (i == sequence.size() - 1) continue;
                    sequenceDatabase.add(new PseudoSequence(sequence, i + 1, 0));
                    continue;
                }
                sequenceDatabase.add(new PseudoSequence(sequence, i, index + 1));
            }
        }
        return sequenceDatabase;
    }

    private void recursion(SequentialPattern prefix, List<PseudoSequence> database, int k) throws IOException {
        Set<Pair> pairs = this.findAllFrequentPairs(database);
        for (Pair pair : pairs) {
            if (pair.getCount() < this.minsuppAbsolute) continue;
            SequentialPattern newPrefix = pair.isPostfix() ? this.appendItemToPrefixOfSequence(prefix, pair.getItem()) : this.appendItemToSequence(prefix, pair.getItem());
            newPrefix.setSequenceIDs(pair.getSequenceIDs());
            List<PseudoSequence> projectedDatabase = this.buildProjectedDatabase(pair.getItem(), database, pair.getSequenceIDs(), pair.isPostfix());
            this.savePattern(newPrefix);
            if (k >= this.maximumPatternLength) continue;
            this.recursion(newPrefix, projectedDatabase, k + 1);
        }
        MemoryLogger.getInstance().checkMemory();
    }

    protected Set<Pair> findAllFrequentPairs(List<PseudoSequence> sequences) {
        HashMap<Pair, Pair> mapPairs = new HashMap<Pair, Pair>();
        for (PseudoSequence sequence : sequences) {
            for (int i = 0; i < sequence.size(); ++i) {
                for (int j = 0; j < sequence.getSizeOfItemsetAt(i); ++j) {
                    Integer item = sequence.getItemAtInItemsetAt(j, i);
                    Pair pair = new Pair(sequence.isPostfix(i), item);
                    Pair oldPair = (Pair)mapPairs.get(pair);
                    if (oldPair == null) {
                        mapPairs.put(pair, pair);
                    } else {
                        pair = oldPair;
                    }
                    pair.getSequenceIDs().add(sequence.getId());
                }
            }
        }
        MemoryLogger.getInstance().checkMemory();
        return mapPairs.keySet();
    }

    private SequentialPattern appendItemToSequence(SequentialPattern prefix, Integer item) {
        SequentialPattern newPrefix = prefix.cloneSequence();
        newPrefix.addItemset(new Itemset(item));
        return newPrefix;
    }

    private SequentialPattern appendItemToPrefixOfSequence(SequentialPattern prefix, Integer item) {
        SequentialPattern newPrefix = prefix.cloneSequence();
        Itemset itemset = newPrefix.get(newPrefix.size() - 1);
        itemset.addItem(item);
        return newPrefix;
    }

    public void printStatistics(int size) {
        StringBuffer r = new StringBuffer(200);
        r.append("=============  PREFIXSPAN - STATISTICS =============\n Total time ~ ");
        r.append(this.endTime - this.startTime);
        r.append(" ms\n");
        r.append(" Frequent sequences count : " + this.patternCount);
        r.append('\n');
        r.append(" Max memory (mb) : ");
        r.append(MemoryLogger.getInstance().getMaxMemory());
        r.append(this.patternCount);
        r.append('\n');
        r.append("===================================================\n");
        if (this.patterns != null) {
            this.patterns.printFrequentPatterns(size);
        }
        System.out.println(r.toString());
    }

    public int getMaximumPatternLength() {
        return this.maximumPatternLength;
    }

    public void setMaximumPatternLength(int maximumPatternLength) {
        this.maximumPatternLength = maximumPatternLength;
    }
}

