/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequential_rules.cmdeogun;

import ca.pfv.spmf.algorithms.sequential_rules.cmdeogun.Rule;
import ca.pfv.spmf.algorithms.sequential_rules.cmdeogun.Rules;
import ca.pfv.spmf.input.sequence_database_list_integers.Sequence;
import ca.pfv.spmf.input.sequence_database_list_integers.SequenceDatabase;
import ca.pfv.spmf.patterns.itemset_array_integers_with_tids.Itemset;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AlgoCMDeogun {
    long timeStart = 0L;
    long timeEnd = 0L;
    long timeStart11 = 0L;
    long timeEnd11 = 0L;
    public long timeEndPreprocessing = 0L;
    double minConfidence;
    int minsuppRelative;
    int maxItemId = 0;
    Map<Integer, Set<Integer>> mapItemCount;
    List<Integer> listFrequents = new ArrayList<Integer>();
    SequenceDatabase database;
    int minLeftSize = 0;
    int maxLeftSize = 500;
    int minRightSize = 0;
    int maxRightSize = 500;
    BufferedWriter writer = null;
    private int ruleCount;

    public void runAlgorithm(String input, String output, double absoluteMinSupport, double minConfidence) throws IOException {
        this.database = new SequenceDatabase();
        this.database.loadFile(input);
        this.minsuppRelative = (int)Math.ceil(absoluteMinSupport * (double)this.database.size());
        this.runAlgorithm(input, output, this.minsuppRelative, minConfidence);
    }

    public void runAlgorithm(String input, String output, int relativeSupport, double minConfidence) throws IOException {
        this.minConfidence = minConfidence;
        MemoryLogger.getInstance().reset();
        this.minsuppRelative = relativeSupport;
        if (this.minsuppRelative == 0) {
            this.minsuppRelative = 1;
        }
        if (this.database == null) {
            this.database = new SequenceDatabase();
            this.database.loadFile(input);
        }
        this.writer = new BufferedWriter(new FileWriter(output));
        this.timeStart = System.currentTimeMillis();
        this.removeItemsThatAreNotFrequent(this.database);
        this.listFrequents = new ArrayList<Integer>();
        for (int i = 0; i <= this.maxItemId; ++i) {
            if (this.mapItemCount.get(i) == null || this.mapItemCount.get(i).size() < this.minsuppRelative) continue;
            this.listFrequents.add(i);
        }
        this.timeEndPreprocessing = System.currentTimeMillis();
        this.start(this.mapItemCount);
        this.timeEnd = System.currentTimeMillis();
        this.writer.close();
        this.database = null;
    }

    private void start(Map<Integer, Set<Integer>> mapItemCount) throws IOException {
        this.timeStart11 = System.currentTimeMillis();
        Rules ruleSize11 = new Rules("candidate size 11");
        for (int i = 0; i < this.listFrequents.size(); ++i) {
            Integer intI = this.listFrequents.get(i);
            Set<Integer> tidsI = mapItemCount.get(intI);
            for (int j = i + 1; j < this.listFrequents.size(); ++j) {
                Integer intJ = this.listFrequents.get(j);
                Set<Integer> tidsJ = mapItemCount.get(intJ);
                ArrayList<Integer> commonTids = new ArrayList<Integer>();
                for (Integer tid : tidsI) {
                    if (!tidsJ.contains(tid)) continue;
                    commonTids.add(tid);
                }
                if (commonTids.size() < this.minsuppRelative) continue;
                this.generateRuleSize11(intI, tidsI, intJ, tidsJ, commonTids, ruleSize11);
            }
        }
        this.timeEnd11 = System.currentTimeMillis();
        if (this.maxLeftSize > 1) {
            this.performLeftExpansion(ruleSize11);
        }
        if (this.maxRightSize > 1) {
            this.performRightExpansion(ruleSize11);
        }
    }

    private void generateRuleSize11(Integer item1, Set<Integer> tids1, Integer item2, Set<Integer> tids2, List<Integer> commonTids, Rules ruleSize11) throws IOException {
        Itemset itemset2;
        Itemset itemset1;
        int countLeftBeforeRight = 0;
        int countRightBeforeLeft = 0;
        for (Integer tid : commonTids) {
            int firstOccurence1 = -1;
            int firstOccurence2 = -1;
            boolean saw1before2 = false;
            boolean saw2before1 = false;
            List<List<Integer>> itemsets = this.database.getSequences().get(tid).getItemsets();
            for (int i = 0; i < itemsets.size(); ++i) {
                for (Integer item : itemsets.get(i)) {
                    if (item.equals(item1)) {
                        if (firstOccurence1 == -1) {
                            firstOccurence1 = i;
                        }
                        if (firstOccurence2 <= -1 || firstOccurence2 >= i) continue;
                        saw2before1 = true;
                        continue;
                    }
                    if (!item.equals(item2)) continue;
                    if (firstOccurence2 == -1) {
                        firstOccurence2 = i;
                    }
                    if (firstOccurence1 <= -1 || firstOccurence1 >= i) continue;
                    saw1before2 = true;
                }
            }
            if (saw2before1) {
                ++countRightBeforeLeft;
            }
            if (!saw1before2) continue;
            ++countLeftBeforeRight;
        }
        if (countLeftBeforeRight >= this.minsuppRelative) {
            itemset1 = new Itemset(item1);
            itemset1.setTIDs(tids1);
            itemset2 = new Itemset(item2);
            itemset2.setTIDs(tids2);
            Rule ruleLR = new Rule(itemset1, itemset2);
            ruleLR.setTransactioncount(countLeftBeforeRight);
            ruleSize11.addRule(ruleLR);
            if (ruleLR.getConfidence() >= this.minConfidence && ruleLR.getItemset1().size() >= this.minLeftSize && ruleLR.getItemset2().size() >= this.minRightSize) {
                this.saveRule(ruleLR.getRelativeSupport(), ruleLR.getConfidence(), ruleLR.getItemset1(), ruleLR.getItemset2());
            }
        }
        if (countRightBeforeLeft >= this.minsuppRelative) {
            itemset1 = new Itemset(item1);
            itemset1.setTIDs(tids1);
            itemset2 = new Itemset(item2);
            itemset2.setTIDs(tids2);
            Rule ruleRL = new Rule(itemset2, itemset1);
            ruleRL.setTransactioncount(countRightBeforeLeft);
            ruleSize11.addRule(ruleRL);
            if (ruleRL.getConfidence() >= this.minConfidence && ruleRL.getItemset1().size() >= this.minLeftSize && ruleRL.getItemset2().size() >= this.minRightSize) {
                this.saveRule(countRightBeforeLeft, ruleRL.getConfidence(), itemset2, itemset1);
            }
        }
    }

    private void performLeftExpansion(Rules ruleSizeKm1) throws IOException {
        Rules ruleSizeK = new Rules("Candidates");
        for (int i = 0; i < ruleSizeKm1.getRulesCount(); ++i) {
            Rule ruleI = ruleSizeKm1.getRules().get(i);
            for (int j = i + 1; j < ruleSizeKm1.getRulesCount(); ++j) {
                Rule ruleJ = ruleSizeKm1.getRules().get(j);
                if (!ruleI.getItemset2().isEqualTo(ruleJ.getItemset2()) || !ruleI.getItemset1().allTheSameExceptLastItemV2(ruleJ.getItemset1())) continue;
                int[] newItemset = new int[ruleI.getItemset1().size() + 1];
                System.arraycopy(ruleI.getItemset1().itemset, 0, newItemset, 0, ruleI.getItemset1().size());
                newItemset[ruleI.getItemset1().size()] = ruleJ.getItemset1().getItems()[ruleJ.getItemset1().size() - 1];
                Itemset newLeftItemset = new Itemset(newItemset);
                for (Integer id : ruleI.getItemset1().transactionsIds) {
                    if (!ruleJ.getItemset1().transactionsIds.contains(id)) continue;
                    newLeftItemset.transactionsIds.add(id);
                }
                Rule candidate = new Rule(newLeftItemset, ruleI.getItemset2());
                for (Integer tid : candidate.getItemset1().getTransactionsIds()) {
                    if (!candidate.getItemset2().transactionsIds.contains(tid)) continue;
                    this.calculateInterestingnessMeasures(candidate, this.database.getSequences().get(tid), true, false);
                }
                if (candidate.getRelativeSupport() < this.minsuppRelative) continue;
                ruleSizeK.addRule(candidate);
                if (!(candidate.getConfidence() >= this.minConfidence) || candidate.getItemset1().size() < this.minLeftSize || candidate.getItemset2().size() < this.minRightSize) continue;
                this.saveRule(candidate.getRelativeSupport(), candidate.getConfidence(), candidate.getItemset1(), candidate.getItemset2());
            }
        }
        if (ruleSizeK.getRulesCount() != 0 && ruleSizeK.getRules().get(0).getItemset1().size() < this.maxLeftSize) {
            this.performLeftExpansion(ruleSizeK);
        }
        MemoryLogger.getInstance().checkMemory();
    }

    private void performRightExpansion(Rules ruleSizeKm1) throws IOException {
        Rules ruleSizeK = new Rules("Candidates");
        for (int i = 0; i < ruleSizeKm1.getRulesCount(); ++i) {
            Rule ruleI = ruleSizeKm1.getRules().get(i);
            for (int j = i + 1; j < ruleSizeKm1.getRulesCount(); ++j) {
                Rule ruleJ = ruleSizeKm1.getRules().get(j);
                if (!ruleI.getItemset1().isEqualTo(ruleJ.getItemset1()) || !ruleI.getItemset2().allTheSameExceptLastItemV2(ruleJ.getItemset2())) continue;
                int[] newItemset = new int[ruleI.getItemset1().size() + 1];
                System.arraycopy(ruleI.getItemset2().itemset, 0, newItemset, 0, ruleI.getItemset2().size());
                newItemset[ruleI.getItemset2().size()] = ruleJ.getItemset2().getItems()[ruleJ.getItemset2().size() - 1];
                Itemset newRightItemset = new Itemset(newItemset);
                for (Integer id : ruleI.getItemset2().transactionsIds) {
                    if (!ruleJ.getItemset2().transactionsIds.contains(id)) continue;
                    newRightItemset.transactionsIds.add(id);
                }
                Rule candidate = new Rule(ruleI.getItemset1(), newRightItemset);
                for (Integer tid : candidate.getItemset1().getTransactionsIds()) {
                    if (!candidate.getItemset2().transactionsIds.contains(tid)) continue;
                    this.calculateInterestingnessMeasures(candidate, this.database.getSequences().get(tid), false, true);
                }
                if (candidate.getRelativeSupport() < this.minsuppRelative) continue;
                ruleSizeK.addRule(candidate);
                if (!(candidate.getConfidence() >= this.minConfidence) || candidate.getItemset1().size() < this.minLeftSize || candidate.getItemset2().size() < this.minRightSize) continue;
                this.saveRule(candidate.getRelativeSupport(), candidate.getConfidence(), candidate.getItemset1(), candidate.getItemset2());
            }
        }
        if (ruleSizeK.getRulesCount() != 0) {
            if (ruleSizeK.getRules().get(0).getItemset1().size() < this.maxLeftSize) {
                this.performLeftExpansion(ruleSizeK);
            }
            if (ruleSizeK.getRules().get(0).getItemset2().size() < this.maxRightSize) {
                this.performRightExpansion(ruleSizeK);
            }
        }
        MemoryLogger.getInstance().checkMemory();
    }

    private void calculateInterestingnessMeasures(Rule rule, Sequence sequence, boolean calculateTIDSLeftItemset, boolean calculateTIDSRightItemset) {
        int item;
        int j;
        List<Integer> itemset;
        int i;
        HashSet<Integer> setAlreadySeen = new HashSet<Integer>(rule.getItemset1().size() * 3);
        block0: for (i = 0; i < sequence.getItemsets().size(); ++i) {
            itemset = sequence.get(i);
            for (j = 0; j < itemset.size(); ++j) {
                item = itemset.get(j);
                if (!rule.getItemset1().contains(item)) continue;
                setAlreadySeen.add(item);
                if (setAlreadySeen.size() == rule.getItemset1().size()) break block0;
            }
        }
        if (calculateTIDSLeftItemset) {
            rule.getItemset1().transactionsIds.add(sequence.getId());
        }
        ++i;
        setAlreadySeen.clear();
        while (i < sequence.getItemsets().size()) {
            itemset = sequence.get(i);
            for (j = 0; j < itemset.size(); ++j) {
                item = itemset.get(j);
                if (!rule.getItemset2().contains(item)) continue;
                setAlreadySeen.add(item);
                if (setAlreadySeen.size() != rule.getItemset2().size()) continue;
                if (calculateTIDSRightItemset) {
                    rule.getItemset2().transactionsIds.add(sequence.getId());
                }
                rule.incrementTransactionCount();
                return;
            }
            ++i;
        }
    }

    private Map<Integer, Set<Integer>> removeItemsThatAreNotFrequent(SequenceDatabase sequences) {
        this.mapItemCount = new HashMap<Integer, Set<Integer>>();
        for (Sequence sequence : sequences.getSequences()) {
            for (List<Integer> itemset : sequence.getItemsets()) {
                for (int i = 0; i < itemset.size(); ++i) {
                    Set<Integer> tids = this.mapItemCount.get(itemset.get(i));
                    if (tids == null) {
                        tids = new HashSet<Integer>();
                        this.mapItemCount.put(itemset.get(i), tids);
                        if (itemset.get(i) > this.maxItemId) {
                            this.maxItemId = itemset.get(i);
                        }
                    }
                    tids.add(sequence.getId());
                }
            }
        }
        System.out.println("NUMBER OF DIFFERENT ITEMS : " + this.mapItemCount.size());
        for (Sequence sequence : sequences.getSequences()) {
            int i = 0;
            while (i < sequence.getItemsets().size()) {
                List<Integer> itemset;
                itemset = sequence.getItemsets().get(i);
                int j = 0;
                while (j < itemset.size()) {
                    double count = this.mapItemCount.get(itemset.get(j)).size();
                    if (count < (double)this.minsuppRelative) {
                        itemset.remove(j);
                        continue;
                    }
                    ++j;
                }
                if (itemset.size() == 0) {
                    sequence.getItemsets().remove(i);
                    continue;
                }
                ++i;
            }
        }
        return this.mapItemCount;
    }

    private void saveRule(int support, double confIJ, Itemset itemsetI, Itemset itemsetJ) throws IOException {
        int i;
        ++this.ruleCount;
        StringBuffer buffer = new StringBuffer();
        for (i = 0; i < itemsetI.size(); ++i) {
            buffer.append(itemsetI.get(i));
            if (i == itemsetI.size() - 1) continue;
            buffer.append(",");
        }
        buffer.append(" ==> ");
        for (i = 0; i < itemsetJ.size(); ++i) {
            buffer.append(itemsetJ.get(i));
            if (i == itemsetJ.size() - 1) continue;
            buffer.append(",");
        }
        buffer.append(" #SUP: ");
        buffer.append(support);
        buffer.append(" #CONF: ");
        buffer.append(confIJ);
        this.writer.write(buffer.toString());
        this.writer.newLine();
    }

    public void printStats() {
        System.out.println("=============  SEQUENTIAL RULES - STATS =============");
        System.out.println("Sequential rules count: " + this.ruleCount);
        System.out.println("Total time : " + (this.timeEnd - this.timeStart) + " ms");
        System.out.println("Max memory: " + MemoryLogger.getInstance().getMaxMemory());
        System.out.println("===================================================");
    }

    public void setMinLeftSize(int minLeftSize) {
        this.minLeftSize = minLeftSize;
    }

    public void setMaxLeftSize(int maxLeftSize) {
        this.maxLeftSize = maxLeftSize;
    }

    public void setMinRightSize(int minRightSize) {
        this.minRightSize = minRightSize;
    }

    public void setMaxRightSize(int maxRightSize) {
        this.maxRightSize = maxRightSize;
    }
}

