/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.two_phase;

import ca.pfv.spmf.algorithms.frequentpatterns.two_phase.ItemsetTP;
import ca.pfv.spmf.algorithms.frequentpatterns.two_phase.ItemsetsTP;
import ca.pfv.spmf.algorithms.frequentpatterns.two_phase.TransactionTP;
import ca.pfv.spmf.algorithms.frequentpatterns.two_phase.UtilityTransactionDatabaseTP;
import ca.pfv.spmf.tools.MemoryLogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class AlgoTwoPhase {
    private ItemsetsTP highUtilityItemsets = null;
    protected UtilityTransactionDatabaseTP database;
    int minUtility;
    long startTimestamp = 0L;
    long endTimestamp = 0L;
    private int candidatesCount;

    public ItemsetsTP runAlgorithm(UtilityTransactionDatabaseTP database, int minUtility) {
        int candidateCount;
        this.database = database;
        this.minUtility = minUtility;
        MemoryLogger.getInstance().reset();
        this.startTimestamp = System.currentTimeMillis();
        this.highUtilityItemsets = new ItemsetsTP("HIGH UTILITY ITEMSETS");
        this.candidatesCount = 0;
        ArrayList<ItemsetTP> candidatesSize1 = new ArrayList<ItemsetTP>();
        HashMap<Integer, HashSet<Integer>> mapItemTidsets = new HashMap<Integer, HashSet<Integer>>();
        HashMap<Integer, Integer> mapItemTWU = new HashMap<Integer, Integer>();
        int maxItem = Integer.MIN_VALUE;
        for (int i = 0; i < database.size(); ++i) {
            TransactionTP transaction = database.getTransactions().get(i);
            for (Integer item : transaction.getItems()) {
                HashSet<Integer> tidset;
                if (item > maxItem) {
                    maxItem = item;
                }
                if ((tidset = (HashSet<Integer>)mapItemTidsets.get(item)) == null) {
                    tidset = new HashSet<Integer>();
                    mapItemTidsets.put(item, tidset);
                }
                tidset.add(i);
                Integer sumUtility = (Integer)mapItemTWU.get(item);
                if (sumUtility == null) {
                    sumUtility = 0;
                }
                sumUtility = sumUtility + transaction.getTransactionUtility();
                mapItemTWU.put(item, sumUtility);
            }
        }
        for (int item = 0; item <= maxItem; ++item) {
            Integer estimatedUtility = (Integer)mapItemTWU.get(item);
            if (estimatedUtility == null || estimatedUtility < minUtility) continue;
            ItemsetTP itemset = new ItemsetTP();
            itemset.addItem(item);
            itemset.setTIDset((Set)mapItemTidsets.get(item));
            candidatesSize1.add(itemset);
            this.highUtilityItemsets.addItemset(itemset, itemset.size());
        }
        List<ItemsetTP> currentLevel = candidatesSize1;
        do {
            candidateCount = this.highUtilityItemsets.getItemsetsCount();
            currentLevel = this.generateCandidateSizeK(currentLevel, this.highUtilityItemsets);
        } while (candidateCount != this.highUtilityItemsets.getItemsetsCount());
        MemoryLogger.getInstance().checkMemory();
        this.candidatesCount = this.highUtilityItemsets.getItemsetsCount();
        for (List<ItemsetTP> level : this.highUtilityItemsets.getLevels()) {
            Iterator<ItemsetTP> iterItemset = level.iterator();
            while (iterItemset.hasNext()) {
                ItemsetTP candidate = iterItemset.next();
                for (TransactionTP transaction : database.getTransactions()) {
                    int transactionUtility = 0;
                    int matchesCount = 0;
                    for (int i = 0; i < transaction.size(); ++i) {
                        if (!candidate.getItems().contains(transaction.get(i))) continue;
                        transactionUtility += transaction.getItemsUtilities().get(i).intValue();
                        ++matchesCount;
                    }
                    if (matchesCount != candidate.size()) continue;
                    candidate.incrementUtility(transactionUtility);
                }
                if (candidate.getUtility() >= minUtility) continue;
                iterItemset.remove();
                this.highUtilityItemsets.decreaseCount();
            }
        }
        MemoryLogger.getInstance().checkMemory();
        this.endTimestamp = System.currentTimeMillis();
        return this.highUtilityItemsets;
    }

    protected List<ItemsetTP> generateCandidateSizeK(List<ItemsetTP> levelK_1, ItemsetsTP candidatesHTWUI) {
        block0: for (int i = 0; i < levelK_1.size(); ++i) {
            ItemsetTP itemset1 = levelK_1.get(i);
            block1: for (int j = i + 1; j < levelK_1.size(); ++j) {
                ItemsetTP itemset2 = levelK_1.get(j);
                for (int k = 0; k < itemset1.size(); ++k) {
                    if (k == itemset1.size() - 1) {
                        if (itemset1.getItems().get(k) < itemset2.get(k)) continue;
                        continue block0;
                    }
                    if (itemset1.getItems().get(k) < itemset2.get(k)) continue block1;
                    if (itemset1.getItems().get(k) > itemset2.get(k)) continue block0;
                }
                Integer missing = itemset2.get(itemset2.size() - 1);
                HashSet<Integer> tidset = new HashSet<Integer>();
                for (Integer val1 : itemset1.getTIDset()) {
                    if (!itemset2.getTIDset().contains(val1)) continue;
                    tidset.add(val1);
                }
                int twu = 0;
                for (Integer tid : tidset) {
                    twu += this.database.getTransactions().get(tid).getTransactionUtility();
                }
                if (twu < this.minUtility) continue;
                ItemsetTP candidate = new ItemsetTP();
                for (int k = 0; k < itemset1.size(); ++k) {
                    candidate.addItem(itemset1.get(k));
                }
                candidate.addItem(missing);
                candidate.setTIDset(tidset);
                candidatesHTWUI.addItemset(candidate, candidate.size());
            }
        }
        return candidatesHTWUI.getLevels().get(candidatesHTWUI.getLevels().size() - 1);
    }

    public void printStats() {
        System.out.println("=============  TWO-PHASE ALGORITHM - STATS =============");
        System.out.println(" Transactions count from database : " + this.database.size());
        System.out.println(" Candidates count : " + this.candidatesCount);
        System.out.println(" High-utility itemsets count : " + this.highUtilityItemsets.getItemsetsCount());
        System.out.println(" Total time ~ " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println("===================================================");
    }
}

